/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;

public class LineNumberAttribute
extends AttributeInfo {
    public static final String tag = "LineNumberTable";

    /*
     * WARNING - void declaration
     */
    LineNumberAttribute(ConstPool cp, int n2, DataInputStream in) throws IOException {
        super((ConstPool)var1_1, (int)var2_2, (DataInputStream)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private LineNumberAttribute(ConstPool cp, byte[] i2) {
        super((ConstPool)var1_1, tag, (byte[])var2_2);
        void var2_2;
        void var1_1;
    }

    public int tableLength() {
        return ByteArray.readU16bit(this.b, 0);
    }

    /*
     * WARNING - void declaration
     */
    public int startPc(int i2) {
        void var1_1;
        return ByteArray.readU16bit(this.b, (int)((var1_1 << 2) + 2));
    }

    /*
     * WARNING - void declaration
     */
    public int lineNumber(int i2) {
        void var1_1;
        return ByteArray.readU16bit(this.b, (int)((var1_1 << 2) + 4));
    }

    public int toLineNumber(int pc) {
        int n2;
        int n3 = this.tableLength();
        for (n2 = 0; n2 < n3; ++n2) {
            if (pc >= this.startPc(n2)) continue;
            if (n2 != 0) break;
            return this.lineNumber(0);
        }
        return this.lineNumber(n2 - 1);
    }

    public int toStartPc(int line) {
        int n2 = this.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (line != this.lineNumber(i2)) continue;
            return this.startPc(i2);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public Pc toNearPc(int line) {
        void var1_1;
        int n2 = this.tableLength();
        int n3 = 0;
        int n4 = 0;
        if (n2 > 0) {
            n4 = this.lineNumber(0) - line;
            n3 = this.startPc(0);
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            int n5 = this.lineNumber(i2) - line;
            if ((n5 >= 0 || n5 <= n4) && (n5 < 0 || n5 >= n4 && n4 >= 0)) continue;
            n4 = n5;
            n3 = this.startPc(i2);
        }
        Pc pc = new Pc();
        new Pc().index = n3;
        pc.line = var1_1 + n4;
        return pc;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AttributeInfo copy(ConstPool newCp, Map classnames) {
        void var1_1;
        byte[] byArray = this.b;
        int n2 = this.b.length;
        byte[] byArray2 = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray2[i2] = byArray[i2];
        }
        LineNumberAttribute lineNumberAttribute = new LineNumberAttribute((ConstPool)var1_1, byArray2);
        return lineNumberAttribute;
    }

    final void a(int n2, int n3, boolean bl) {
        int n4 = this.tableLength();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = (i2 << 2) + 2;
            int n6 = ByteArray.readU16bit(this.b, n5);
            if (n6 <= n2 && (!bl || n6 != n2)) continue;
            ByteArray.write16bit(n6 + n3, this.b, n5);
        }
    }

    public static class Pc {
        public int index;
        public int line;
    }
}

