/*
 * Decompiled with CFR 0.152.
 */
package tableCell;

import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.WebBrowser;
import dbaut.comp.DbaMenu;
import dbaut.comp.DbaMenuItem;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dbaut.util.JdbcUtil;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import queryAnalyzer.AsTableModel;
import queryAnalyzer.QueryFrame;
import tableCell.BlobCellObject;
import tableCell.BlobEditor;
import tableCell.BlobEditorButtonInterface;

public class BlobEditorNoJAIButton
extends JButton
implements BlobEditorButtonInterface {
    private DBAResourceBundle res = new DBAResourceBundle("resource.jsqltool", LocaleManager.getLocale());
    private BlobCellObject object = null;
    private BlobEditor editor = null;
    private JTable table = null;
    private AsTableModel model = null;
    private static int displayClobMaxSize = 10240;
    private static int bufferSize = 1024;
    private static int displayBlobMaxSize = 0x300000;
    private Object[] tmpfiles = new Object[]{new String[]{"html", "H", "html"}, new String[]{"word document", "H", "DOC"}, new String[]{"pdf document", "P", "PDF"}, new String[]{"rtf document", "R", "RTF"}, new String[]{"wav audio", "U", "WAV"}, new String[]{"avi vedio", "V", "AVI"}};

    public BlobEditorNoJAIButton() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setTableAndModel(JTable table, AsTableModel model) {
        this.table = table;
        this.model = model;
    }

    @Override
    public void setEditor(BlobEditor editor) {
        this.editor = editor;
    }

    @Override
    public BlobCellObject getValue() {
        return this.object;
    }

    @Override
    public void setValue(BlobCellObject object) {
        this.object = object;
        if (object != null) {
            this.setText(object.toString());
        }
    }

    private void jbInit() throws Exception {
        this.setBorder(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BlobEditorNoJAIButton.this.this_mouseClicked(e);
            }
        });
    }

    void this_mouseClicked(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        DbaMenu viewer_menu = new DbaMenu("View", 'v');
        DbaMenuItem text = new DbaMenuItem("text", 't', new ReflectionAction(this, "text_actionPerformed"));
        viewer_menu.add(text);
        String[] t = null;
        if (QueryFrame.frame.isWindows) {
            for (int i = 0; i < this.tmpfiles.length; ++i) {
                t = (String[])this.tmpfiles[i];
                viewer_menu.add(new DbaMenuItem(t[0], t[1].charAt(0), new ReflectionAction(this, "tmpfile_actionPerformed")));
            }
        }
        if (!this.object.isNull) {
            viewer_menu.setEnabled(true);
        } else {
            viewer_menu.setEnabled(false);
        }
        menu.add(viewer_menu);
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void text_actionPerformed(ActionEvent e) {
        String total;
        byte[] ba;
        String title;
        block16: {
            if (this.object == null) {
                return;
            }
            title = this.object.column_name;
            InputStream in = null;
            Object stmt = null;
            Object rs = null;
            ba = null;
            total = null;
            Reader reader = null;
            long len = -1L;
            try {
                ResultSet vResultSet = this.object.getResultSet();
                int rowNum = this.object.getRowNum();
                int colNum = this.object.getColNum();
                System.out.println("get blob data, row: " + rowNum + " col: " + colNum);
                if (vResultSet != null && vResultSet.absolute(rowNum)) {
                    Clob c;
                    if (this.object.type.equalsIgnoreCase("long varchar") || this.object.type.equalsIgnoreCase("clob") || this.object.type.equalsIgnoreCase("longvarchar")) {
                        c = vResultSet.getClob(colNum);
                        len = c.length();
                        JdbcUtil.free(c);
                        in = vResultSet.getAsciiStream(colNum);
                    } else if (this.object.type.equalsIgnoreCase("nclob")) {
                        c = vResultSet.getClob(1);
                        len = c.length();
                        JdbcUtil.free(c);
                        reader = vResultSet.getCharacterStream(colNum);
                    } else {
                        Blob b = vResultSet.getBlob(colNum);
                        len = b.length();
                        JdbcUtil.free(b);
                        in = vResultSet.getBinaryStream(colNum);
                    }
                }
                if (in != null) {
                    int i = in.available();
                    if (i > displayClobMaxSize) {
                        String s1 = this.res.getString("Blob_lenght_is_too_big");
                        String s2 = GuiUt.mapStringForProperty(s1, Integer.toString(i));
                        GuiUt.showWarningDlg(QueryFrame.frame, this.res.getString("Warning"), s2);
                        i = displayClobMaxSize;
                    }
                    ba = new byte[i];
                    in.read(ba);
                    total = new String(ba).trim();
                }
                if (reader != null) {
                    if (len > (long)displayClobMaxSize) {
                        String s1 = this.res.getString("Blob_lenght_is_too_big");
                        String s2 = GuiUt.mapStringForProperty(s1, Long.toString(len));
                        GuiUt.showWarningDlg(QueryFrame.frame, this.res.getString("Warning"), s2);
                        len = displayClobMaxSize;
                    }
                    char[] cbuf = new char[(int)len / 2];
                    reader.read(cbuf);
                    total = new String(cbuf);
                }
                DbaObject.close(in);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                GuiUt.showErrorDlg(QueryFrame.frame, ex.getMessage(), null);
                break block16;
            }
            finally {
                DbaObject.close(in);
                DbaObject.close(reader);
            }
            DbaObject.close(reader);
        }
        JScrollPane panel = new JScrollPane();
        panel.setName("TextContentsPanel");
        if (total.length() == 0 && ba.length > 0) {
            String s1 = this.res.getString("Cannot_show_as_text_file_format");
            String s2 = GuiUt.mapStringForProperty(s1, title);
            GuiUt.showErrorDlg(QueryFrame.frame, s2, null);
            return;
        }
        JTextArea area = new JTextArea(total);
        area.setName("TextAreaContents");
        area.setEditable(false);
        panel.getViewport().add(area);
        JDialog dlg = new JDialog(QueryFrame.frame, title, true);
        dlg.setName("TextContentsDialog");
        dlg.getContentPane().add(panel);
        dlg.setSize(400, 300);
        GuiUt.setCenterLocation(QueryFrame.frame, dlg);
        dlg.setVisible(true);
        dlg.dispose();
    }

    public void tmpfile_actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        String[] t = null;
        for (int i = 0; i < this.tmpfiles.length; ++i) {
            t = (String[])this.tmpfiles[i];
            if (!s.equals(t[0])) continue;
            this.showTempFile(t[2]);
            return;
        }
    }

    private void showTempFile(String ext) {
        if (!this.object.isNull) {
            try {
                File f = File.createTempFile(this.object.column_name + "_temp", "." + ext);
                System.out.println("save as temp file " + f.getPath());
                WebBrowser.displayURL(QueryFrame.frame, f.getPath());
            }
            catch (Exception e) {
                GuiUt.showErrorDlg(QueryFrame.frame, e.getMessage(), null);
            }
        }
    }
}

