/*
 * Decompiled with CFR 0.152.
 */
package queryAnalyzer;

import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.VersionManager;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.SteppedComboBox;
import dbaut.locale.LocaleManager;
import dbaut.preference.CorePreferences;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.CharField;
import dbaut.textField.CharPasswordField;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import queryAnalyzer.DatabaseConnection;
import queryAnalyzer.HelpButton;
import queryAnalyzer.QueryFrame;

public class LoginDlg
extends JDialog {
    private DBAResourceBundle res = new DBAResourceBundle("resource.jsqltool", LocaleManager.getLocale());
    private static String localHostName = "";
    private static List<String> localIpAddress = new ArrayList<String>();
    private DbaButton okButton = new DbaButton(new Dimension(130, 20), this.res.getString("OK"), 'O', DBAImageResource.getResource(this.getClass(), "/dbaut/dbautimages/ok.gif"), new ReflectionAction(this, "okButton_actionPerformed"));
    private SteppedComboBox dbNameComboBox = null;
    private CharField userNameTextField = new CharField(128);
    private CharPasswordField passwordCharPasswordField = new CharPasswordField(16, true);
    public static String login_db;
    public static String login_user;
    public static String login_pw;
    private CorePreferences cp = CorePreferences.getCorePreferences();

    public LoginDlg(JFrame frame, boolean modal) {
        super((Frame)frame, modal);
        HelpButton helpButton = new HelpButton(new Dimension(130, 20));
        this.initialLocalHostInfo();
        this.setTitle("JSQL " + this.res.getString("Login"));
        this.getContentPane().setLayout(new BorderLayout());
        DbaButton cancelButton = new DbaButton(new Dimension(130, 20), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbaut/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButton_actionPerformed"));
        JdmConfig config = new JdmConfig();
        Vector dbnameVector = JdmConfig.getDatabaseNames("dmconfig.ini", false);
        dbnameVector.insertElementAt("", 0);
        DefaultComboBoxModel comboModel = new DefaultComboBoxModel(dbnameVector);
        config = null;
        this.dbNameComboBox = new SteppedComboBox((ComboBoxModel)comboModel);
        this.dbNameComboBox.setPreferredSize(new Dimension(200, 15));
        JLabel dbLabel = new JLabel(this.res.getString("Database"));
        dbLabel.setPreferredSize(new Dimension(80, 15));
        dbLabel.setHorizontalAlignment(4);
        JLabel userLabel = new JLabel(this.res.getString("User_name"));
        userLabel.setPreferredSize(new Dimension(80, 15));
        userLabel.setHorizontalAlignment(4);
        JLabel passwdLabel = new JLabel(this.res.getString("Password"));
        passwdLabel.setPreferredSize(new Dimension(80, 15));
        passwdLabel.setHorizontalAlignment(4);
        this.userNameTextField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.userNameTextField.setPreferredSize(new Dimension(200, 15));
        this.passwordCharPasswordField.setPreferredSize(new Dimension(200, 15));
        this.dbNameComboBox_actionPerformed(null);
        JPanel contentPane = new JPanel(new BorderLayout(5, 10));
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        JPanel mainPane = new JPanel(new BorderLayout(10, 10));
        JPanel secondPane = new JPanel(new BorderLayout(10, 10));
        secondPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel labelPane = new JPanel(new GridLayout(3, 1, 5, 5));
        JPanel inputPane = new JPanel(new GridLayout(3, 1, 5, 5));
        inputPane.setPreferredSize(new Dimension(200, 70));
        JPanel buttonPane = new JPanel(new GridLayout(3, 1, 1, 1));
        JPanel linePane = new JPanel();
        linePane.setBackground(Color.darkGray);
        linePane.setPreferredSize(new Dimension(2, 2));
        linePane.setMinimumSize(new Dimension(2, 2));
        secondPane.add((Component)linePane, "North");
        secondPane.add((Component)new JLabel(DBAImageResource.getResource(this.getClass(), "/images/jsql32.gif")), "West");
        DBAResourceBundle ress = new DBAResourceBundle("dbaut.dbautproperties.dbaut.Res", LocaleManager.getLocale());
        secondPane.add((Component)new JLabel(ress.getString("Copyright_c_1995_2001") + VersionManager.getBuildYear() + " " + VersionManager.getCompanyName() + ress.getString("Copyright_c_1995_2001_2") + ress.getString("All_Rights_Reserved"), 0), "Center");
        contentPane.add((Component)mainPane, "Center");
        contentPane.add((Component)secondPane, "South");
        mainPane.add((Component)labelPane, "West");
        mainPane.add((Component)inputPane, "Center");
        mainPane.add((Component)buttonPane, "East");
        mainPane.add((Component)secondPane, "South");
        labelPane.add(dbLabel);
        labelPane.add(userLabel);
        labelPane.add(passwdLabel);
        inputPane.add(this.dbNameComboBox);
        inputPane.add(this.userNameTextField);
        inputPane.add(this.passwordCharPasswordField);
        buttonPane.add(this.okButton);
        buttonPane.add(cancelButton);
        buttonPane.add(helpButton);
        this.setContentPane(contentPane);
        this.dbNameComboBox.addActionListener(new ReflectionAction(this, "dbNameComboBox_actionPerformed"));
        this.userNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    LoginDlg.this.userNameTextField_keyPressed(e);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                LoginDlg.this.userNameTextField_keyPressed(e);
            }
        });
        this.passwordCharPasswordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    LoginDlg.this.passwordCharPasswordField_keyPressed(e);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                LoginDlg.this.passwordCharPasswordField_keyPressed(e);
            }
        });
        LoginDlg loginDlg = this;
        String previousLoginDb = loginDlg.cp.getLoginDbName();
        if (previousLoginDb != null || previousLoginDb.length() > 0) {
            this.dbNameComboBox.setSelectedItem(previousLoginDb);
            this.dbNameComboBox_actionPerformed(null);
        } else {
            this.dbNameComboBox.setSelectedIndex(0);
        }
        QueryFrame.frame.enableDialogHelp(this.getRootPane(), helpButton, "LoginDlg", null);
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        if (QueryFrame.frame.isConnect) {
            QueryFrame.frame.menubar.disconnectItem.setEnabled(true);
            QueryFrame.frame.menubar.executeBatchItem.setEnabled(true);
            QueryFrame.frame.menubar.executeItem.setEnabled(true);
            QueryFrame.frame.menubar.saveItem.setEnabled(true);
            QueryFrame.frame.menubar.loadItem.setEnabled(true);
            QueryFrame.frame.queryToolbar.runCommandButton.setEnabled(true);
            QueryFrame.frame.queryToolbar.loadCommandButton.setEnabled(true);
            QueryFrame.frame.queryToolbar.saveCommandButton.setEnabled(true);
            QueryFrame.frame.queryToolbar.clearCommandButton.setEnabled(true);
            QueryFrame.frame.sqlTextArea.setEnabled(true);
        } else {
            QueryFrame.frame.menubar.disconnectItem.setEnabled(false);
            QueryFrame.frame.menubar.executeBatchItem.setEnabled(false);
            QueryFrame.frame.menubar.executeItem.setEnabled(false);
            QueryFrame.frame.menubar.saveItem.setEnabled(false);
            QueryFrame.frame.menubar.loadItem.setEnabled(false);
            QueryFrame.frame.queryToolbar.runCommandButton.setEnabled(false);
            QueryFrame.frame.queryToolbar.loadCommandButton.setEnabled(false);
            QueryFrame.frame.queryToolbar.saveCommandButton.setEnabled(false);
            QueryFrame.frame.queryToolbar.clearCommandButton.setEnabled(false);
            QueryFrame.frame.menubar.disconnectItem_actionPerformed(null);
            QueryFrame.frame.sqlTextArea.setEnabled(false);
        }
        this.setVisible(false);
        QueryFrame.frame.askFocus();
    }

    public void okButton_actionPerformed(ActionEvent ex) {
        if (QueryFrame.frame != null) {
            if (this.userNameTextField.getText().equalsIgnoreCase("")) {
                GuiUt.showInformationDlg(this, this.res.getString("Please_input_user_name"));
                return;
            }
            QueryFrame.frame.menubar.disconnectItem_actionPerformed(null);
        }
        login_db = this.dbNameComboBox.getSelectedItem().toString();
        login_user = this.userNameTextField.getText();
        login_pw = new String(this.passwordCharPasswordField.getPassword());
        CorePreferences.setLoginDbName(login_db);
        CorePreferences.setLoginIdName(login_user);
        this.setCursor(Cursor.getPredefinedCursor(3));
        DatabaseConnection connection = new DatabaseConnection(login_db, login_user, login_pw, this);
        this.setCursor(Cursor.getDefaultCursor());
        if (connection == null) {
            QueryFrame.frame.menubar.disconnectItem.setEnabled(false);
            QueryFrame.frame.menubar.executeBatchItem.setEnabled(false);
            QueryFrame.frame.menubar.executeItem.setEnabled(false);
            QueryFrame.frame.menubar.saveItem.setEnabled(false);
            QueryFrame.frame.menubar.loadItem.setEnabled(false);
            QueryFrame.frame.queryToolbar.runCommandButton.setEnabled(false);
            QueryFrame.frame.queryToolbar.loadCommandButton.setEnabled(false);
            QueryFrame.frame.queryToolbar.saveCommandButton.setEnabled(false);
            QueryFrame.frame.queryToolbar.clearCommandButton.setEnabled(false);
            QueryFrame.frame.sqlTextArea.setEnabled(false);
            return;
        }
        if (QueryFrame.frame.isConnect) {
            if (QueryFrame.frame.conn != null) {
                QueryFrame.frame.conn.disconnect();
            }
            QueryFrame.frame.conn = connection;
            QueryFrame.frame.menubar.disconnectItem.setEnabled(true);
            QueryFrame.frame.menubar.executeBatchItem.setEnabled(true);
            QueryFrame.frame.menubar.executeItem.setEnabled(true);
            QueryFrame.frame.menubar.saveItem.setEnabled(true);
            QueryFrame.frame.menubar.loadItem.setEnabled(true);
            QueryFrame.frame.queryToolbar.runCommandButton.setEnabled(true);
            QueryFrame.frame.queryToolbar.loadCommandButton.setEnabled(true);
            QueryFrame.frame.queryToolbar.saveCommandButton.setEnabled(true);
            QueryFrame.frame.queryToolbar.clearCommandButton.setEnabled(true);
            QueryFrame.frame.sqlTextArea.setEnabled(true);
            if (login_user.length() > 0 && QueryFrame.frame.conn.isIDCAP) {
                login_user = login_user.toUpperCase();
            }
        }
        boolean[] ba = LoginDlg.checkLoginUserPrivilege(connection);
        QueryFrame.frame.isDBA = ba[0];
        QueryFrame.frame.isResource = ba[1];
        QueryFrame.frame.setMessageField(this.res.getString("Database_connected"));
        QueryFrame.frame.setDBField(this.userNameTextField.getText());
        QueryFrame.frame.clearQueryPane();
        QueryFrame.frame.clearNonQueryPane();
        try {
            this.cp.save();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        this.setVisible(false);
        QueryFrame.frame.setTitle("JSQL - " + login_db);
    }

    public static boolean[] checkLoginUserPrivilege(DatabaseConnection conn) {
        Statement stmt = null;
        ResultSet rs = null;
        boolean b1 = true;
        boolean b2 = true;
        boolean[] bb = new boolean[]{b1, b2};
        try {
            stmt = conn.getDbConnection().createStatement();
            rs = stmt.executeQuery("SELECT DBA, RESOURCE FROM SYSAUTHUSER WHERE USER_NAME = '" + login_user + "'");
            while (rs.next()) {
                b1 = rs.getBoolean(1);
                b2 = rs.getBoolean(2);
            }
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        catch (SQLException sqldbae) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(QueryFrame.frame, null, sqldbae);
            b1 = false;
            b2 = false;
            sqldbae.printStackTrace();
        }
        bb[0] = b1;
        bb[1] = b2;
        return bb;
    }

    /*
     * Unable to fully structure code
     */
    public void dbNameComboBox_actionPerformed(ActionEvent ee) {
        block10: {
            block7: {
                block9: {
                    block8: {
                        config = new JdmConfig();
                        dbname = this.dbNameComboBox.getSelectedItem().toString();
                        if (dbname == "") break block7;
                        rc = config.fileOpen("dmconfig.ini", dbname, "r");
                        if (rc != 0) {
                            System.out.println("Error open dmconfig.ini via JdmConfig");
                            return;
                        }
                        username = "";
                        passwd = "";
                        v0 = this;
                        if (!dbname.equalsIgnoreCase(v0.cp.getLoginDbName())) break block8;
                        v1 = this;
                        if (v1.cp.getLoginIdName() == null) ** GOTO lbl-1000
                        v2 = this;
                        if (v2.cp.getLoginIdName().length() > 0) {
                            v3 = this;
                            username = v3.cp.getLoginIdName();
                        } else lbl-1000:
                        // 2 sources

                        {
                            username = (String)config.getPara("DB_USRID", 4096);
                            passwd = (String)config.getPara("DB_PASSWD", 4096);
                        }
                        break block9;
                    }
                    username = (String)config.getPara("DB_USRID", 4096);
                    passwd = (String)config.getPara("DB_PASSWD", 4096);
                }
                config.fileClose();
                if (username != null && username.length() > 0) {
                    this.userNameTextField.setText(username);
                }
                if (passwd != null && passwd.length() > 0) {
                    this.passwordCharPasswordField.setText(passwd);
                }
                config = null;
                break block10;
            }
            this.userNameTextField.setText("");
            this.passwordCharPasswordField.setText("");
        }
        if (this.dbNameComboBox.getSelectedIndex() > 0) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    public void initialLocalHostInfo() {
        boolean isup = true;
        this.initialLocalHostInfo(isup);
    }

    public void initialLocalHostInfo(boolean isup) {
        try {
            InetAddress ia = InetAddress.getLocalHost();
            localHostName = ia.getHostName();
            localIpAddress = JdmConfig.getLocalIP(isup);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public static boolean isLocalHost(String dbname) {
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", dbname, "r");
        if (rc != 0) {
            return false;
        }
        return config.isLocal(dbname);
    }

    void userNameTextField_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.userNameTextField.getText().length() > 0) {
            this.okButton_actionPerformed(null);
        }
    }

    void passwordCharPasswordField_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.userNameTextField.getText().length() > 0) {
            this.okButton_actionPerformed(null);
        }
    }
}

