/*
 * Decompiled with CFR 0.152.
 */
package queryAnalyzer;

import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.locale.LocaleManager;
import dbmaker.sql.JdbcOdbcConnection;
import java.awt.Component;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import queryAnalyzer.LoginDlg;
import queryAnalyzer.QueryFrame;

public class DatabaseConnection {
    private Connection dbconn = null;
    private final String dbLogin_String = "jdbc:dbmaker:";
    private final String dbDriverName_String = "dbmaker.sql.JdbcOdbcDriver";
    public boolean isSecure = true;
    public String dbname = "";
    public String username = "";
    public boolean isConnected = false;
    private String db_dir = "";
    private int blob_frame_size = 0;
    private Float fileversion = null;
    private Float version = null;
    public boolean isIDCAP = true;
    private boolean startDB = false;
    private Component dlg = null;

    public DatabaseConnection(String databaseName, String userName, String password, Component dlg) {
        this.dlg = dlg;
        Object stmt = null;
        Object rs = null;
        try {
            this.dbname = databaseName;
            this.username = userName;
            Class.forName("dbmaker.sql.JdbcOdbcDriver");
            JdmConfig config = new JdmConfig();
            if (config.isTerminalServer(this.dbname)) {
                System.setProperty("DM_DRIVER_MODE", "SINGLE_USER");
                if (!GuiUt.isWindows()) {
                    System.out.println("DM_CONNECT_MODE=START_DB");
                    System.setProperty("DM_CONNECT_MODE", "START_DB");
                    this.startDB = true;
                } else {
                    System.out.println("DM_CONNECT_MODE=CONNECT_DB");
                    System.setProperty("DM_CONNECT_MODE", "CONNECT_DB");
                }
            } else {
                System.out.println("DM_DRIVER_MODE=CLIENT_SERVER");
                System.setProperty("DM_DRIVER_MODE", "CLIENT_SERVER");
                System.out.println("DM_CONNECT_MODE=CONNECT_DB");
                System.setProperty("DM_CONNECT_MODE", "CONNECT_DB");
            }
            String errlcode = LocaleManager.getErrlcode();
            String conStr = "jdbc:dbmaker:" + this.dbname + ";errlcode=" + errlcode;
            this.dbconn = DriverManager.getConnection(conStr, this.username, password);
            this.dbconn.setAutoCommit(true);
            ((JdbcOdbcConnection)this.dbconn).setOption(1126, 2);
            ((JdbcOdbcConnection)this.dbconn).setOption(1136, 0);
            this.isIDCAP = ((JdbcOdbcConnection)this.dbconn).getOptionInt(28) == 1;
            this.getVersion();
            if (dlg instanceof LoginDlg) {
                QueryFrame.frame.isConnect = true;
                QueryFrame.frame.isLocalHost = LoginDlg.isLocalHost(databaseName);
            }
            this.isConnected = true;
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            if (dlg instanceof LoginDlg) {
                QueryFrame.frame.isConnect = false;
            }
            GuiUt.showSQLException(dlg, null, sqle);
            this.isConnected = false;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            GuiUt.showErrorDlg(dlg, ex.getMessage(), null);
            this.isConnected = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GuiUt.showErrorDlg(dlg, ex.getMessage(), null);
            this.isConnected = false;
        }
        DbaObject.close(rs);
        DbaObject.close(stmt);
    }

    public boolean isFileVersionLater35() {
        if (this.fileversion == null) {
            this.getVersion();
        }
        return this.fileversion != null && this.fileversion.floatValue() > 3.5f;
    }

    public boolean isVersionLaterOrEqual36() {
        if (this.version == null) {
            this.getVersion();
        }
        return this.version != null && this.version.floatValue() >= 3.6f;
    }

    private void getVersion() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            JdmConfig config = new JdmConfig();
            int rc = config.fileOpen("dmconfig.ini", this.dbname, "r");
            this.db_dir = (String)config.getPara("DB_DBDIR", 4096);
            if (this.db_dir != null) {
                this.db_dir = this.db_dir.trim();
            }
            config.fileClose();
            stmt = this.dbconn.createStatement();
            rs = stmt.executeQuery("SELECT VALUE FROM SYSTEM.SYSINFO WHERE INFO IN ('FILE_VERSION', 'VERSION') ORDER BY ID");
            if (rs.next()) {
                this.version = new Float(rs.getString(1));
            }
            if (rs.next()) {
                this.fileversion = new Float(rs.getString(1));
            }
            rs.close();
            if (this.version.floatValue() >= 3.6f) {
                rs = stmt.executeQuery("SELECT GETSYSINFO('DBDIR') FROM SYSTEM.SYSINFO");
                if (rs.next()) {
                    this.db_dir = rs.getString(1);
                    if (this.db_dir != null) {
                        this.db_dir = this.db_dir.trim();
                    }
                }
                rs.close();
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            GuiUt.showSQLException(this.dlg, null, sqle);
            DbaObject.close(rs);
        }
        DbaObject.close(stmt);
    }

    public Connection getDbConnection() {
        return this.dbconn;
    }

    public void disconnect() {
        try {
            if (this.dbconn != null) {
                if (this.startDB) {
                    System.out.println("DM_DISCONNECT_MODE=TERMINATE_DB");
                    System.setProperty("DM_DISCONNECT_MODE", "TERMINATE_DB");
                }
                this.dbconn.close();
            }
        }
        catch (SQLException E) {
            E.printStackTrace();
            if (E.getErrorCode() == 5307) {
                return;
            }
            GuiUt.showSQLException(QueryFrame.frame, null, E);
        }
    }

    public void setDBDir(String db_dir) {
        this.db_dir = db_dir != null ? db_dir.trim() : db_dir;
    }

    public String getDBDir() {
        return this.db_dir;
    }

    public void setBlobFrameSize(int size) {
        this.blob_frame_size = size;
    }

    public int getBlobFrameSize() {
        return this.blob_frame_size;
    }

    public Vector getUserNames() {
        Statement stmt = null;
        ResultSet rs = null;
        Vector<String> v = new Vector<String>();
        try {
            stmt = this.dbconn.createStatement();
            rs = stmt.executeQuery("SELECT USER_NAME FROM SYSAUTHUSER");
            while (rs.next()) {
                v.addElement(rs.getString(1));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException exc) {
            exc.printStackTrace();
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        v.insertElementAt("", 0);
        return v;
    }

    public boolean isLegalDatabaseObjectName(String s) {
        boolean b = true;
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (i == 0 && (Character.isLetter(c) || c == '_')) {
                b = true;
                continue;
            }
            if (i == 0) {
                b = false;
                return b;
            }
            if (Character.isSpaceChar(c)) {
                b = false;
                return b;
            }
            if (Character.isLetterOrDigit(c) || c == '_') {
                b = true;
                continue;
            }
            b = false;
            return b;
        }
        return b;
    }
}

