/*
 * Decompiled with CFR 0.152.
 */
package preferences;

import dbaut.preference.CorePreferences;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.xalan.xsltc.runtime.DefaultSAXOutputHandler;
import org.apache.xml.utils.TreeWalker;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import queryAnalyzer.QueryFrame;

public class PreferencesXml
extends CorePreferences {
    private Point position = new Point(0, 0);
    private boolean display_table_model = true;
    private int num_record = 50;
    private int num_history_cmd = 20;
    private String blobFilePath = null;
    private int frame_width = 800;
    private int frame_height = 600;
    private int divider_location = 160;
    private String selected_directory = null;
    private Element syscom = null;
    public String orString = null;
    public boolean isWindows = true;
    public String user_dir = null;
    public String file_separator = null;
    public static final int NUM_RECORD = 0;
    public static final int BLOB_FILE_PATH = 1;
    public static final int SELECTED_DIRECTORY = 2;
    public static final int NUM_HISTORY_CMD = 3;
    public static final int DISPLAY_TABLE_MODEL = 4;
    private static PreferencesXml self = null;

    public static void initPreferencesXml() {
        if (self == null) {
            self = new PreferencesXml();
        }
    }

    public static PreferencesXml getPreferencesXml() {
        if (self == null) {
            self = new PreferencesXml();
        }
        return self;
    }

    public PreferencesXml() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.file_separator = System.getProperty("file.separator");
        this.user_dir = System.getProperty("user.dir");
        this.isWindows = this.file_separator.equals("\\");
        this.init(CorePreferences.getConfigName());
    }

    private void init(String fileName) throws Exception {
        File f = new File(fileName);
        if (!f.exists()) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(fileName);
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        String temp = null;
        Node node = null;
        this.resetDOM(doc);
        node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/jsql");
        if (node != null && node.getNodeType() == 1 && (temp = ((Element)node).getAttribute("selected_directory")) != null && temp.length() > 0) {
            this.selected_directory = temp;
        }
        if ((node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/jsql/frame")) != null && node.getNodeType() == 1) {
            Element elm = (Element)node;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int xpos = 0;
            int ypos = 0;
            temp = elm.getAttribute("xpos");
            if (temp != null && temp.length() > 0 && ((xpos = Integer.parseInt(temp)) < 0 || (double)xpos > screenSize.getWidth())) {
                xpos = 0;
            }
            if ((temp = elm.getAttribute("ypos")) != null && temp.length() > 0 && ((ypos = Integer.parseInt(temp)) < 0 || (double)ypos > screenSize.getHeight())) {
                ypos = 0;
            }
            this.position = new Point(xpos, ypos);
            temp = elm.getAttribute("width");
            if (temp != null && temp.length() > 0) {
                this.frame_width = Integer.parseInt(temp);
                if (this.frame_width < 0) {
                    this.frame_width = 800;
                }
            }
            if ((temp = elm.getAttribute("height")) != null && temp.length() > 0) {
                this.frame_height = Integer.parseInt(temp);
                if (this.frame_height < 0) {
                    this.frame_height = 600;
                }
            }
            if ((temp = elm.getAttribute("divider_location")) != null && temp.length() > 0) {
                this.divider_location = Integer.parseInt(temp);
                if (this.divider_location < 0) {
                    this.divider_location = 0;
                }
            }
        }
        if ((node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/jsql/options")) != null && node.getNodeType() == 1) {
            temp = ((Element)node).getAttribute("num_record");
            if (temp != null && temp.length() > 0) {
                this.num_record = Integer.parseInt(temp);
            }
            if ((temp = ((Element)node).getAttribute("blob_file_path")) != null && temp.length() > 0) {
                this.blobFilePath = temp;
            }
            if ((temp = ((Element)node).getAttribute("num_history_cmd")) != null && temp.length() > 0) {
                this.num_history_cmd = Integer.parseInt(temp);
            }
            if ((temp = ((Element)node).getAttribute("display_table_model")) != null && temp.length() > 0) {
                this.display_table_model = temp.equalsIgnoreCase("true") ? true : !temp.equalsIgnoreCase("false");
            }
        }
    }

    public void updateVariables(int options, String value) {
        switch (options) {
            case 0: {
                this.num_record = Integer.parseInt(value);
                break;
            }
            case 1: {
                this.blobFilePath = value;
                break;
            }
            case 2: {
                this.selected_directory = value;
                break;
            }
            case 3: {
                this.num_history_cmd = Integer.parseInt(value);
                break;
            }
            case 4: {
                this.display_table_model = value.equals("true");
            }
        }
    }

    public Point getLocation() {
        return this.position;
    }

    public int getNumRecord() {
        return this.num_record;
    }

    public int getNumHistoryCmd() {
        return this.num_history_cmd;
    }

    public boolean getDisplayTableModel() {
        return this.display_table_model;
    }

    public String getBlobFilePath() {
        return this.blobFilePath;
    }

    public String getSelectedDirectory() {
        return this.selected_directory;
    }

    public int getFrameWidth() {
        return this.frame_width;
    }

    public int getFrameHeight() {
        return this.frame_height;
    }

    public int getDividerLocation() {
        return this.divider_location;
    }

    @Override
    public void save() {
        this.save(PreferencesXml.getConfigName());
    }

    private void save(String fileName) {
        this.frame_width = QueryFrame.frame.getWidth();
        this.frame_height = QueryFrame.frame.getHeight();
        this.divider_location = QueryFrame.frame.getDividerLocation();
        this.position = QueryFrame.frame.getLocationOnScreen();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Document doc = null;
        Element jsql2 = null;
        File file = new File(fileName);
        if (file.exists()) {
            try {
                doc = builder.parse(fileName);
            }
            catch (Exception pe) {
                doc = builder.newDocument();
            }
        } else {
            doc = builder.newDocument();
        }
        this.setDOM(doc);
        this.syscom = doc.getDocumentElement();
        if (this.syscom == null) {
            System.out.println("CorePreferences fails to save <syscom>");
        }
        jsql2 = doc.createElement("jsql");
        if (this.selected_directory != null && this.selected_directory.length() > 0) {
            jsql2.setAttribute("selected_directory", this.selected_directory);
        }
        Element frame = doc.createElement("frame");
        frame.setAttribute("width", Integer.toString(this.frame_width));
        frame.setAttribute("height", Integer.toString(this.frame_height));
        frame.setAttribute("divider_location", Integer.toString(this.divider_location));
        frame.setAttribute("xpos", Integer.toString((int)this.position.getX()));
        frame.setAttribute("ypos", Integer.toString((int)this.position.getY()));
        Element options = doc.createElement("options");
        String sss = null;
        options.setAttribute("num_record", Integer.toString(this.num_record));
        options.setAttribute("num_history_cmd", Integer.toString(this.num_history_cmd));
        sss = this.display_table_model ? "true" : "false";
        options.setAttribute("display_table_model", sss);
        if (this.blobFilePath != null && this.blobFilePath.length() > 0) {
            options.setAttribute("blob_file_path", this.blobFilePath);
        }
        jsql2.appendChild(frame);
        jsql2.appendChild(options);
        Node orig = null;
        try {
            orig = XPathAPI.selectSingleNode((Node)this.syscom, (String)"jsql");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        if (orig != null && orig.getNodeType() == 1) {
            this.syscom.replaceChild(jsql2, orig);
        } else {
            this.syscom.appendChild(jsql2);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            DefaultSAXOutputHandler handler = new DefaultSAXOutputHandler((OutputStream)out, "UTF-8");
            TreeWalker tw = new TreeWalker((ContentHandler)handler);
            tw.traverse((Node)doc);
            out.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

