/*
 * Decompiled with CFR 0.152.
 */
package dbaut.util;

public class PlatformUtil {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String SPACE = " ";
    private static final String OS_WINDOWS = "Windows";
    private static final String OS_WINDOWS_8 = "Windows 8";

    private PlatformUtil() {
    }

    public static boolean isKeyTypedEnabled() {
        return PlatformUtil.isWindows8();
    }

    public static boolean isWindows8() {
        return PlatformUtil.isWindows() && PlatformUtil.isSystemPropertyStartsWith(OS_NAME, OS_WINDOWS_8);
    }

    public static boolean isWindows() {
        return PlatformUtil.isSystemPropertyStartsWith(OS_NAME, OS_WINDOWS);
    }

    private static boolean isSystemPropertyStartsWith(String property, String prefix) {
        boolean result = false;
        if (property != null && property.startsWith(prefix)) {
            result = true;
        }
        return result;
    }
}

