/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.GuiUt;
import dbaut.textField.DbaTextField;
import java.awt.Toolkit;
import java.text.DecimalFormat;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class DecimalField
extends JTextField
implements DbaTextField {
    private int precision = 17;
    private int scale = 6;
    private DecimalFormat formatter = null;

    public DecimalField(int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
        this.formatter = new DecimalFormat();
        this.formatter.setGroupingSize(0);
        this.formatter.setDecimalSeparatorAlwaysShown(false);
        this.formatter.setMaximumFractionDigits(scale);
        this.formatter.setMinimumFractionDigits(scale);
    }

    @Override
    public Object getValue() {
        double retVal = 0.0;
        String t = this.getText();
        try {
            retVal = Double.parseDouble(t);
        }
        catch (NumberFormatException e) {
            if (t.length() > 0) {
                Toolkit.getDefaultToolkit().beep();
                GuiUt.showErrorDlg(this, t + " can't be formatted as Double", null);
            }
            return null;
        }
        return t;
    }

    @Override
    protected Document createDefaultModel() {
        return new DoubleDocument();
    }

    protected class DoubleDocument
    extends PlainDocument {
        protected DoubleDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            int size = str.length();
            for (int i = 0; i < size; ++i) {
                if (Character.isDigit(str.charAt(i)) || str.charAt(i) == '.' || str.charAt(i) == '-' || str.charAt(i) == 'E' || str.charAt(i) == 'e') continue;
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

