/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.textField.DBAHex;
import dbaut.textField.DbaTextField;
import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class BinaryField
extends JTextField
implements DbaTextField {
    private Toolkit toolkit;
    private BinaryField field = null;
    private BinaryField current = null;

    public BinaryField() {
        this(5);
    }

    public BinaryField(int columns) {
        super(columns);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.field = this;
        this.current = this;
        this.toolkit = Toolkit.getDefaultToolkit();
    }

    @Override
    public Object getValue() {
        return this.getText();
    }

    public void setValue(Object value) {
        this.setText(value.toString());
    }

    @Override
    protected Document createDefaultModel() {
        return new ByteDocument();
    }

    private void jbInit() throws Exception {
    }

    protected class ByteDocument
    extends PlainDocument {
        protected ByteDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            int length = str.length();
            for (int i = 0; i < length; ++i) {
                if (DBAHex.isHexDigit(str.charAt(i))) continue;
                BinaryField.this.toolkit.beep();
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

