/*
 * Decompiled with CFR 0.152.
 */
package dbaut.lookandfeel;

import dbaut.lookandfeel.DmxttBorders;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalButtonUI;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import javax.swing.plaf.metal.MetalToolBarUI;

public class DmxttToolBarUI
extends MetalToolBarUI {
    private static final DmxttToolBarUI toolBarUI = new DmxttToolBarUI();
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private static Border rolloverButtonBorder = new CompoundBorder(new DmxttBorders.RolloverButtonBorder(), new BasicBorders.MarginBorder());
    private static Border rolloverToggleBorder = new CompoundBorder(new DmxttBorders.RolloverJToggleButtonBorder(), new BasicBorders.MarginBorder());
    protected ContainerListener contListener;
    protected PropertyChangeListener rolloverListener;
    private Hashtable borderTable = new Hashtable();
    private Hashtable marginTable = new Hashtable();

    @Override
    public boolean isRolloverBorders() {
        return true;
    }

    public static ComponentUI createUI(JComponent c) {
        return toolBarUI;
    }

    @Override
    public void setBorderToRollover(Component c) {
        JToggleButton b;
        if (c instanceof JButton) {
            JButton b2 = (JButton)c;
            if (b2.getUI() instanceof MetalButtonUI) {
                if (b2.getBorder() instanceof UIResource) {
                    this.borderTable.put(b2, b2.getBorder());
                }
                if (b2.getBorder() instanceof UIResource) {
                    b2.setBorder(rolloverButtonBorder);
                }
                if (b2.getMargin() == null || b2.getMargin() instanceof UIResource) {
                    this.marginTable.put(b2, b2.getMargin());
                    b2.setMargin(insets0);
                }
                b2.setRolloverEnabled(true);
            }
        } else if (c instanceof JToggleButton && (b = (JToggleButton)c).getUI() instanceof MetalToggleButtonUI) {
            if (b.getBorder() instanceof UIResource) {
                this.borderTable.put(b, b.getBorder());
            }
            if (b.getBorder() instanceof UIResource) {
                b.setBorder(rolloverToggleBorder);
            }
            if (b.getMargin() == null || b.getMargin() instanceof UIResource) {
                this.marginTable.put(b, b.getMargin());
                b.setMargin(insets0);
            }
            b.setRolloverEnabled(true);
        }
    }

    @Override
    public void setBorderToNormal(Component c) {
        JToggleButton b;
        if (c instanceof JButton) {
            JButton b2 = (JButton)c;
            if (b2.getUI() instanceof MetalButtonUI) {
                if (b2.getBorder() == rolloverButtonBorder) {
                    b2.setBorder((Border)this.borderTable.remove(b2));
                }
                if (b2.getMargin() == insets0) {
                    b2.setMargin((Insets)this.marginTable.remove(b2));
                }
                b2.setRolloverEnabled(false);
            }
        } else if (c instanceof JToggleButton && (b = (JToggleButton)c).getUI() instanceof MetalToggleButtonUI) {
            if (b.getBorder() == rolloverToggleBorder) {
                b.setBorder((Border)this.borderTable.remove(b));
            }
            if (b.getMargin() == insets0) {
                b.setMargin((Insets)this.marginTable.remove(b));
            }
            b.setRolloverEnabled(false);
        }
    }
}

