/*
 * Decompiled with CFR 0.152.
 */
package dbaut.comp;

import dbaut.GuiUt;
import dbaut.comp.ReflectionAction;
import dbaut.comp.SteppedComboBoxUI;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class SteppedComboBox
extends JComboBox {
    protected int popupWidth;
    private ActionListener listener = null;

    public SteppedComboBox() {
        this.setUI(new SteppedComboBoxUI());
        this.popupWidth = 0;
        super.addActionListener(new ReflectionAction(this, "this_actionPerformed"));
    }

    public SteppedComboBox(ComboBoxModel aModel) {
        super(aModel);
        this.setUI(new SteppedComboBoxUI());
        this.popupWidth = this.initPreferredWidth();
        super.addActionListener(new ReflectionAction(this, "this_actionPerformed"));
    }

    public SteppedComboBox(Object[] items) {
        super(items);
        this.setUI(new SteppedComboBoxUI());
        this.popupWidth = this.initPreferredWidth();
        super.addActionListener(new ReflectionAction(this, "this_actionPerformed"));
    }

    public SteppedComboBox(Vector items) {
        super(items);
        this.setUI(new SteppedComboBoxUI());
        this.popupWidth = this.initPreferredWidth();
        super.addActionListener(new ReflectionAction(this, "this_actionPerformed"));
    }

    public void setModel(ComboBoxModel model) {
        super.setModel(model);
        this.popupWidth = this.initPreferredWidth();
    }

    private int initPreferredWidth() {
        int maxwidth = 0;
        int curwidth = 0;
        int size = this.getItemCount();
        FontMetrics fm = GuiUt.getFontMetrics();
        char[] ca = null;
        for (int i = 0; i < size; ++i) {
            ca = this.getItemAt(i).toString().toCharArray();
            curwidth = fm.charsWidth(ca, 0, ca.length);
            maxwidth = curwidth > maxwidth ? curwidth : maxwidth;
        }
        return maxwidth + 20;
    }

    public Dimension getPopupSize() {
        Dimension size = this.getSize();
        if (this.popupWidth < 1 || this.popupWidth < size.width) {
            this.popupWidth = size.width;
        }
        return new Dimension(this.popupWidth, size.height);
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.listener = l;
    }

    public void this_actionPerformed(ActionEvent e) {
        Object obj = this.getSelectedItem();
        if (obj != null) {
            if (obj.toString().trim().length() > 0) {
                this.setToolTipText(this.getSelectedItem().toString());
            } else {
                this.setToolTipText(null);
            }
        }
        if (this.listener != null) {
            this.listener.actionPerformed(e);
        }
    }
}

