/*
 * Decompiled with CFR 0.152.
 */
package dbaut;

import dbaut.CommonDatabaseConnectionInterface;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.locale.LocaleManager;
import dbmaker.sql.JdbcOdbcConnection;
import java.awt.Component;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SyscomCommonDatabaseConnection
implements CommonDatabaseConnectionInterface {
    private Connection dbconn = null;
    private final String dbLogin_String = "jdbc:dbmaker:";
    private final String dbDriverName_String = "dbmaker.sql.JdbcOdbcDriver";
    public String dbname = "";
    public String username = "";
    public boolean isConnected = false;
    private String db_dir = "";
    private Float fileversion = null;
    private Float version = null;
    public boolean isDBA = false;
    private Component dlg = null;
    public boolean isIDCAP = true;
    private boolean startDB = false;

    public SyscomCommonDatabaseConnection(String databaseName, String userName, String password, Component dlg) {
        Object stmt = null;
        Object rs = null;
        try {
            this.dbname = databaseName;
            this.dlg = dlg;
            Class.forName("dbmaker.sql.JdbcOdbcDriver");
            JdmConfig config = new JdmConfig();
            if (config.isTerminalServer(this.dbname)) {
                System.setProperty("DM_DRIVER_MODE", "SINGLE_USER");
                if (!GuiUt.isWindows()) {
                    System.setProperty("DM_CONNECT_MODE", "START_DB");
                    this.startDB = true;
                } else {
                    System.setProperty("DM_CONNECT_MODE", "CONNECT_DB");
                }
            } else {
                System.setProperty("DM_DRIVER_MODE", "CLIENT_SERVER");
                System.setProperty("DM_CONNECT_MODE", "CONNECT_DB");
            }
            String errlcode = LocaleManager.getErrlcode();
            String conStr = "jdbc:dbmaker:" + this.dbname + ";errlcode=" + errlcode;
            this.dbconn = DriverManager.getConnection(conStr, userName, password);
            this.dbconn.setAutoCommit(true);
            ((JdbcOdbcConnection)this.dbconn).setOption(1126, 2);
            ((JdbcOdbcConnection)this.dbconn).setOption(1136, 0);
            this.isConnected = true;
            boolean bl = this.isIDCAP = ((JdbcOdbcConnection)this.dbconn).getOptionInt(28) == 1;
            this.username = this.isIDCAP ? userName.toUpperCase() : userName;
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(dlg, null, sqle);
            this.isConnected = false;
        }
        catch (ClassNotFoundException ex) {
            GuiUt.showErrorDlg(dlg, ex.getMessage(), null);
            this.isConnected = false;
        }
        catch (Exception ex) {
            GuiUt.showErrorDlg(dlg, ex.getMessage(), null);
            this.isConnected = false;
        }
        DbaObject.close(rs);
        DbaObject.close(stmt);
    }

    public boolean isFileVersionLater35() {
        return this.fileversion != null && this.fileversion.floatValue() > 3.5f;
    }

    public boolean isVersionLaterOrEqual36() {
        return this.version != null && this.version.floatValue() >= 3.6f;
    }

    public float getFileVersion() {
        if (!this.isConnected) {
            return 0.0f;
        }
        if (this.fileversion != null) {
            return this.fileversion.floatValue();
        }
        this.getVersion();
        if (this.fileversion != null) {
            return this.fileversion.floatValue();
        }
        return 0.0f;
    }

    public float getDBMakerVersion() {
        if (!this.isConnected) {
            return 0.0f;
        }
        if (this.version != null) {
            return this.version.floatValue();
        }
        this.getVersion();
        if (this.version != null) {
            return this.version.floatValue();
        }
        return 0.0f;
    }

    private void getVersion() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            JdmConfig config = new JdmConfig();
            int rc = config.fileOpen("dmconfig.ini", this.dbname, "r");
            this.db_dir = (String)config.getPara("DB_DBDIR", 4096);
            if (this.db_dir != null) {
                this.db_dir = this.db_dir.trim();
            }
            config.fileClose();
            stmt = this.dbconn.createStatement();
            rs = stmt.executeQuery("SELECT VALUE FROM SYSTEM.SYSINFO WHERE INFO IN ('FILE_VERSION', 'VERSION') ORDER BY ID");
            if (rs.next()) {
                this.version = new Float(rs.getString(1));
            }
            if (rs.next()) {
                this.fileversion = new Float(rs.getString(1));
            }
            rs.close();
            if (this.version.floatValue() >= 3.6f) {
                rs = stmt.executeQuery("SELECT GETSYSINFO('DBDIR') FROM SYSTEM.SYSINFO");
                if (rs.next()) {
                    this.db_dir = rs.getString(1);
                    if (this.db_dir != null) {
                        this.db_dir = this.db_dir.trim();
                    }
                }
                rs.close();
            }
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this.dlg, null, sqle);
        }
        DbaObject.close(rs);
        DbaObject.close(stmt);
    }

    @Override
    public Connection getDbConnection() {
        return this.dbconn;
    }

    @Override
    public void disconnect() {
        try {
            if (this.dbconn != null) {
                if (this.startDB) {
                    System.setProperty("DM_DISCONNECT_MODE", "TERMINATE_DB");
                }
                this.dbconn.close();
                this.isConnected = false;
            }
        }
        catch (SQLException E) {
            if (E.getErrorCode() == 5307) {
                return;
            }
            GuiUt.showSQLException(this.dlg, null, E);
            this.isConnected = false;
        }
    }

    public void setDBDir(String db_dir) {
        this.db_dir = db_dir != null ? db_dir.trim() : db_dir;
    }

    public String getDBDir() {
        return this.db_dir;
    }

    public boolean isDBA() {
        Statement stmt = null;
        ResultSet rs = null;
        boolean b = true;
        try {
            stmt = this.dbconn.createStatement();
            rs = stmt.executeQuery("SELECT DBA FROM SYSAUTHUSER WHERE USER_NAME = '" + this.username + "'");
            while (rs.next()) {
                b = rs.getBoolean(1);
            }
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        catch (SQLException sqldbae) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this.dlg, null, sqldbae);
            b = false;
        }
        return b;
    }

    @Override
    public void setAutoCommit(boolean b) {
        try {
            this.dbconn.setAutoCommit(b);
        }
        catch (SQLException sqle) {
            System.out.println(sqle.getMessage());
        }
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public String getDatabaseName() {
        return this.dbname;
    }

    @Override
    public String getUserName() {
        return this.username;
    }
}

