/*
 * Decompiled with CFR 0.152.
 */
package dbaut;

import java.awt.Toolkit;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class DateDocument
extends PlainDocument {
    public static final String emptyDate = "    /  /  ";
    public static String initString = "    /  /  ";
    private int sep1 = 4;
    private int sep2 = 7;
    private int currentYear;
    private JTextComponent textComponent;
    private int newOffset;
    private String currentDateTimeStr = null;
    private boolean isSpecialYear = false;

    public DateDocument(JTextComponent tc) {
        this.textComponent = tc;
        Calendar now = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        this.currentDateTimeStr = sdf.format(now.getTime());
        this.currentYear = Integer.parseInt(this.currentDateTimeStr.substring(0, 4));
    }

    private void errorOut(String s) {
        System.out.println("**This beep is from DateDocrment --> " + s);
        Toolkit.getDefaultToolkit().beep();
    }

    private String addZero(String s, int size) {
        int s_size = s.length();
        if (s_size >= size) {
            return s;
        }
        StringBuffer sb = new StringBuffer(size);
        int count = size - s_size;
        for (int i = 0; i < count; ++i) {
            sb.append('0');
        }
        sb.append(s);
        return sb.toString();
    }

    private String addSpace(String s, int size) {
        int s_size = s.length();
        if (s_size >= size) {
            return s;
        }
        StringBuffer sb = new StringBuffer(size);
        int count = size - s_size;
        for (int i = 0; i < count; ++i) {
            sb.append(' ');
        }
        sb.append(s);
        return sb.toString();
    }

    private String removeSpace(String s) {
        int size = s.length();
        StringBuffer sb = new StringBuffer(size);
        char[] ca = s.toCharArray();
        for (int i = 0; i < size; ++i) {
            if (!Character.isDigit(ca[i])) continue;
            sb.append(ca[i]);
        }
        return sb.toString();
    }

    @Override
    public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
        if (s == null) {
            return;
        }
        int length = s.length();
        if (length == 0) {
            super.insertString(offset, s, attributeSet);
            return;
        }
        if (s.equals(initString)) {
            int len = this.textComponent.getText().length();
            if (len > 0) {
                super.remove(offset, len);
            }
            super.insertString(offset, s, attributeSet);
        } else {
            int iday;
            int imonth;
            int checkSpecialYear;
            String t = this.textComponent.getText();
            String new_s = t.substring(0, offset) + s + (t.length() > offset + length ? t.substring(offset + length) : "");
            if (offset + length > 10) {
                this.errorOut(new_s);
                return;
            }
            if (new_s.equals(emptyDate)) {
                super.remove(0, 10);
                super.insertString(0, new_s, attributeSet);
                return;
            }
            char[] ca = new_s.toCharArray();
            if (ca[this.sep1] != '/' || ca[this.sep2] != '/') {
                this.errorOut(new_s);
                return;
            }
            for (int i = 0; i < 10; ++i) {
                if (this.atSeparator(i) || Character.isDigit(ca[i]) || ca[i] == ' ') continue;
                this.errorOut(new_s);
                return;
            }
            String year = new_s.substring(0, 4);
            String month = new_s.substring(5, 7);
            String day = new_s.substring(8, 10);
            if (offset + length >= 5) {
                int iyear;
                int n = iyear = (year = this.removeSpace(year)).length() == 0 ? this.currentYear : Integer.parseInt(year);
                if (iyear < 70) {
                    iyear += 2000;
                } else if (iyear >= 70 && iyear < 100) {
                    iyear += 1900;
                }
                year = Integer.toString(iyear);
            }
            this.isSpecialYear = (checkSpecialYear = Integer.parseInt(year.trim())) % 400 == 0 ? true : (checkSpecialYear % 100 == 0 ? false : checkSpecialYear % 4 == 0);
            int n = imonth = month.trim().length() == 0 ? 1 : Integer.parseInt(month.trim());
            if (imonth > 12) {
                this.errorOut(s);
                return;
            }
            if (offset + length >= 7) {
                if (imonth == 0) {
                    imonth = 1;
                }
                month = Integer.toString(imonth);
            }
            if (offset + length >= 8) {
                if (imonth == 0) {
                    imonth = 1;
                }
                month = Integer.toString(imonth);
            }
            int[] mon_days = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
            int n2 = iday = day.trim().length() == 0 ? 1 : Integer.parseInt(day.trim());
            if (imonth == 2) {
                if (this.isSpecialYear && iday > 29 || !this.isSpecialYear && iday > 28) {
                    this.errorOut(s);
                    return;
                }
            } else {
                if (imonth == 0) {
                    ++imonth;
                }
                if (iday > mon_days[imonth - 1]) {
                    this.errorOut(s);
                    return;
                }
            }
            if (offset + length >= 10) {
                if (iday == 0) {
                    iday = 1;
                }
                day = Integer.toString(iday);
            }
            new_s = this.addSpace(year, 4) + '/' + this.addZero(month, 2) + '/' + this.addZero(day, 2);
            super.remove(0, 10);
            super.insertString(0, new_s, attributeSet);
            if (this.atSeparator(offset + length)) {
                this.textComponent.setCaretPosition(offset + length + 1);
            } else {
                this.textComponent.setCaretPosition(offset + length);
            }
        }
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        if (length == 0) {
            return;
        }
        if (this.atSeparator(offset)) {
            super.remove(offset - 1, 1);
            super.insertString(offset - 1, " ", null);
            this.textComponent.setCaretPosition(offset - 1);
        } else {
            int i = this.textComponent.getCaretPosition();
            super.remove(offset, length);
            super.insertString(offset, emptyDate.substring(offset, offset + length), null);
            if (offset < i) {
                if (this.atSeparator(offset - 1)) {
                    this.textComponent.setCaretPosition(offset - 1);
                } else {
                    this.textComponent.setCaretPosition(offset);
                }
            } else if (this.atSeparator(offset + 1)) {
                this.textComponent.setCaretPosition(offset + 2);
            } else if (this.textComponent.getText().equals(emptyDate)) {
                this.textComponent.setCaretPosition(0);
            } else {
                this.textComponent.setCaretPosition(offset + 1);
            }
        }
    }

    private boolean atSeparator(int offset) {
        return offset == this.sep1 || offset == this.sep2;
    }
}

