/*
 * Decompiled with CFR 0.152.
 */
package dbmaker.jdbc.ws.client;

import com.caucho.hessian.client.DMHessianProxyFactory;
import dbmaker.jdbc.ws.client.BindData;
import dbmaker.jdbc.ws.client.Blob;
import dbmaker.jdbc.ws.client.Clob;
import dbmaker.jdbc.ws.client.Connection;
import dbmaker.jdbc.ws.client.NClob;
import dbmaker.jdbc.ws.client.ServiceClient;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;

public class ResultSet
extends ServiceClient
implements java.sql.ResultSet {
    private ResultSetMetaData _rsmd = null;
    private Statement _stmt = null;
    protected com.dbmaker.jdbc.ws.IF.ResultSet _resultset = null;
    private Hashtable<String, Integer> _labels = null;
    private Hashtable<Integer, BindData> bindCols = null;
    protected boolean _isClosed = false;

    private void bindColumn(int n, BindData bindData) {
        if (this.bindCols == null) {
            this.bindCols = new Hashtable();
        }
        this.bindCols.put(new Integer(n), bindData);
    }

    private void clearBindColumn() {
        if (this.bindCols != null) {
            this.bindCols.clear();
        }
    }

    private BindData getBindColumn(int n) {
        if (this.bindCols == null) {
            return null;
        }
        return this.bindCols.get(new Integer(n));
    }

    public ResultSet(DMHessianProxyFactory dMHessianProxyFactory, long l, Statement statement) throws Exception {
        super(dMHessianProxyFactory, l);
        this._stmt = statement;
        this._resultset = (com.dbmaker.jdbc.ws.IF.ResultSet)dMHessianProxyFactory.createObject(this.SERVICE_CLASSNAME);
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.absolute(this._index, n);
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.afterLast(this._index);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.beforeFirst(this._index);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.cancelRowUpdates(this._index);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.clearWarnings(this._index);
    }

    @Override
    public void close() throws SQLException {
        if (this._isClosed) {
            throw new SQLWarning("ResultSet has been closed");
        }
        this._resultset.close(this._index);
        this._isClosed = true;
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.deleteRow(this._index);
    }

    @Override
    public int findColumn(String string) throws SQLException {
        Object object;
        this.checkClosed(this._isClosed);
        if (this._labels == null) {
            object = this.getMetaData();
            this._labels = new Hashtable();
            int n = object.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                this._labels.put(object.getColumnLabel(i), i);
            }
        }
        if ((object = this._labels.get(string)) == null) {
            object = this._labels.get(string.toUpperCase());
        }
        if (object == null) {
            return this._resultset.findColumn(this._index, string);
        }
        return (Integer)object;
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.first(this._index);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".getArray(int columnIndex)", null);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".getArray(String columnLabel)", null);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        Clob clob = this.getClob(n);
        InputStream inputStream = clob.getAsciiStream(true);
        return inputStream;
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        return new BigDecimal(this._resultset.getBigDecimal(this._index, n));
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(n).setScale(n2);
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(string).setScale(n);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        Blob blob = this.getBlob(n);
        InputStream inputStream = blob.getBinaryStream(true);
        return inputStream;
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        try {
            long l = this._resultset.getBlob(this._index, n);
            return new Blob(this._factory, l);
        }
        catch (Exception exception) {
            throw this.checkException(exception);
        }
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getBoolean(this._index, n);
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getByte(this._index, n);
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getBytes(this._index, n);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        return this.getClob(n).getCharacterStream(true);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        try {
            long l = this._resultset.getClob(this._index, n);
            String string = ((Connection)this._stmt.getConnection()).getClilcode();
            return new Clob(this._factory, l, string, this.getMetaData().getColumnType(n));
        }
        catch (Exception exception) {
            throw this.checkException(exception);
        }
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getConcurrency(this._index);
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getCursorName(this._index);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getDate(this._index, n);
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = this.getDate(n);
        if (date == null) {
            return null;
        }
        return new Date(this.addOffset(date.getTime(), calendar));
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getDouble(this._index, n);
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getFetchDirection(this._index);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getFetchSize(this._index);
    }

    @Override
    public float getFloat(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getFloat(this._index, n);
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public int getHoldability() throws SQLException {
        throw ResultSet.JDBCErrorNotSupport(this.SERVICE_CLASSNAME, "getHoldability()");
    }

    @Override
    public int getInt(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getInt(this._index, n);
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getLong(this._index, n);
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed(this._isClosed);
        if (this._rsmd != null) {
            return this._rsmd;
        }
        this._rsmd = this._resultset.getMetaData2(this._index);
        return this._rsmd;
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return ((NClob)this.getNClob(n)).getCharacterStream(true);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.findColumn(string));
    }

    @Override
    public java.sql.NClob getNClob(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        try {
            long l = this._resultset.getNClob(this._index, n);
            return new NClob(this._factory, l, this.getMetaData().getColumnType(n));
        }
        catch (Exception exception) {
            throw this.checkException(exception);
        }
    }

    @Override
    public java.sql.NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.findColumn(string));
    }

    @Override
    public String getNString(int n) throws SQLException {
        return this.getString(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getNString(this.findColumn(string));
    }

    @Override
    public Object getObject(int n) throws SQLException {
        if (this._rsmd == null) {
            this.getMetaData();
        }
        int n2 = this._rsmd.getColumnType(n);
        switch (n2) {
            case -5: {
                long l = this.getLong(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Long(l);
            }
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
            case -4: 
            case 2004: {
                return this.getBlob(n);
            }
            case 16: {
                boolean bl = this.getBoolean(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Boolean(bl);
            }
            case 3: {
                return this.getBigDecimal(n);
            }
            case 1: 
            case 2: 
            case 12: {
                return this.getString(n);
            }
            case -1: 
            case 2005: {
                return this.getClob(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 8: {
                double d = this.getDouble(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Double(d);
            }
            case 6: 
            case 7: {
                float f = this.getFloat(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Float(f);
            }
            case 4: {
                int n3 = this.getInt(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Integer(n3);
            }
            case -6: 
            case 5: {
                short s = this.getShort(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Short(s);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case -16: 
            case 2011: {
                return this.getNClob(n);
            }
        }
        return this.getString(n);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".getObject(int columnIndex, Map<String, Class<?>> map)", null);
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".getObject(String columnLabel, Map<String, Class<?>> map)", null);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".getRef(int columnIndex)", null);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".getRef(String columnLabel)", null);
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getRow(this._index);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".getRowId(int columnIndex)", null);
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".getRowId(String columnLabel)", null);
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".getSQLXML(int columnIndex)", null);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".getSQLXML(String columnLabel)", null);
    }

    @Override
    public short getShort(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getShort(this._index, n);
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this._stmt;
    }

    @Override
    public String getString(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getString(this._index, n);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public Time getTime(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getTime(this._index, n);
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTime(n);
        if (time != null) {
            return new Time(this.addOffset(time.getTime(), calendar));
        }
        return null;
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getTimestamp(this._index, n);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = this.getTimestamp(n);
        if (timestamp != null) {
            return new Timestamp(this.addOffset(timestamp.getTime(), calendar));
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.getType(this._index);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".getURL(int columnIndex)", null);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".getURL(String columnLabel)", null);
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".getUnicodeStream(int columnIndex)", null);
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".getUnicodeStream(String columnLabel)", null);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed(this._isClosed);
        String string = this._resultset.getWarnings(this._index);
        if (string == null) {
            return null;
        }
        return new SQLWarning(string);
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkClosed(this._isClosed);
        int n = 0;
        int n2 = 0;
        try {
            n = this._resultset.insertRow(this._index);
            if (n != 99 && n != 0) {
                throw ResultSet.JDBCError(this.SERVICE_CLASSNAME, "insertRow", n);
            }
            if (n == 99) {
                while ((n2 = this._resultset.paramData(this._index)) > 0) {
                    int n3;
                    Object[] objectArray;
                    Closeable closeable;
                    BindData bindData = this.getBindColumn(n2);
                    if (bindData == null) {
                        this.putData(null, 0);
                        continue;
                    }
                    if (bindData._type == 2 || bindData._type == 0) {
                        closeable = null;
                        closeable = bindData._type == 2 ? bindData._blob.getBinaryStream() : bindData._stream;
                        objectArray = new byte[1024];
                        n3 = 0;
                        while ((n3 = ((InputStream)closeable).read((byte[])objectArray, 0, objectArray.length)) >= 0) {
                            this.putData((byte[])objectArray, n3);
                        }
                        ((InputStream)closeable).close();
                        if (bindData._type == 2) {
                            bindData._blob.free();
                        } else {
                            bindData._stream.close();
                        }
                    }
                    if (bindData._type != 3 && bindData._type != 1) continue;
                    closeable = null;
                    closeable = bindData._type == 3 ? bindData._clob.getCharacterStream() : bindData._reader;
                    objectArray = new char[1024];
                    n3 = 0;
                    while ((n3 = ((Reader)closeable).read((char[])objectArray)) >= 0) {
                        byte[] byArray = new String((char[])objectArray, 0, n3).getBytes("UTF-16LE");
                        this.putData(byArray, byArray.length);
                    }
                    if (bindData._type == 3) {
                        bindData._clob.free();
                        continue;
                    }
                    bindData._reader.close();
                }
                n = this._resultset.insertRowFinal(this._index);
                if (n != 0) {
                    throw ResultSet.JDBCError(this.SERVICE_CLASSNAME, "insertRowFinal", n);
                }
            }
            this.clearBindColumn();
        }
        catch (Exception exception) {
            throw this.checkException(exception);
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.isAfterLast(this._index);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.isBeforeFirst(this._index);
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.isClosed(this._index);
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.isFirst(this._index);
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.isLast(this._index);
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.last(this._index);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.moveToCurrentRow(this._index);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.moveToInsertRow(this._index);
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.next(this._index);
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.previous(this._index);
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.refreshRow(this._index);
    }

    @Override
    public boolean relative(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.relative(this._index, n);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.rowDeleted(this._index);
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.rowInserted(this._index);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.rowUpdated(this._index);
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.setFetchDirection(this._index, n);
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.setFetchSize(this._index, n);
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".updateArray(int columnIndex, Array x)", null);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".updateArray(String columnLabel, Array x)", null);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        try {
            if (inputStream == null) {
                this.updateNull(n);
            } else {
                this.updateAsciiStream(n, inputStream, (long)inputStream.available());
            }
        }
        catch (Exception exception) {
            throw this.checkException(exception);
        }
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(n, inputStream, (long)n2);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, (long)n);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (inputStream == null) {
            this.updateNull(n);
        } else {
            this.updateLargeObject(n, new BindData(inputStream, 1, -1), l);
        }
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.updateBigDecimal(this._index, n, bigDecimal.toEngineeringString());
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        try {
            this.updateBinaryStream(n, inputStream, (long)inputStream.available());
        }
        catch (Exception exception) {
            throw this.checkException(exception);
        }
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        try {
            this.updateBinaryStream(this.findColumn(string), inputStream, (long)inputStream.available());
        }
        catch (Exception exception) {
            throw this.checkException(exception);
        }
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(n, inputStream, (long)n2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, (long)n);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (inputStream == null) {
            this.updateNull(n);
        } else {
            this.updateLargeObject(n, new BindData(inputStream, -2, -4), l);
        }
    }

    private void updateLargeObject(int n, BindData bindData, long l) throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.updateLargeObject(this._index, n, l, bindData._ctype);
        this.bindColumn(n, bindData);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBlob(int n, java.sql.Blob blob) throws SQLException {
        if (blob == null) {
            this.updateNull(n);
        } else {
            this.updateLargeObject(n, new BindData(blob), blob.length());
        }
    }

    @Override
    public void updateBlob(String string, java.sql.Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        try {
            this.updateBlob(n, inputStream, (long)inputStream.available());
        }
        catch (IOException iOException) {
            throw this.checkException(iOException);
        }
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(string), inputStream);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        if (inputStream == null) {
            this.updateNull(n);
        } else {
            this.updateLargeObject(n, new BindData(inputStream, -2, -4), l);
        }
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBlob(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.updateBoolean(this._index, n, bl);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.updateByte(this._index, n, by);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.updateBytes(this._index, n, byArray);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader, Integer.MAX_VALUE);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(n, reader, (long)n2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (reader == null) {
            this.updateNull(n);
        } else {
            this.updateLargeObject(n, new BindData(reader, -1), l);
        }
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateClob(int n, java.sql.Clob clob) throws SQLException {
        if (clob == null) {
            this.updateNull(n);
        } else {
            this.updateLargeObject(n, new BindData(clob), clob.length());
        }
    }

    @Override
    public void updateClob(String string, java.sql.Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        this.updateClob(n, reader, -1L);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(string), reader);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        if (reader == null) {
            this.updateNull(n);
        } else {
            this.updateLargeObject(n, new BindData(reader, -1), l);
        }
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.updateClob(this.findColumn(string), reader, l);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        this.updateString(n, date.toString());
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        this.updateString(n, Double.toString(d));
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        this.updateString(n, Double.toString(f));
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.updateInt(this._index, n, n2);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.updateLong(this._index, n, l);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(string, reader);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, l);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(string, reader, l);
    }

    @Override
    public void updateNClob(int n, java.sql.NClob nClob) throws SQLException {
        this.updateClob(n, (java.sql.Clob)nClob);
    }

    @Override
    public void updateNClob(String string, java.sql.NClob nClob) throws SQLException {
        this.updateClob(string, (java.sql.Clob)nClob);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        this.updateClob(n, reader);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        this.updateClob(string, reader);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        this.updateClob(n, reader, l);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.updateClob(string, reader, l);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        this.updateString(n, string);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.updateString(string, string2);
    }

    @Override
    public void updateNull(int n) throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.updateNull(this._index, n);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        if (object == null) {
            this.updateNull(n);
            return;
        }
        if (object instanceof InputStream) {
            this.updateBinaryStream(n, (InputStream)object);
        } else if (object instanceof Blob) {
            this.updateBlob(n, (java.sql.Blob)((Blob)object));
        } else if (object instanceof Boolean) {
            this.updateBoolean(n, (boolean)((Boolean)object));
        } else if (object instanceof Byte) {
            this.updateByte(n, (byte)((Byte)object));
        } else if (object instanceof Reader) {
            this.updateCharacterStream(n, (Reader)object);
        } else if (object instanceof Clob) {
            this.updateClob(n, (java.sql.Clob)((Clob)object));
        } else if (object instanceof Date) {
            this.updateDate(n, (Date)object);
        } else if (object instanceof Double) {
            this.updateDouble(n, (double)((Double)object));
        } else if (object instanceof Float) {
            this.updateFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Integer) {
            this.updateInt(n, (int)((Integer)object));
        } else if (object instanceof Long) {
            this.updateLong(n, (long)((Long)object));
        } else if (object instanceof String || object instanceof Character || object instanceof StringBuffer) {
            this.updateString(n, object.toString());
        } else if (object instanceof Short) {
            this.updateShort(n, (short)((Short)object));
        } else if (object instanceof Time) {
            this.updateTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.updateTimestamp(n, (Timestamp)object);
        } else if (object instanceof byte[]) {
            this.updateBytes(n, (byte[])object);
        }
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".updateObject(int columnIndex, Object x, int scaleOrLength)", null);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".updateObject(String columnLabel, Object x, int scaleOrLength)", null);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".updateRef(int columnIndex, Ref x)", null);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".updateRef(String columnLabel, Ref x)", null);
    }

    private void putData(byte[] byArray, int n) throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.putData(this._index, byArray, n);
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkClosed(this._isClosed);
        int n = 0;
        int n2 = 0;
        try {
            n = this._resultset.updateRow(this._index);
            if (n != 99 && n != 0) {
                throw ResultSet.JDBCError(this.SERVICE_CLASSNAME, "updateRow", n);
            }
            if (n == 99) {
                while ((n2 = this._resultset.paramData(this._index)) > 0) {
                    int n3;
                    Object[] objectArray;
                    Closeable closeable;
                    BindData bindData = this.getBindColumn(n2);
                    if (bindData == null) {
                        this.putData(null, 0);
                        continue;
                    }
                    if (bindData._type == 2 || bindData._type == 0) {
                        closeable = null;
                        closeable = bindData._type == 2 ? bindData._blob.getBinaryStream() : bindData._stream;
                        objectArray = new byte[1024];
                        n3 = 0;
                        while ((n3 = ((InputStream)closeable).read((byte[])objectArray, 0, objectArray.length)) >= 0) {
                            this.putData((byte[])objectArray, n3);
                        }
                        ((InputStream)closeable).close();
                        if (bindData._type == 2) {
                            bindData._blob.free();
                        } else {
                            bindData._stream.close();
                        }
                    }
                    if (bindData._type != 3 && bindData._type != 1) continue;
                    closeable = null;
                    closeable = bindData._type == 3 ? bindData._clob.getCharacterStream() : bindData._reader;
                    objectArray = new char[1024];
                    n3 = 0;
                    while ((n3 = ((Reader)closeable).read((char[])objectArray)) >= 0) {
                        byte[] byArray = new String((char[])objectArray, 0, n3).getBytes("UTF-16LE");
                        this.putData(byArray, byArray.length);
                    }
                    if (bindData._type == 3) {
                        bindData._clob.free();
                        continue;
                    }
                    bindData._reader.close();
                }
                n = this._resultset.updateRowFinal(this._index);
                if (n != 0) {
                    throw ResultSet.JDBCError(this.SERVICE_CLASSNAME, "updateRowFinal", n);
                }
            }
            this.clearBindColumn();
        }
        catch (Exception exception) {
            throw this.checkException(exception);
        }
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".updateRowId(int columnIndex, RowId x)", null);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".updateRowId(String columnLabel, RowId x)", null);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".updateSQLXML(int columnIndex, SQLXML xmlObject)", null);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".updateSQLXML(String columnLabel, SQLXML xmlObject)", null);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        this.updateInt(n, (int)s);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.updateString(this._index, n, string);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.updateString(this._index, n, time.toString());
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkClosed(this._isClosed);
        this._resultset.updateString(this._index, n, timestamp.toString());
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed(this._isClosed);
        return this._resultset.wasNull(this._index);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".isWrapperFor(Class<?>)", null);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw ResultSet.JDBCError("JERR_UNSUPPORT_OPERATION", this.SERVICE_CLASSNAME + ".unwrap(Class<T>)", null);
    }
}

