/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.unpacker.Unpacker;

public class IntegerArrayTemplate
extends AbstractTemplate<int[]> {
    private static IntegerArrayTemplate a = new IntegerArrayTemplate();

    private IntegerArrayTemplate() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(Packer pk, int[] target, boolean required) throws IOException {
        void var1_1;
        void var2_2;
        if (target == null) {
            int n2;
            if (n2 != 0) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.writeArrayBegin(target.length);
        for (void var5_5 : var2_2) {
            pk.write((int)var5_5);
        }
        var1_1.writeArrayEnd();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] read(Unpacker u2, int[] to, boolean required) throws IOException {
        void var1_1;
        int[] nArray;
        if (!required && u2.trySkipNil()) {
            return null;
        }
        int n2 = u2.readArrayBegin();
        if (to == null || to.length != n2) {
            nArray = new int[n2];
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = u2.readInt();
        }
        var1_1.readArrayEnd();
        return nArray;
    }

    public static IntegerArrayTemplate getInstance() {
        return a;
    }
}

