/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.unpacker.Unpacker;

public class FloatArrayTemplate
extends AbstractTemplate<float[]> {
    private static FloatArrayTemplate a = new FloatArrayTemplate();

    private FloatArrayTemplate() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(Packer pk, float[] target, boolean required) throws IOException {
        void var1_1;
        void var2_2;
        if (target == null) {
            int n2;
            if (n2 != 0) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.writeArrayBegin(target.length);
        for (void var5_5 : var2_2) {
            pk.write((float)var5_5);
        }
        var1_1.writeArrayEnd();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float[] read(Unpacker u2, float[] to, boolean required) throws IOException {
        void var2_2;
        void var1_1;
        if (!required && u2.trySkipNil()) {
            return null;
        }
        int n2 = u2.readArrayBegin();
        if (to == null || to.length != n2) {
            to = new float[n2];
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            to[i2] = u2.readFloat();
        }
        var1_1.readArrayEnd();
        return var2_2;
    }

    public static FloatArrayTemplate getInstance() {
        return a;
    }
}

