/* md5hl.c
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <phk@login.dkuug.dk> wrote this file.  As long as you retain this notice you
 * can do whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return.   Poul-Henning Kamp
 * ----------------------------------------------------------------------------
 * This code is modified from Poul's mdxhl.c.  It has been added for UDF only.
 */

#include <sys/types.h>
#include <fcntl.h>
#ifdef WIN32
# include <io.h>
#else
# include <unistd.h>
#endif

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "rsa_md5.h"

char *
MD5End(RSA_MD5_CTX *ctx, char *buf)
{
    int i;
    unsigned char digest[16];
    static const char hex[]="0123456789abcdef";

    if (!buf)
	return 0;
    RSA_MD5Final(digest,ctx);
    for (i=0;i<16;i++) {
	buf[i+i] = hex[digest[i] >> 4];
	buf[i+i+1] = hex[digest[i] & 0x0f];
    }
    buf[i+i] = '\0';
    return buf;
}

char *
MD5File (const char *filename, char *buf)
{
    unsigned char buffer[BUFSIZ];
    RSA_MD5_CTX ctx;
    int f,i,j;

    RSA_MD5Init(&ctx);
    buf[0] = 0;
    f = open(filename,O_RDONLY);
    if (f < 0) return buf;
    while ((i = read(f,buffer,sizeof buffer)) > 0) {
	RSA_MD5Update(&ctx,buffer,i);
    }
    j = errno;
    close(f);
    errno = j;
    if (i < 0) return buf;
    return MD5End(&ctx, buf);
}

char *
MD5Data (const char *data, unsigned int len, char *buf)
{
    RSA_MD5_CTX ctx;

    RSA_MD5Init(&ctx);
    RSA_MD5Update(&ctx,(const unsigned char *)data,len);
    return MD5End(&ctx, buf);
}

#ifndef NO_UDF
#define BUFLEN 33
#include <libudf.h>

#ifdef WIN32
__declspec(dllexport)
#endif
int MD5DATA(int narg, VAL args[])
{
    int rc = 0;
    char *buf;

    if (args[0].type != NULL_TYP)
    {
       if (rc = _UDFAllocMem(args, &buf, BUFLEN))
          return rc;
       memset(buf, 0, BUFLEN);
       MD5Data((const char *)args[0].u.xval, args[0].len, buf);
       args[0].u.xval = buf;
       args[0].type = CHAR_TYP;
       args[0].len = BUFLEN - 1;
    }
    return _RetVal(args, args[0]);
}

#ifdef WIN32
__declspec(dllexport)
#endif
int MD5FILE(int narg, VAL args[])
{
    int rc = 0;
    char *buf;
    char *filename;

    if (args[0].type != NULL_TYP)
    {
       if (rc = _UDFAllocMem(args, &buf, BUFLEN))
          return rc;
       memset(buf, 0, BUFLEN);
       if ((filename = malloc(args[0].len+1))==0)
          return -1;
       strncpy(filename, args[0].u.xval, args[0].len);
	   filename[args[0].len] = 0;
       MD5File(filename, buf);
       free(filename);
       args[0].u.xval = buf;
       args[0].type = CHAR_TYP;
       args[0].len = BUFLEN - 1;
    }
    return _RetVal(args, args[0]);
}
#else /* NO_UDF */

void main()
{
   char buf[33];
   char data[256];

   strcpy(data, "");
   printf("1. Text:\"%s\"\n  --> %s\n",data,MD5Data(data,strlen(data),buf));
   strcpy(data, "a");
   printf("2. Text:\"%s\"\n  --> %s\n",data,MD5Data(data,strlen(data),buf));
   strcpy(data, "message digest");
   printf("3. Text:\"%s\"\n  --> %s\n",data,MD5Data(data,strlen(data),buf));
   strcpy(data, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
   printf("4. Text:\"%s\"\n  --> %s\n",data,MD5Data(data,strlen(data),buf));

   strcpy(data, "rsa_md5.h");   
   printf("5. File:\"%s\"\n  --> %s\n",data,MD5File(data,buf));
   strcpy(data, "rsa_md5c.c");   
   printf("6. File:\"%s\"\n  --> %s\n",data,MD5File(data,buf));
   strcpy(data, "md5hl.c");   
   printf("7. File:\"%s\"\n  --> %s\n",data,MD5File(data,buf));
   strcpy(data, "No Such File");   
   printf("8. File:\"%s\"\n  --> %s\n",data,MD5File(data,buf));
}
#endif /* NO_UDF */
