#!/bin/sh

### BEGIN INIT INFO
# Provides:          dbmaker
# Required-Start:    $local_fs $remote_fs $network
# Required-Stop:     $local_fs $remote_fs $network
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Start/stop dbmaker database server
# Description:       starts dbmaker using start-stop-daemon
### END INIT INFO

app_name=dbmaker
app_home=`awk -F: '$1~/^'${app_name}'$/ {print $6}' /etc/passwd`
app_conf=/etc/dminit.conf

deb_start() {
  printf "Starting ${app_name}: "
  awk -F: '$1!~/^#/ {print $1,$2,$3 }' ${app_conf} |
  while read app_db arg2 app_owner; do
    [ -n "${app_db}" -a -n "${arg2}" -a -n "${app_owner}" ] || continue
    app_cmd="${app_home}/${arg2}/bin/dmserver"
    [ "`echo ${arg2} | cut -c1`" = "/" ] && app_cmd="${arg2}"
    start-stop-daemon --start -c ${app_owner} -x ${app_cmd} ${app_db} 2>&1 > /dev/null && \
      printf "${app_db} " || printf "${app_db}:FAILED "
  done
  echo
}

deb_stop() {
  printf "Stopping ${app_name}: "
  awk -F: '$1!~/^#/ {print $1,$2,$3 }' ${app_conf} |
  while read app_db arg2 app_owner; do
    [ -n "${app_db}" -a -n "${arg2}" -a -n "${app_owner}" ] || continue
    app_cmd="${app_home}/${arg2}/bin/dmserver"
    [ "`echo ${arg2} | cut -c1`" = "/" ] && app_cmd="${arg2}"
    ${app_cmd} -k ${app_db} 2>&1 >/dev/null && \
      printf "${app_db} " || printf "${app_db}:FAILED "
  done
  echo
}

# Source function library

# Check that $app_conf exists.
[ -f ${app_conf} ] || exit 0

case "$1" in
  start)
    deb_start
    ;;
  stop)
    deb_stop
    ;;
  restart|force-reload)
    deb_stop
    sleep 5
    deb_start
    ;;
  reload)
    echo "Error: argument '$1' not supported" >&2
    exit 3
    ;;
  *)
    echo "Usage: `basename $0` { start | stop | restart }" >&2
    exit 3
    ;;
esac

exit 0

