Imports System
Imports System.Drawing
Imports System.Windows.Forms
Imports System.Data
Imports System.Data.OleDb
Imports System.Data.Odbc
Imports System.Data.Common


Public Class Form1
    Inherits System.Windows.Forms.Form

#Region " The code generated by windows form disigner "

    Public Sub New()
        MyBase.New()

        InitializeComponent()


    End Sub

    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    Private components As System.ComponentModel.IContainer

    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents Label4 As System.Windows.Forms.Label
    Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents txtID As System.Windows.Forms.TextBox
    Friend WithEvents txtFName As System.Windows.Forms.TextBox
    Friend WithEvents txtLName As System.Windows.Forms.TextBox
    Friend WithEvents txtTitle As System.Windows.Forms.TextBox
    Friend WithEvents btnFirst As System.Windows.Forms.Button
    Friend WithEvents btnPrev As System.Windows.Forms.Button
    Friend WithEvents btnNext As System.Windows.Forms.Button
    Friend WithEvents btnLast As System.Windows.Forms.Button
    Friend WithEvents btnNew As System.Windows.Forms.Button
    Friend WithEvents btnUpdate As System.Windows.Forms.Button
    Friend WithEvents btnDelete As System.Windows.Forms.Button
    Friend WithEvents btnSubmit As System.Windows.Forms.Button
    Friend WithEvents btnExit As System.Windows.Forms.Button
    Friend WithEvents btnCancel As System.Windows.Forms.Button
    Friend WithEvents GroupBox2 As System.Windows.Forms.GroupBox
    Friend WithEvents Label5 As System.Windows.Forms.Label
    Friend WithEvents Label6 As System.Windows.Forms.Label
    Friend WithEvents cmbProvider As System.Windows.Forms.ComboBox
    Friend WithEvents txtConnStr As System.Windows.Forms.TextBox
    Friend WithEvents btnLoad As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.Label1 = New System.Windows.Forms.Label
        Me.Label2 = New System.Windows.Forms.Label
        Me.Label3 = New System.Windows.Forms.Label
        Me.Label4 = New System.Windows.Forms.Label
        Me.GroupBox1 = New System.Windows.Forms.GroupBox
        Me.txtTitle = New System.Windows.Forms.TextBox
        Me.txtLName = New System.Windows.Forms.TextBox
        Me.txtFName = New System.Windows.Forms.TextBox
        Me.txtID = New System.Windows.Forms.TextBox
        Me.btnFirst = New System.Windows.Forms.Button
        Me.btnPrev = New System.Windows.Forms.Button
        Me.btnNext = New System.Windows.Forms.Button
        Me.btnLast = New System.Windows.Forms.Button
        Me.btnNew = New System.Windows.Forms.Button
        Me.btnUpdate = New System.Windows.Forms.Button
        Me.btnDelete = New System.Windows.Forms.Button
        Me.btnSubmit = New System.Windows.Forms.Button
        Me.btnExit = New System.Windows.Forms.Button
        Me.btnCancel = New System.Windows.Forms.Button
        Me.GroupBox2 = New System.Windows.Forms.GroupBox
        Me.btnLoad = New System.Windows.Forms.Button
        Me.txtConnStr = New System.Windows.Forms.TextBox
        Me.cmbProvider = New System.Windows.Forms.ComboBox
        Me.Label5 = New System.Windows.Forms.Label
        Me.Label6 = New System.Windows.Forms.Label
        Me.GroupBox1.SuspendLayout()
        Me.GroupBox2.SuspendLayout()
        Me.SuspendLayout()
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(16, 32)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(88, 16)
        Me.Label1.TabIndex = 0
        Me.Label1.Text = "ID:"
        '
        'Label2
        '
        Me.Label2.Location = New System.Drawing.Point(16, 64)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(88, 16)
        Me.Label2.TabIndex = 0
        Me.Label2.Text = "First Name:"
        '
        'Label3
        '
        Me.Label3.Location = New System.Drawing.Point(16, 96)
        Me.Label3.Name = "Label3"
        Me.Label3.Size = New System.Drawing.Size(88, 16)
        Me.Label3.TabIndex = 0
        Me.Label3.Text = "Last Name:"
        '
        'Label4
        '
        Me.Label4.Location = New System.Drawing.Point(16, 128)
        Me.Label4.Name = "Label4"
        Me.Label4.Size = New System.Drawing.Size(88, 16)
        Me.Label4.TabIndex = 0
        Me.Label4.Text = "Title:"
        '
        'GroupBox1
        '
        Me.GroupBox1.Controls.Add(Me.txtTitle)
        Me.GroupBox1.Controls.Add(Me.txtLName)
        Me.GroupBox1.Controls.Add(Me.txtFName)
        Me.GroupBox1.Controls.Add(Me.txtID)
        Me.GroupBox1.Controls.Add(Me.Label1)
        Me.GroupBox1.Controls.Add(Me.Label2)
        Me.GroupBox1.Controls.Add(Me.Label4)
        Me.GroupBox1.Controls.Add(Me.Label3)
        Me.GroupBox1.Location = New System.Drawing.Point(8, 104)
        Me.GroupBox1.Name = "GroupBox1"
        Me.GroupBox1.Size = New System.Drawing.Size(288, 152)
        Me.GroupBox1.TabIndex = 1
        Me.GroupBox1.TabStop = False
        Me.GroupBox1.Text = "Card"
        '
        'txtTitle
        '
        Me.txtTitle.Location = New System.Drawing.Point(112, 120)
        Me.txtTitle.Name = "txtTitle"
        Me.txtTitle.Size = New System.Drawing.Size(160, 21)
        Me.txtTitle.TabIndex = 4
        Me.txtTitle.Text = ""
        '
        'txtLName
        '
        Me.txtLName.Location = New System.Drawing.Point(112, 88)
        Me.txtLName.Name = "txtLName"
        Me.txtLName.Size = New System.Drawing.Size(160, 21)
        Me.txtLName.TabIndex = 3
        Me.txtLName.Text = ""
        '
        'txtFName
        '
        Me.txtFName.Location = New System.Drawing.Point(112, 56)
        Me.txtFName.Name = "txtFName"
        Me.txtFName.Size = New System.Drawing.Size(160, 21)
        Me.txtFName.TabIndex = 2
        Me.txtFName.Text = ""
        '
        'txtID
        '
        Me.txtID.Location = New System.Drawing.Point(112, 24)
        Me.txtID.Name = "txtID"
        Me.txtID.Size = New System.Drawing.Size(80, 21)
        Me.txtID.TabIndex = 1
        Me.txtID.Text = ""
        '
        'btnFirst
        '
        Me.btnFirst.Location = New System.Drawing.Point(16, 264)
        Me.btnFirst.Name = "btnFirst"
        Me.btnFirst.Size = New System.Drawing.Size(32, 23)
        Me.btnFirst.TabIndex = 2
        Me.btnFirst.Text = "|<"
        '
        'btnPrev
        '
        Me.btnPrev.Location = New System.Drawing.Point(48, 264)
        Me.btnPrev.Name = "btnPrev"
        Me.btnPrev.Size = New System.Drawing.Size(32, 23)
        Me.btnPrev.TabIndex = 2
        Me.btnPrev.Text = "<"
        '
        'btnNext
        '
        Me.btnNext.Location = New System.Drawing.Point(80, 264)
        Me.btnNext.Name = "btnNext"
        Me.btnNext.Size = New System.Drawing.Size(32, 23)
        Me.btnNext.TabIndex = 2
        Me.btnNext.Text = ">"
        '
        'btnLast
        '
        Me.btnLast.Location = New System.Drawing.Point(112, 264)
        Me.btnLast.Name = "btnLast"
        Me.btnLast.Size = New System.Drawing.Size(32, 23)
        Me.btnLast.TabIndex = 2
        Me.btnLast.Text = ">|"
        '
        'btnNew
        '
        Me.btnNew.Location = New System.Drawing.Point(16, 296)
        Me.btnNew.Name = "btnNew"
        Me.btnNew.Size = New System.Drawing.Size(40, 23)
        Me.btnNew.TabIndex = 3
        Me.btnNew.Text = "&New"
        '
        'btnUpdate
        '
        Me.btnUpdate.Location = New System.Drawing.Point(56, 296)
        Me.btnUpdate.Name = "btnUpdate"
        Me.btnUpdate.Size = New System.Drawing.Size(56, 23)
        Me.btnUpdate.TabIndex = 3
        Me.btnUpdate.Text = "&Update"
        '
        'btnDelete
        '
        Me.btnDelete.Location = New System.Drawing.Point(112, 296)
        Me.btnDelete.Name = "btnDelete"
        Me.btnDelete.Size = New System.Drawing.Size(56, 23)
        Me.btnDelete.TabIndex = 3
        Me.btnDelete.Text = "&Delete"
        '
        'btnSubmit
        '
        Me.btnSubmit.Location = New System.Drawing.Point(168, 296)
        Me.btnSubmit.Name = "btnSubmit"
        Me.btnSubmit.Size = New System.Drawing.Size(56, 23)
        Me.btnSubmit.TabIndex = 3
        Me.btnSubmit.Text = "&Submit"
        '
        'btnExit
        '
        Me.btnExit.Location = New System.Drawing.Point(248, 296)
        Me.btnExit.Name = "btnExit"
        Me.btnExit.Size = New System.Drawing.Size(40, 23)
        Me.btnExit.TabIndex = 3
        Me.btnExit.Text = "E&xit"
        '
        'btnCancel
        '
        Me.btnCancel.Location = New System.Drawing.Point(112, 296)
        Me.btnCancel.Name = "btnCancel"
        Me.btnCancel.Size = New System.Drawing.Size(56, 23)
        Me.btnCancel.TabIndex = 3
        Me.btnCancel.Text = "&Cancel"
        '
        'GroupBox2
        '
        Me.GroupBox2.Controls.Add(Me.btnLoad)
        Me.GroupBox2.Controls.Add(Me.txtConnStr)
        Me.GroupBox2.Controls.Add(Me.cmbProvider)
        Me.GroupBox2.Controls.Add(Me.Label5)
        Me.GroupBox2.Controls.Add(Me.Label6)
        Me.GroupBox2.Location = New System.Drawing.Point(8, 8)
        Me.GroupBox2.Name = "GroupBox2"
        Me.GroupBox2.Size = New System.Drawing.Size(288, 88)
        Me.GroupBox2.TabIndex = 4
        Me.GroupBox2.TabStop = False
        Me.GroupBox2.Text = "ADO.NET Provider"
        '
        'btnLoad
        '
        Me.btnLoad.Location = New System.Drawing.Point(216, 24)
        Me.btnLoad.Name = "btnLoad"
        Me.btnLoad.Size = New System.Drawing.Size(64, 23)
        Me.btnLoad.TabIndex = 3
        Me.btnLoad.Text = "&Load"
        '
        'txtConnStr
        '
        Me.txtConnStr.Location = New System.Drawing.Point(80, 56)
        Me.txtConnStr.Name = "txtConnStr"
        Me.txtConnStr.Size = New System.Drawing.Size(200, 21)
        Me.txtConnStr.TabIndex = 2
        Me.txtConnStr.Text = ""
        '
        'cmbProvider
        '
        Me.cmbProvider.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList
        Me.cmbProvider.Location = New System.Drawing.Point(80, 24)
        Me.cmbProvider.Name = "cmbProvider"
        Me.cmbProvider.Size = New System.Drawing.Size(120, 20)
        Me.cmbProvider.TabIndex = 1
        '
        'Label5
        '
        Me.Label5.Location = New System.Drawing.Point(8, 24)
        Me.Label5.Name = "Label5"
        Me.Label5.Size = New System.Drawing.Size(64, 15)
        Me.Label5.TabIndex = 0
        Me.Label5.Text = "Provider:"
        '
        'Label6
        '
        Me.Label6.Location = New System.Drawing.Point(8, 48)
        Me.Label6.Name = "Label6"
        Me.Label6.Size = New System.Drawing.Size(72, 32)
        Me.Label6.TabIndex = 0
        Me.Label6.Text = "Connection String:"
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(6, 14)
        Me.ClientSize = New System.Drawing.Size(304, 327)
        Me.Controls.Add(Me.GroupBox2)
        Me.Controls.Add(Me.btnNew)
        Me.Controls.Add(Me.btnFirst)
        Me.Controls.Add(Me.GroupBox1)
        Me.Controls.Add(Me.btnPrev)
        Me.Controls.Add(Me.btnNext)
        Me.Controls.Add(Me.btnLast)
        Me.Controls.Add(Me.btnUpdate)
        Me.Controls.Add(Me.btnSubmit)
        Me.Controls.Add(Me.btnExit)
        Me.Controls.Add(Me.btnCancel)
        Me.Controls.Add(Me.btnDelete)
        Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog
        Me.MaximizeBox = False
        Me.Name = "Form1"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = "VB.NET Sample"
        Me.GroupBox1.ResumeLayout(False)
        Me.GroupBox2.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region

    Public Shared Sub Main()
        Application.Run(New Form1)
    End Sub

    Enum Provider
        OleDbProvider
        OdbcProvider
    End Enum

    Dim curProvider As Provider
    Dim curConnectionString As String
    Dim oledbConnectionString As String = "Provider=DMOLE54;Data source=DBSAMPLE5;User Id=SYSADM;Password=;"
    Dim odbcConnectionString As String = "Driver={DBMaker 5.4 Driver};Database=DBSAMPLE5;Uid=SYSADM;Pwd=;"
    Dim oldRowPosition As Integer

    Dim myDS As DataSet
    Dim myTB As DataTable
    Dim myCN As IDbConnection
    Dim myDA As DbDataAdapter
    Dim myCM As IDbCommand
    Dim myManager As CurrencyManager

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        cmbProvider.Items.Add(Provider.OleDbProvider)
        cmbProvider.Items.Add(Provider.OdbcProvider)
        cmbProvider.SelectedIndex = 0

        curProvider = Provider.OleDbProvider
        curConnectionString = oledbConnectionString

        LockTextBox(True)
        LockNavigator(True, True, True, True)
        LockEditButton(True, True, True, True)
        btnCancel.Visible = False
    End Sub

    Private Sub cmbProvider_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbProvider.SelectedIndexChanged
        If CType(cmbProvider.SelectedItem, Provider) = Provider.OleDbProvider Then
            txtConnStr.Text = oledbConnectionString
        ElseIf CType(cmbProvider.SelectedItem, Provider) = Provider.OdbcProvider Then
            txtConnStr.Text = odbcConnectionString
        End If
    End Sub

    Private Sub LockTextBox(ByVal locked As Boolean)
        If locked = True Then
            txtID.ReadOnly = True
            txtFName.ReadOnly = True
            txtLName.ReadOnly = True
            txtTitle.ReadOnly = True
        Else
            txtID.ReadOnly = False
            txtFName.ReadOnly = False
            txtLName.ReadOnly = False
            txtTitle.ReadOnly = False
        End If
    End Sub

    Private Sub LockNavigator(ByVal lockedFirst As Boolean, ByVal lockedPrev As Boolean, _
    ByVal lockedNext As Boolean, ByVal lockedLast As Boolean)
        If lockedFirst = True Then
            btnFirst.Enabled = False
        Else
            btnFirst.Enabled = True
        End If
        If lockedPrev = True Then
            btnPrev.Enabled = False
        Else
            btnPrev.Enabled = True
        End If
        If lockedNext = True Then
            btnNext.Enabled = False
        Else
            btnNext.Enabled = True
        End If
        If lockedLast = True Then
            btnLast.Enabled = False
        Else
            btnLast.Enabled = True
        End If
    End Sub

    Private Sub LockEditButton(ByVal lockedNew As Boolean, ByVal lockedUpdate As Boolean, _
    ByVal lockedDelete As Boolean, ByVal lockedSubmit As Boolean)
        If lockedNew = True Then
            btnNew.Enabled = False
        Else
            btnNew.Enabled = True
        End If
        If lockedUpdate = True Then
            btnUpdate.Enabled = False
        Else
            btnUpdate.Enabled = True
        End If
        If lockedDelete = True Then
            btnDelete.Enabled = False
        Else
            btnDelete.Enabled = True
        End If
        If lockedSubmit = True Then
            btnSubmit.Enabled = False
        Else
            btnSubmit.Enabled = True
        End If
    End Sub

    Private Sub BindText(ByVal dt As DataTable)
        txtID.DataBindings.Clear()
        txtFName.DataBindings.Clear()
        txtLName.DataBindings.Clear()
        txtTitle.DataBindings.Clear()
        If Not dt Is Nothing Then
            txtID.DataBindings.Add("Text", dt, "ID")
            txtFName.DataBindings.Add("Text", dt, "FNAME")
            txtLName.DataBindings.Add("Text", dt, "LNAME")
            txtTitle.DataBindings.Add("Text", dt, "TITLE")
            'myManager = CType(Me.BindingContext(dt), CurrencyManager)
        End If
    End Sub

    Private Sub btnLoad_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnLoad.Click
        curConnectionString = txtConnStr.Text
        curProvider = CType(cmbProvider.SelectedItem, Provider)

        FillDataSet()
        If Not myTB Is Nothing Then
            BindText(myTB)
            LockNavigator(False, False, False, False)
            LockEditButton(False, False, False, True)
        End If
    End Sub

    Private Sub FillDataSet()
        If curProvider = Provider.OleDbProvider Then
            myCN = New OleDbConnection(curConnectionString)
            myCM = myCN.CreateCommand()
            myCM.CommandText = "select id,fname,lname,title from sample.card"
            myDA = New OleDbDataAdapter(myCM)
        Else
            myCN = New OdbcConnection(curConnectionString)
            myCM = myCN.CreateCommand()
            myCM.CommandText = "select id,fname,lname,title from sample.card"
            myDA = New OdbcDataAdapter(myCM)
        End If

        myDS = New DataSet
        Try
            myDA.Fill(myDS, "card")
        Catch ex As Exception
            MessageBox.Show(Me, ex.Message, "Fill DataSet Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
        Finally
            If Not myCN Is Nothing Then
                myCN.Close()
            End If
        End Try

        If (myDS.Tables.Count > 0) Then
            myTB = myDS.Tables("card")
            myManager = CType(Me.BindingContext(myTB), CurrencyManager)
        Else
            myTB = Nothing
        End If
    End Sub

    Private Sub btnFirst_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnFirst.Click
        If myManager Is Nothing Then Return
        myManager.Position = 0
        LockNavigator(True, True, False, False)
    End Sub

    Private Sub btnPrev_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPrev.Click
        If myManager Is Nothing Then Exit Sub
        If myManager.Position > 0 Then myManager.Position -= 1
        If myManager.Position = 0 Then
            LockNavigator(True, True, False, False)
        Else
            LockNavigator(False, False, False, False)
        End If
    End Sub

    Private Sub btnNext_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNext.Click
        If myManager Is Nothing Then Exit Sub
        If myManager.Position < myManager.Count - 1 Then myManager.Position += 1
        If myManager.Position = myManager.Count - 1 Then
            LockNavigator(False, False, True, True)
        Else
            LockNavigator(False, False, False, False)
        End If
    End Sub

    Private Sub btnLast_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnLast.Click
        If myManager Is Nothing Then Exit Sub
        myManager.Position = myManager.Count - 1
        LockNavigator(False, False, True, True)
    End Sub

    Private Sub btnNew_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNew.Click
        If myTB Is Nothing Then
            MessageBox.Show(Me, "Data set is empty", "Create New Row Error", MessageBoxIcon.Error)
            Exit Sub
        End If
        Dim row As DataRow = myTB.NewRow()
        myTB.Rows.Add(row)
        oldRowPosition = myManager.Position
        myManager.Position = myManager.Count - 1
        LockTextBox(False)
        LockNavigator(True, True, True, True)
        LockEditButton(True, True, True, False)
        btnCancel.Visible = True
    End Sub

    Private Sub btnUpdate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnUpdate.Click
        If myTB Is Nothing Then
            MessageBox.Show("Data set is empty", "Update Row Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End If
        If myManager.Position < 0 Or myManager.Position >= myManager.Count Then
            MessageBox.Show("No row can be updated", "Update Row Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End If
        oldRowPosition = myManager.Position
        LockTextBox(False)
        LockNavigator(True, True, True, True)
        LockEditButton(True, True, True, False)
        btnCancel.Visible = True
    End Sub

    Private Sub btnDelete_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDelete.Click
        If myTB Is Nothing Then
            MessageBox.Show(Me, "Data set is empty", "Delete Row Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End If
        If myManager.Position < 0 Or myManager.Position >= myManager.Count Then
            MessageBox.Show(Me, "No row can be deleted", "Delete Row Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End If
        If MessageBox.Show(Me, "Are you sure to delete current row ?", "Warning", _
        MessageBoxButtons.YesNo, MessageBoxIcon.Warning) = DialogResult.No Then
            Exit Sub
        End If

        myCM = myCN.CreateCommand()
        myCM.CommandText = "delete from sample.card "
        If (myTB.Rows(myManager.Position)(0, DataRowVersion.Original) Is DBNull.Value) Then
            myCM.CommandText &= " where ID IS NULL"
        Else
            myCM.CommandText &= " where ID = " & _
            CType(myTB.Rows(myManager.Position)(0, DataRowVersion.Original), Integer)
        End If

        Try
            myCN.Open()
            myCM.ExecuteNonQuery()
        Catch ex As Exception
            MessageBox.Show(ex.Message, "Delete Row Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
        Finally
            If Not myCN Is Nothing Then myCN.Close()
        End Try

        oldRowPosition = myManager.Position
        FillDataSet()
        myManager.Position = oldRowPosition
        BindText(myTB)
    End Sub

    Private Sub btnSubmit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSubmit.Click
        If myTB Is Nothing Then
            MessageBox.Show("Data set is empty", "Submit Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End If
        If myManager.Position < 0 Or myManager.Position >= myManager.Count Then
            MessageBox.Show("No row can be submited", "Submit Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End If

        myCM = myCN.CreateCommand()
        If (myTB.Rows(myManager.Position).RowState = DataRowState.Added) Then
            myCM.CommandText = "insert into sample.card(ID,FName,LName,Title) values("
            Try
                myCM.CommandText &= CType(txtID.Text.Trim(), Integer)
            Catch ex As Exception
                myCM.CommandText &= "NULL"
            End Try
            If txtFName.Text.Trim() <> "" Then
                myCM.CommandText &= ",'" & txtFName.Text.Trim() & "'"
            Else
                myCM.CommandText &= ",NULL"
            End If
            If txtLName.Text.Trim() <> "" Then
                myCM.CommandText &= ",'" & txtLName.Text.Trim() & "'"
            Else
                myCM.CommandText &= ",NULL"
            End If
            If txtTitle.Text.Trim() <> "" Then
                myCM.CommandText &= ",'" & txtTitle.Text.Trim() & "'"
            Else
                myCM.CommandText &= ",NULL"
            End If
            myCM.CommandText &= ")"
        Else
            myCM.CommandText = "update sample.card set ID = "
            Try
                myCM.CommandText &= CType(txtID.Text.Trim(), Integer)
            Catch ex As Exception
                myCM.CommandText &= "NULL"
            End Try
            If txtFName.Text.Trim() <> "" Then
                myCM.CommandText &= ", FName = '" & txtFName.Text.Trim() & "'"
            Else
                myCM.CommandText &= ", FName = NULL"
            End If
            If txtLName.Text.Trim() <> "" Then
                myCM.CommandText &= ", LName = '" & txtLName.Text.Trim() & "'"
            Else
                myCM.CommandText &= ", LName = NULL"
            End If
            If txtTitle.Text.Trim() <> "" Then
                myCM.CommandText &= ", Title = '" & txtTitle.Text.Trim() & "'"
            Else
                myCM.CommandText &= ", Title = NULL"
            End If
            myCM.CommandText &= " where ID "
            If (myTB.Rows(myManager.Position)(0, DataRowVersion.Original) Is DBNull.Value) Then
                myCM.CommandText &= " IS NULL"
            Else
                myCM.CommandText &= " = " & CType(myTB.Rows(myManager.Position)(0, DataRowVersion.Original), Integer)
            End If
        End If
        Try
            myCN.Open()
            myCM.ExecuteNonQuery()
        Catch ex As Exception
            MessageBox.Show(ex.Message, "Submit Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
        Finally
            If Not myCN Is Nothing Then myCN.Close()
        End Try

        oldRowPosition = myManager.Position
        FillDataSet()
        myManager.Position = oldRowPosition
        BindText(myTB)
        LockTextBox(True)
        LockNavigator(False, False, False, False)
        LockEditButton(False, False, False, True)
        btnCancel.Visible = False
    End Sub

    Private Sub btnCancel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        If Not myTB Is Nothing Then
            myTB.RejectChanges()
        End If
        LockTextBox(True)
        LockNavigator(False, False, False, False)
        LockEditButton(False, False, False, True)
        btnCancel.Visible = False
        myManager.Position = oldRowPosition
        BindText(myTB)
    End Sub

    Private Sub btnExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExit.Click
        Me.Close()
        'Application.Exit()
    End Sub
End Class
