/********************************************************************
 * demo3: demonstrate user granted RESOURCE and	CONNECT authority
 ********************************************************************/
set printto usrgrp03.txt;

connect to dbsample5 sysadm;

grant connect to dbausr;
grant dba to dbausr;	//user dbausr is granted DBA database authority

grant connect to resusr;
grant resource to resusr;	//user resusr is granted RESOURCE database authority

grant connect to connusr;	//user connusr only has CONNECT database authority

disconnect;
connect to dbsample5 resusr; //resusr has RESOURCE authority

// resusr can create schema for itself
create schema resschema1;
create schema resschema2;

// resusr only can create database objects for itself
create table t1(c1 int);	// in default schema resusr
create table resschema1.t2(c2 int); // in schema resschema1
create table resschema2.t3(c3 int); // in schema resschema2
drop table t1; //drop table resusr.t1
drop table resschema1.t2;
drop table resschema2.t3;

//resusr can NOT create schema for other user
create schema connschema2 authorization connusr;

//resusr can NOT create database objects in other user's schema
create table sysadm.t1(c1 int);
create table connusr.t2(c2 int);


disconnect;
connect to dbsample5 connusr; //connusr only has CONNECT privilege

//connusr can NOT create any database objects
create schema s2;
create table t1(c1 int); // in default schema connusr

disconnect;
connect to dbsample5 sysadm;

drop schema resschema1;
drop schema resschema2;
drop schema connschema2;

revoke connect from dbausr;
revoke connect from resusr;
revoke connect from connusr;
//drop default schema after delete the user
drop schema dbausr;
drop schema resusr;
drop schema connusr;

set printto off;
disconnect;
q;
