/******************************************
 * demo2: demonstrate user DBA
 ******************************************/
set printto usrgrp02.txt;

connect to dbsample5 sysadm;

grant connect to dbausr;
grant dba to dbausr;	//user dbausr is granted DBA database authority
alter password of dbausr to xxx123;

grant connect to resusr;
grant resource to resusr;	//user resusr is granted RESOURCE database authority

grant connect to connusr;	//user connusr only has CONNECT database authority

disconnect;
connect to dbsample5 dbausr xxx123;	// dbausr has DBA database authority

// Any user can alter its own password
alter password xxx123 to '1234';
alter password '1234' to null;
alter password null to xyz123;

// DBA can NOT grant special privileges (CONNECT/RESOURCE/DBA/ACCESS) to users
grant connect to resusr2;

// DBA can create schema for other user:
create schema resschema1 authorization resusr;
create schema connschema1 authorization connusr;
set linewidth 60;
select * from sysschema;

// DBA can create and drop table in any schema 
create table resschema1.t1(c1 int,c2 char(10));
create table connusr.t1(c3 int);
create table sysadm.t1(c4 int);
insert into sysadm.t1 values(1234);
select * from sysadm.t1;
drop table sysadm.t1;
drop table resschema1.t1;
drop table connusr.t1;

// DBA can drop any empty schema except default schema
drop schema resschema1;
drop schema connschema1;
select * from sysschema;

disconnect;
connect to dbsample5 sysadm;
revoke connect from dbausr;
revoke connect from resusr;
revoke connect from connusr;
//drop default schema after delete the user
drop schema dbausr;
drop schema resusr;
drop schema connusr;

set printto off;
disconnect;
q;