/****************************************************************************
 *   hook 1999.04.2
 *
 *   Module Name = InsertPatient.sp
 *
 *   Purpose  = Store Procedure call Shared Object(SYSTEM SP)
 *
 *   Function = 1. call solock(1);
 *              2. call soread(1,:shobj);
 *              3. call soset(1,0,?);
 *              4. call soadd(1,1,?);
 *              5. call soread(1,:shobj);
 *              6. call solock(1);
 *
 *   Use Database : DBSAMPLE5
 *       Share Obj: call socreate(100,0,?);
 *       table    : sample.patient(number serial,name char(10)); ->Patient Primary data
 *                  sample.history(regno int,number int,
 *                          regtime timestamp default now()); ->History Record
 *
 *   How to use   : ?=call InsertPatient(number,'name',?);
 ****************************************************************************/
#define UseSharedObj 100             /* assign shared object number 100 */
#define MaxCounter 50                /* It will be a cycle from 1 to 50 */

EXEC SQL CREATE PROCEDURE sample.sp_InsertPatient(int Number,char(11) Name,int RegNo OUTPUT) returns status;
{
  EXEC SQL BEGIN DECLARE SECTION;
  int oldnum,ShObj=UseSharedObj;
  EXEC SQL END   DECLARE SECTION;

  EXEC SQL BEGIN CODE SECTION;
  EXEC SQL call solock(:ShObj);
  EXEC SQL call soread(:ShObj,:RegNo);
  if(RegNo >=MaxCounter)
    EXEC SQL call soset(:ShObj,0,:oldnum);
  EXEC SQL call soadd(:ShObj,1,:oldnum);
  EXEC SQL call soread(:ShObj,:RegNo);
  EXEC SQL insert into sample.patient values(:Number,:Name);
  EXEC SQL insert into sample.history values(:RegNo,:Number,default);
  EXEC SQL call sounlock(:ShObj);
  EXEC SQL RETURNS status SQLCODE;
  EXEC SQL END   CODE SECTION;
}
