################################################################################
# Copyright(c) 1998-2010 SYSCOM
# All rights reserved.
################################################################################
# 1. Sample purpose:
#    (1) Demonstrate how to return a RESULT SET.
# 2. To create the SQL Stored Procedure
#    (1) Run the script "createtable.sql" to create the schema objects which be 
#        used in this Procedure in advance. For more information, please see
#        the file "createtable.sql".
#    (2) Use DMSQL tool to create the SQL SP, SQL command like:
#        connect to "DBSAMPLE5" "SYSADM" "";
#        // for Windows:
#        create procedure from '@APP_HOME@\samples\SQLSP\resultset.sp';
#        // for Linux:
#        create procedure from '/APP_HOME/samples/SQLSP/resultset.sp';
#    (3) use JDBATool to create the SQL SP:
#        connect to the database.
#        create-procedure-wizard => select language SQL => import resultset.sp 
#        => finish.
# 3. To call the SQL Stored Procedure
#    (1) use DMSQL tool
#        CALL SQLSP_RESULTSET(?);
#
# For more information, see the README file in the same directory.
################################################################################

CREATE PROCEDURE SQLSP_RESULTSET(IN nTOP INT)
LANGUAGE SQL
BEGIN
  # Declare a cursor for RETURN result set
  DECLARE cur1 CURSOR WITH RETURN FOR SELECT * FROM SQLSP_ALLTYPE LIMIT nTOP;
  
  OPEN cur1;
  # DON'T CLOSE cur1
END;
