################################################################################
# Copyright(c) 1998-2010 SYSCOM
# All rights reserved.
################################################################################
# 1. Sample purpose:
#    (1) Demonstrate DYNAMIC SQL.
# 2. To create the SQL Stored Procedure
#    (1) Use DMSQL tool to create the SQL SP, SQL command like:
#        connect to "DBSAMPLE5" "SYSADM" "";
#        create procedure from '<DBMAKER_HOME>/samples/SQLSP/dynamic3.sp';
#    (2) use JDBATool to create the SQL SP:
#        connect to the database.
#        create-procedure-wizard => select language SQL => import dynamic3.sp 
#        => finish.
# 3. To call the SQL Stored Procedure
#    (1) use DMSQL tool
#        CALL SQLSP_DROPTABLES('shory','mytb%',?);
#        CALL SQLSP_DROPTABLES('shory','%',?); // drop all tables of shory
#    Note: The wildcard '_' and '%' can be used.
#
# For more information, see the README file in the same directory.
################################################################################

# This procedure drops all tables matched table name pattern and schema name
# pattern.
CREATE PROCEDURE SQLSP_DROPTABLES(
  IN  schemaNamePtn VARCHAR(128),
  IN  tableNamePtn  VARCHAR(128),
  OUT oDropped INT)
LANGUAGE SQL
BEGIN
  DECLARE sqlStr VARCHAR(1024);
  DECLARE tmpSchemaName VARCHAR(128);
  DECLARE tmpTableName VARCHAR(128);
  DECLARE fgIdCaseSensitive INT DEFAULT 0;
  DECLARE noData INT DEFAULT 0;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET noData = 1;
  
  SET fgIdCaseSensitive = SELECT COUNT(*) FROM SYSCONFIG 
                          WHERE KEYWORD='DB_IDCAP' AND VALUE='0';
  
  SET sqlStr = 'SELECT '
                || 'TRIM(TABLE_OWNER) AS schemaName, '
                || 'TRIM(TABLE_NAME) as tableName '
                || 'FROM SYSTABLE ';
  IF fgIdCaseSensitive > 0 THEN 
    SET sqlStr = sqlStr || 'WHERE TABLE_NAME LIKE ''' || tableNamePtn || ''' ' 
                        || ' AND TABLE_OWNER LIKE ''' || schemaNamePtn || ''' ';
  ELSE
    SET tmpSchemaName = UPPER(schemaNamePtn);
    SET tmpTableName = UPPER(tableNamePtn);
    SET sqlStr = sqlStr || 'WHERE TABLE_NAME LIKE ''' || tmpTableName || ''' ' 
                        || ' AND TABLE_OWNER LIKE ''' || tmpSchemaName || ''' ';
  END IF;
  SET oDropped = 0;
  PREPARE stmt2 FROM sqlStr;
  DECLARE cur2 CURSOR FOR stmt2;
  OPEN cur2;
  LOOP
    FETCH cur2 INTO tmpSchemaName, tmpTableName;
    IF noData = 1 THEN
      BREAK;
    END IF;
    SET sqlStr = 'DROP TABLE "' || tmpSchemaName || '"."' || tmpTableName || '"';
    EXECUTE IMMEDIATE sqlStr;
    SET oDropped = oDropped + 1;
  END LOOP;
  CLOSE cur2;
END;
