################################################################################
# Copyright(c) 1998-2010 SYSCOM
# All rights reserved.
################################################################################
# 1. Sample purpose:
#    (1) Demonstrate DYNAMIC CURSOR.
# 2. To create the SQL Stored Procedure
#    (1) Run the script "createtable.sql" to create the schema objects which be 
#        used in this Procedure in advance. For more information, please see
#        the file "createtable.sql".
#    (2) Use DMSQL tool to create the SQL SP, SQL command like:
#        connect to "DBSAMPLE5" "SYSADM" "";
#        create procedure from '<DBMAKER_HOME>/samples/SQLSP/dynamic2.sp';
#    (3) use JDBATool to create the SQL SP:
#        connect to the database.
#        create-procedure-wizard => select language SQL => import dynamic2.sp 
#        => finish.
# 3. To call the SQL Stored Procedure
#    (1) use DMSQL tool
#        CALL SQLSP_SELECT(?,?);
#
# For more information, see the README file in the same directory.
################################################################################

CREATE PROCEDURE SQLSP_SELECT(OUT oAvgC1 INT, OUT oSumC1 INT)
LANGUAGE SQL
BEGIN
  DECLARE sqlStr VARCHAR(1024);
  DECLARE i INT DEFAULT 0;

  # dynamic cursor
  SET sqlStr = 'SELECT AVG(C1) FROM SQLSP_T1 WHERE C1 >= 0';
  PREPARE stmt1 FROM sqlStr;
  DECLARE cur1 CURSOR FOR stmt1;
  OPEN cur1;
  FETCH NEXT FROM cur1 INTO oAvgC1;
  CLOSE cur1;
  DEALLOCATE PREPARE stmt1;
  
  # dynamic cursor with input parameter
  SET sqlStr = 'SELECT SUM(C1) FROM SQLSP_T1 WHERE C1 >= ?';
  PREPARE stmt1 FROM sqlStr;
  SET i = 0;
  OPEN cur1 USING i; # give input parameter when opening cursor
  FETCH NEXT FROM cur1 INTO oSumC1;
  CLOSE cur1;
  DEALLOCATE PREPARE stmt1;
  
  # dynamic cursor with input paramter and return result set.
  SET sqlStr = 'SELECT C1 FROM SQLSP_T1 WHERE C1 >= ?';
  PREPARE stmt2 FROM sqlStr;
  DECLARE cur2 CURSOR WITH RETURN FOR stmt2;
  SET i = 0;
  OPEN cur2 USING i; # don't close cursor
END;
