#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import sys
from string import *
import pyodbc

# -----------
# show table
# -----------
dbh=pyodbc.connect('DSN=dbsample5;uid=sysadm;pwd=')

sth=dbh.cursor()

print ('')
print ("Now, We are connecting to DB 'dbsample5'...")
print ('')

def show(query):
   sth.execute(query)
   des=sth.description
   result=sth.fetchall()

# sth.description:
# ( column name , column type , None , None , column length , scale , null)
# print column name 
# --------------------------------------
   col = []
   for i in range(len(des)):
      col.append((des[i][0],des[i][4]))
    
   for i in range(len(des)):
      print ('+ %s' % ('='*col[i][1],),end='')
   print ('+')
   
   for i in range(len(des)): 
      buf = col[i][0].center(col[i][1], ' ')
      print ('| %s' % (buf,),end='')
   print ('|')
   
# --------------------------------------
# print result set
# --------------------------------------
   #print(result)
   for i in range(len(result)):
      for j in range(len(result[i])):
         if type(result[i][j]) == int:
             buf = str(result[i][j]).rjust(col[j][1], ' ')
         else:
             buf = str(result[i][j]).ljust(col[j][1], ' ')
         print ('| %s' % (buf,),end='')
      print ('|')

   for i in range(len(des)):
      print ('+ %s' % ('='*col[i][1],),end='')
   print ('+')
   
while 1:
   command=input("Type 'go' to enter or 'quit' to exit...")
   if command == 'go':
      sql=input('Please input SQL select statement...')
      show(sql)
   elif command == 'quit':
      print ('bye!!')
      break
   else:
      print ('Command Error, Please input again...')
      print ('')
sth.close()
dbh.close()