#!/usr/bin/env python
# -*- coding: UTF-8 -*-
# ------------------------------------------------------------------------
# show how to use cursor handle method 'fetchone','fetchmany','fetchall'
# ------------------------------------------------------------------------

import pyodbc

table='py_test'
field1='c1 int'

# build a connection handle 'dbh'
dbh=pyodbc.connect('DSN=dbsample5;uid=sysadm;pwd=')
sth=dbh.cursor()
print ("connection handle 'dbh' is built...")

# build a cursor handle 'sth'
print ("cursor handle 'sth' is built...")

# create table for testing
sth.execute("create table %(table)s (%(field1)s)" %(vars()))

print ("insert 8 tuples of data")
for i in range(8):
   sth.execute("insert into %s values(?)"%table,(i,))
print

sth.execute("select * from %s"%table)

result=sth.fetchone()
print ('result of a fetchone()')
print (result)
print ('')

result=sth.fetchmany(2)
print ('result of the followed fetchmany(2)')
print (result)
print ('')

sth.arraysize=3
result=sth.fetchmany()
print ('result of the followed fetchmany(), arraysize=3')
print (result)
print ('')

result=sth.fetchall()
print ('result of the followed fetchall()')
print (result)

# drop table for testing
sth.execute("drop table %s"%table)
#
sth.close()
dbh.close()