#!/usr/bin/env python
# -*- coding: UTF-8 -*-

# ---------------------------------------------------
# Testing all catalog related methods  of Cursor.
# ---------------------------------------------------

import pyodbc
dbh=pyodbc.connect('DSN=dbsample5;uid=sysadm;pwd=')

# table='py_test'

# build a connection handle 'dbh'
# build a cursor handle 'sth'
sth=dbh.cursor()

# ---------------------------------------------------
# show how to use cursor handle method 'tables'
# ---------------------------------------------------
# tables(table,catalog,schema,tableType)

sth.tables('%', None, 'SYSADM', None)
result=sth.fetchall()

print ("all tables belong to owner SYSADM")
for i in range(len(result)):
	print (result[i])
print

# ---------------------------------------------------
# show how to use cursor handle method 'columns'
# ---------------------------------------------------
# columns(table, catalog, schema, column)

sth.columns('%', None, 'SYSADM', '%')
result=sth.fetchall()

print ("columns in all table belong to owner SYSADM")
for i in range(len(result)):
	print (result[i])
print
print

# ---------------------------------------------------
# show how to use cursor handle method 'procedures'
# ---------------------------------------------------
# procedures(procedure, catalog, schema)

sth.procedures('%', None, 'SYSADM')
result=sth.fetchall()

print ("all procedures belong to owner SYSADM")
for i in range(len(result)):
    print (result[i])
print
print

# -------------------------------------------------------
# show how to use cursor handle method 'procedurecolumns'
# -------------------------------------------------------
# procedurecolumns(procedure, catalog, schema)

sth.procedureColumns('%', None, 'SYSADM')
result=sth.fetchall()

print ("all procedurecolumns belong to owner SYSADM")
for i in range(len(result)):
    print (result[i])
print
print

# -----------------------------------------------------
# show how to use cursor handle method 'rowIdColumns'
# -----------------------------------------------------
# rowIdColumns(table, catalog, schema, nullable)

sth.rowIdColumns('%', None, 'SYSADM', 1)
result=sth.fetchall()

print( "all rowIdColumns belong to owner SYSADM")
for i in range(len(result)):
    print (result[i])
print
print

# ---------------------------------------------------
# show how to use cursor handle method 'statistics'
# ---------------------------------------------------
# statistics(catalog, schema, unique, quick)

sth.statistics('%', None, 'SYSADM', 1, 1)
result=sth.fetchall()

print ("all statistics belong to owner SYSADM")
for i in range(len(result)):
    print (result[i])
print
print

# ---------------------------------------------------
# show how to use cursor handle method 'foreignKeys'
# ---------------------------------------------------
# foreignKeys(table, catalog, schema, foreignTable, foreignCatalog, foreignSchema)

sth.foreignKeys('%', None, 'SYSADM', '%', None, 'SYSADM')
result=sth.fetchall()

print ("all foreignKeys belong to owner SYSADM")
for i in range(len(result)):
    print (result[i])
print
print

# ---------------------------------------------------
# show how to use cursor handle method 'primaryKeys'
# ---------------------------------------------------
# primaryKeys(table, catalog, schema)

sth.primaryKeys('%', None, 'SYSADM')
result=sth.fetchall()

print ("all primaryKeys belong to owner SYSADM")
for i in range(len(result)):
    print (result[i])
print
print

sth.close()
dbh.close()