disconnect;
connect to dbsample5 SYSADM;
grant connect to voteadm;
grant dba to voteadm;
disconnect;

connect to dbsample5 voteadm;
drop table voteitem;
drop table vote;
drop table item;
drop table topic;

create table topic (
 tid  INTEGER not null,
 name  VARCHAR(256),
 itemnum  SMALLINT default 0,
 multiselect  int default 0,
 multipoll  int default 0,
 havecomment int default 0
);
alter table topic primary key ( tid) ;

create table item (
 iid  SERIAL(1),
 tid  INTEGER,
 name  VARCHAR(256)
);
alter table item primary key (iid);
alter table item foreign key fk1 (tid) references topic (tid)
 on update cascade on delete cascade;
create trigger tg1 after insert on item for each row (
  update topic set itemnum=itemnum+1 where tid=new.tid
);
create trigger tg2 after delete on item for each row (
  update topic set itemnum=itemnum-1 where tid=old.tid
);

create table vote (
 vid  SERIAL(1),
 tid  INTEGER,
 hostname  VARCHAR(128)
);
alter table vote primary key (vid);
alter table vote foreign key fk1 (tid) references topic (tid)
 on update cascade on delete cascade;

create table voteitem (
 vid  INTEGER not null,
 tid  INTEGER not null,
 iid  INTEGER not null,
 comment  VARCHAR(256)
);
alter table voteitem primary key (vid,tid,iid);
alter table voteitem foreign key fk1 (tid) references topic (tid)
 on update cascade on delete cascade;
alter table voteitem foreign key fk2 (iid) references item (iid)
 on update cascade on delete cascade;
alter table voteitem foreign key fk3 (vid) references vote (vid)
 on update cascade on delete cascade;

insert into topic values(11111,'Test topic, please delete me from voteadmin.php');
insert into item values(,11111,'Test item1');
insert into item values(,11111,'Test item2');
