<?php
// Usage:
//  poll(topic_id,
//       topic_format,
//       topic_font,
//       item_format,
//       item_font,
//       result_type);
//
// Ex:
//     include "poll.inc";
//     poll(928202270,
//          "BORDER=0 CELLSPACING=0 WIDTH=\"150\" BGCOLOR=\"#FFCC00\"",
//          "face=\"Helvetica,Arial\"",
//          "BORDER=0 CELLSPACING=0 WIDTH=\"150\" BGCOLOR=\"#FFFFCC\"",
//          "face=\"Helvetica,Arial\" size=-1",
//          0);
//

$COLORBAR = "colorbar.php";
$Cn=odbc_connect("dbsample5","voteadm","");
$TYPE=$_REQUEST['TYPE'];

function poll($tid, $topicopt, $topicfont, $itemopt, $itemfont, $outtype)
{
  global $Cn, $PHP_SELF, $TYPE;

  if(isset($TYPE) && isset($tid))
  {
    if(insert($tid)==1)			// Success insert
    {
      if($TYPE==1)
        popup_result($tid, $topicopt, $topicfont, $itemopt, $itemfont);
      else
        simple_result($tid, $topicopt, $topicfont, $itemopt, $itemfont);
      return;
    }
  }  // Missing variable or insert fail.

  $R=odbc_exec($Cn,"select itemnum,multiselect,havecomment from topic where tid=$tid");
  $Itemnum = odbc_result($R,1);
  $Multiselect = odbc_result($R,2);
  $Havecomment = odbc_result($R,3);
  odbc_free_result($R);

  if($outtype==0)		// simple poll result
  {
    echo "<form method=\"post\" action=\"$PHP_SELF?TYPE=0&Tid=$tid\">\n";
  }
  else				// popup poll result
  {
    ?>
    <script language="JavaScript">
    <!-- hide
    // open new window
    function openWindow(url, name, rs, w, h) {
      var resize = "";
      if (rs) {
        resize = "resizable,";
      }
      self.name="opener";
      popupWin = window.open(url, name, 'scrollbars,menubar,' + resize + 'width=' + w + ',height=' + h);
    }
    // done hiding -->
    </script>
    <?php
    echo "<form method=\"post\" action=\"$PHP_SELF?TYPE=1&Tid=$tid\" onsubmit=\"openWindow('','pollWin',false,500,400)\" target=\"pollWin\">\n";
  }
  // topic
  $R=odbc_exec($Cn,"select name from topic where tid=$tid");
  $name = odbc_result($R,1);
  odbc_free_result($R);
  echo "<table $topicopt><tr><td>\n";
  echo " <table border=\"0\" cellpadding=\"2\" cellspacing=\"0\">\n";
  echo "  <tr>\n";
  echo "   <td>\n";
  echo "    <font $topicfont>$name</font>\n";
  echo "   </td>\n";
  echo "  </tr>\n";
  echo " </table>\n";
  echo "</td></tr></table>\n";
  // item
  $R=odbc_exec($Cn,"select name,iid from item where tid=$tid");
  echo "<table $itemopt><tr><td>\n";
  echo " <table border=\"0\" cellpadding=\"2\" cellspacing=\"0\">\n";
  for($i=1;$i<=$Itemnum;$i++)
  {
    $text=odbc_result($R,1);
    $iid =odbc_result($R,2);
    odbc_fetch_row($R);
    echo "  <tr>\n";
    if($Multiselect==0)
      echo "   <td><input type='radio' name='iid1' value='$iid'></td>\n";
    else
      echo "   <td><input type='checkbox' name='iid$i' value='$iid'></td>\n";
    echo "   <td width=100%><font $itemfont>$text\n";
    if($Multiselect==1 && $Havecomment==1)
      echo "    <BR><input type='text' name='comment$i' size=8>\n";
    echo "   </font></td>\n";
    echo "  </tr>\n";
  }
  echo "  <tr>\n";
  echo "   <td>&nbsp;</td>\n";
  echo "   <td><font $itemfont>";
  if($Multiselect==0 && $Havecomment==1)
    echo "    <input type='text' name='comment1' size=8>\n";
  echo "     <input type=\"submit\" value=\"Submit\"></font></td>\n";
  echo "   </tr>\n";
  echo " </table>\n";
  echo "</tr></td></table>\n";
  echo "</form>\n";
}

function insert($Tid)
{
  global $Cn, $TYPE, $BackURL;

  // Check for multi-poll
  $ip = getenv("REMOTE_ADDR");
  if(getenv("HTTP_VIA"))
  { 
    if(getenv("HTTP_FORWARDED"))
      $ip = getenv("HTTP_FORWARDED");
    elseif(getenv("HTTP_X_FORWARDED_FOR"))
      $ip = getenv("HTTP_X_FORWARDED_FOR");
  }
  $R=odbc_exec($Cn,"select itemnum,multiselect,multipoll,havecomment from topic where tid=$Tid");
  $Itemnum     = odbc_result($R,1);
  $Multiselect = odbc_result($R,2);
  $Multipoll   = odbc_result($R,3);
  $Havecomment = odbc_result($R,4);
  odbc_free_result($R);
  if($Multipoll==0)				// Not allow multi-poll
  {
    $R=odbc_exec($Cn,"select count(hostname) from vote where tid=$Tid and hostname='$ip'");
    odbc_fetch_row($R);
    $Counthost=odbc_result($R,1);
    if($Counthost>=1)
       return 1;
  }

  // Check for fill form
  $input_check=0;
  for($i=1;$i<=$Itemnum;$i++){
    $iidnum=$_REQUEST["iid$i"];
    $input_check |= $iidnum;
  }
  if($input_check==0)
    return 0;

  //
  // Start transaction
  //
  odbc_autocommit($Cn, 0);
  $Rs=odbc_prepare($Cn,"insert into vote values(,?,?)");
  $para[0]=$Tid;
  $para[1]=$ip;
  if(!odbc_execute($Rs,$para))
  {
    odbc_rollback($Cn);
    return 0;
  }
  odbc_free_result($Rs);
  $Rs=odbc_exec($Cn,"select LAST_SERIAL from SYSCONINFO");
  $Vid=odbc_result($Rs,1);
  odbc_free_result($Rs);
  // insert item
  $Rs=odbc_prepare($Cn,"insert into voteitem values(?,?,?,?)");
  $param[0]=$Vid;
  $param[1]=$Tid;
  for($i=1;$i<=$Itemnum;$i++)
  {
    $iidnum=$_REQUEST["iid$i"];
    if(!isset($iidnum))	// No choice, don't insert
      continue;
    $iid=$iidnum;
    $comment=NULL;
    if($Havecomment==1)
      $comment=$_REQUEST["comment$i"];
    $param[2]=$iid;
    $param[3]=$comment;
    if(!odbc_execute($Rs,$param))	// Insert fail, rollback
    {
      odbc_rollback($Cn);
      return 0;
    }
    if($Multiselect==0)			// single item select
      break;
  }
  odbc_commit($Cn);
  return 1;
}

function simple_result($tid, $topicopt, $topicfont, $itemopt, $itemfont)
{
  global $Cn, $COLORBAR;
  // topic
  $c = array("00CCCC",
             "9999FF",
             "FF9999",
             "66CC00",
             "006699",
             "FFCC99",
             "6666FF",
             "FF66CC",
             "33FF33",
             "CC3300",
             "FFFF00");
  // topic
  $R=odbc_exec($Cn,"select name from topic where tid=$tid");
  $name = odbc_result($R,1);
  odbc_free_result($R);
  echo "<table $topicopt><tr><td>\n";
  echo " <table border=\"0\" cellpadding=\"2\" cellspacing=\"0\">\n";
  echo "  <tr>\n";
  echo "   <td>\n";
  echo "    <font $topicfont>$name</font>\n";
  echo "   </td>\n";
  echo "  </tr>\n";
  echo " </table>\n";
  echo "</td></tr></table>\n";
  // item
  $R=odbc_exec($Cn,"select count(*) from voteitem where tid=$tid");
  $total = odbc_result($R,1);
  odbc_free_result($R);
  $R=odbc_exec($Cn,"select item.name, count(voteitem.iid)" .
                   " from item, outer voteitem" .
                   " where item.tid=$tid and item.iid=voteitem.iid" .
                   " group by item.name order by 2 desc, 1");
  echo "<table $itemopt><tr><td>\n";
  echo " <table>\n";
  echo "  <tr>\n";
  echo "   <td>\n";
  do
  {
    $name  = odbc_result($R,1);
    $count = odbc_result($R,2);
    if($total!=0)
      $len = (int)round($count/$total*100);
    else
      $len = 0;
    $color = $c[(int)($len/10)];
    echo "<img src=\"$COLORBAR?COLOR=$color\" " .
         "width=\"$len\" height=\"10\" border=0><br>\n";
    echo "<font $itemfont>";
    printf("%.0f%% &nbsp;&nbsp;%s", $len, $name);
    echo "</font><br>\n";
    echo "<font size=\"-4\">&nbsp;<br></font>\n";
  } while (odbc_fetch_row($R));
  echo "<font $itemfont>Total votes: $total</font>\n";
  echo "   </td>\n";
  echo "  </tr>\n";
  echo " </table>\n";
  echo "</td></tr></table>\n";
}

?>
