<?php
/****************************************************************************
 *  odbc_catalogs.php
 *		testing php odbc catalog functions (valid after php4 beta 3)
 ****************************************************************************/
?>
<html>
  <head>
    <title>odbc catalog function test</title>
  </head>

  <body BGCOLOR="#ffffff">
    <?php
    $conn = odbc_connect('dbsample5', 'SYSADM', '');

    if ($conn)
      {
      // create sample table
	  error_reporting(0);
      odbc_exec($conn, 'drop table php_catalog3');
      odbc_exec($conn, 'drop table php_catalog2');
      odbc_exec($conn, 'drop table php_catalog');
	  error_reporting(7);
      odbc_exec($conn,
                'create table php_catalog (id int not null, ' .
                'name varchar(20) not null, buy_date date, ' .
                'price decimal(10, 3), ' .
                'picture long varbinary, primary key(id, name))');

      odbc_exec($conn,
                'create table php_catalog2(id int not null, ' .
                'cid int, label varchar(20), schedule timestamp, ' .
				'primary key (id), ' .
                'foreign key fk1(cid, label) ' .
                'references php_catalog(id, name))');

      odbc_exec($conn,
                'create table php_catalog3(c1 char(10), c2 float, ' .
                'c3 int, c4 serial primary key, c5 varchar(20), c6 time, ' .
                'c7 double, c8 int, ' .
                'foreign key fkey1(c3) references php_catalog2(id), ' .
                'foreign key fkey2(c8, c5) references php_catalog(id, name))');

                 
      // test odbc_tables
      $rs = odbc_tables($conn, '', 'SYSADM', '%', '%');
	  echo 'tables of SYSADM<br>';
      $cnt = odbc_result_all($rs, 'border="1"');
	  echo $cnt, ' tables/views total<p>';
      odbc_free_result($rs);

      // test odbc_columns
      $rs = odbc_columns($conn, '', 'SYSADM', 'php_catalog', '%');
	  echo 'columns of php_odbclog<br>';
      $cnt = odbc_result_all($rs, 'border="1"');
	  echo $cnt, ' columns total<p>';
      odbc_free_result($rs);

      // test odbc_primarykeys
      $rs = odbc_primarykeys($conn, '', 'SYSADM', 'php_catalog');
	  echo 'primary key of php_catalog<br>';
      $cnt = odbc_result_all($rs, 'border="1"');
	  echo $cnt, ' items total<p>';
      odbc_free_result($rs);

      // test odbc_foreignkeys
      /***********************************************************************
       *  case 1: get the relations that all foreign keys references the 
       *           primary key of php_catalog.
       ***********************************************************************/
      $rs = odbc_foreignkeys($conn, '', 'SYSADM', 'php_catalog', 
                                    '', '', '');
	  echo 'all foreign keys references primary key of php_catalog<br>';
      $cnt = odbc_result_all($rs, 'border="1"');
	  echo $cnt, ' items total<p>';
      odbc_free_result($rs);

      /***********************************************************************
       *   case 2: get the relations that all primary key(s) which referenced
       *           by the foreign key(s) of php_catalog2.
       ***********************************************************************/
      $rs = odbc_foreignkeys($conn, '', '', '', 
                                    '', 'SYSADM', 'php_catalog2');
	  echo 'all primary key(s) referenced by foreign keys of php_catalog2<br>';
      $cnt = odbc_result_all($rs, 'border="1"');
	  echo $cnt, ' items total<p>';
      odbc_free_result($rs);

      /***********************************************************************
       *   case 3: get relations that the primary key of php_catalog which
       *           referenced by the foreign key of php_catalog2.
       ***********************************************************************/
      $rs = odbc_foreignkeys($conn, 0, 'SYSADM', 'php_catalog', 
                                    0, 'SYSADM', 'php_catalog2');
	  echo 'all foreign keys of php_catalog2 references the primary key of '.
           'php_catalog<br>';
      $cnt = odbc_result_all($rs, 'border="1"');
	  echo $cnt, ' items total<p>';
      odbc_free_result($rs);

      // test odbc_procedures
      $rs = odbc_procedures($conn, 0, 'SYSADM', '%'); 
	  echo 'all procedures of SYSADM<br>';
      $cnt = odbc_result_all($rs, 'border="1"');
	  echo $cnt, ' procedures total<p>';
      odbc_free_result($rs);

      // test odbc_procedurecolumns
      $rs = odbc_procedurecolumns($conn, 0, 'SYSADM', 'insertalltype', '%'); 
	  echo 'all columns of SYSADM.insertalltype<br>';
      $cnt = odbc_result_all($rs, 'border="1"');
	  echo $cnt, ' columns total<p>';
      odbc_free_result($rs);

      // test odbc_gettypeinfo
      $rs = odbc_gettypeinfo($conn);
	  echo 'info of all data types.<br>';
      $cnt = odbc_result_all($rs, 'border="1"');
	  echo $cnt, ' types total<p>';
      odbc_free_result($rs);

      // test odbc_specialcolumns
      $rs = odbc_specialcolumns($conn, 1 /* sql_best_rowid */,
                             '', 'SYSADM', 'php_catalog',
                             1 /* sql_scope_transaction */,
                             1 /* sql_nullable */);
	  echo 'info of special columns.<br>';
      $cnt = odbc_result_all($rs, 'border="1"');
	  echo $cnt, ' items total<p>';
      odbc_free_result($rs);

      // test odbc_statistics
      $rs = odbc_statistics($conn, '', 'SYSADM', 'p%, t_, v1, v%, t%',
                            1 /* sql_index_all */, 0 /* sql_quick */);
	  echo 'update statistics<br>';
      $cnt = odbc_result_all($rs, 'border="1"');
	  echo $cnt, ' items total<p>';
      odbc_free_result($rs);

      $rs = odbc_statistics($conn, '', 'SYSADM', 'p%, t_, v1, v%, t%',
                            0 /* sql_index_unique */, 0 /* sql_quick */);
	  echo 'update statistics<br>';
      $cnt = odbc_result_all($rs, 'border="1"');
	  echo $cnt, ' items total<p>';
      odbc_free_result($rs);




      odbc_close($conn);
      }    
    ?>
  </body>
</html>
