/**************************************************************************
 *
 *  Copyright(C) 1995 - 2007 CaseMaker Inc. All rights reserved.
 *
 ************************************************************************/

#include <stdio.h>
#include <string.h>

#ifdef WIN32
#include <windows.h>
#else
#include "sqlunix.h"
#endif
#include "sqlext.h"
#include "sqlopt.h"

/* define some costant for ex1.c and ex2.c */
#define DSN      "DBSAMPLE5"
#define UID      "SYSADM"
#define PWD      ""

#define ntb1      5    /* number of tuples in tb1 */
#define ntb2     10    /* number of tuples in tb2 */

#define RTN_OK    0    /* return code OK          */

/* MACRO to show error message */
#define getErrMsg(rc, rightrc, xhenv, xhdbc, xcmdp)\
{\
UCHAR   outmsg[100],xstate[10];\
SWORD   size=100;\
SWORD   msglen;\
SDWORD  nativerc=0;\
SDWORD  xrc=0;\
xrc=SQLError(xhenv,xhdbc,xcmdp,xstate,&nativerc,outmsg,size,&msglen);\
if (xrc == SQL_SUCCESS || xrc == SQL_SUCCESS_WITH_INFO)\
   {\
   if (rightrc != nativerc) \
      {\
      printf("------------------ Error ------------------\n"\
             "Line %d\n"\
             "Unexpected return code: %ld\n"\
             "Error message: %s\n"\
             "-------------------------------------------\n", \
             __LINE__, nativerc, outmsg); \
      rc = nativerc;\
      }\
   }\
}

#define checkrc(rightrc, xhenv, xhdbc, xcmdp)\
{\
SDWORD  rrc=0;\
getErrMsg(rrc, rightrc, xhenv, xhdbc, xcmdp)\
if (rrc != rightrc)\
   goto EXIT;\
}

/* MACRO to show error message */





