//////////////////////////////////////
// Credate database dbsample5
create db dbsample5;

//////////////////////////////////////
// Create user, schema, group
grant connect to SAMPLEUSER;
grant resource to SAMPLEUSER;
grant dba to SAMPLEUSER;
create schema Sample authorization SampleUser;
create schema Fulltext authorization SampleUser;
grant connect to CMDUSER;
Create group CMDGROUP;
Add CMDUSER to group CMDGROUP;

///////////////////////////////////////////////////////
// Create table FULLTEXT.NEWS for demo fulltext
create table FULLTEXT.NEWS (
 ID  INTEGER not null  ,
 TITLE  VARCHAR(80) default null ,
 EDITOR  CHAR(20) default null ,
 SOURCE  CHAR(40) default null ,
 CONTENT  LONG VARCHAR default null ,
 PUBDATE  DATE default null );
 
insert into FULLTEXT.NEWS values (?,?,?,?,?,?) ;
2, 'China trains all county officials for building new countryside', 'Shanglin\
 Luan       ', 'Xinhua                                  ', &data1.b0(0,223\
6), '2007-01-26';
3, 'Legislator: China needs harmonious world', 'Mu Xuequan          ', 'Xinhua\
                                  ', &data1.b0(2236,2506), '2007-01-29';
4, 'At least 12 killed as overhead power line hits passenger train in southern\
 Pakis', 'unknow              ', 'Xinhua                                  ', &\
data1.b0(4742,1369), '2007-01-25';
5, 'Palestine sends one-athlete delegation to Winter Asiad for friendship', NU\
LL, 'Xinhua                                  ', &data1.b0(6111,1501), '200\
7-01-28';
6, 'Chinese, Liberian leaders meet on closer ties ', 'Chen Feng           ', '\
Xinhua                                  ', &data1.b0(7612,717), '2007-02-0\
1';
7, 'China''s maiden altiplano train run receives cheers ', 'Chen Feng         \
  ', 'Xinhua                                  ', &data1.b0(8329,376), '200\
6-07-02';
1, 'Sixth Asian Winter Games opens in China', 'Chen Feng           ', 'Xinhua \
                                 ', &data1.b0(8705,588), '2007-01-28';
end; 

alter table FULLTEXT.NEWS primary key ( ID) in DEFTABLESPACE;
create  text index IDX_NEWS_CONTENT on FULLTEXT.NEWS ( CONTENT )  total text s\
ize 32 mb  scale 40  order by PUBDATE desc ;
create  text index IDX_NEWS_TITLE on FULLTEXT.NEWS ( TITLE )  total text size \
32 mb  scale 40  ;

create ivf text index IVF_NEWS_TITLE_CON on FULLTEXT.NEWS ( TITLE, CONTENT )  \
storage path DB_DBDIR  total text size 500 mb  ;

//////////////////////////////////////////////////////////////////////////
// Create table SAMPLE.BOOKS for fulltext in delphi sample code
create table SAMPLE.BOOKS (
 ID  SERIAL(1),
 NAME  VARCHAR(50) default null ,
 AUTHOR  VARCHAR(30) default null ,
 SUBJECT  VARCHAR(80) default null ,
 INTRODUCTION  LONG VARCHAR default null ,
 CONTENT  FILE );

insert into SAMPLE.BOOKS values (?,?,?,?,?,?) ;
1, 'How to configure Linux+Apache+DBMaker+PHP', 'shory,shang         ', 'How t\
o configure Linux+Apache+DBMaker', &data1.b0(9293,110), &'data2.b0';
3, 'Migration from Mysql to DBMaker', 'DBMaker Support Team', 'Migration Rule\
 and Method from Mysql to DBMaker', &data1.b0(9403,663), &'data3.b0';\

2, 'DBMaker Stored Procedure Guide', 'DBMaker Support & Test Team', 'How to cr\
eate and use Stored Procedure in DBMaker', &data1.b0(10066,765), &'data4.b0';
end; 
alter table SAMPLE.BOOKS primary key ( ID) in DEFTABLESPACE;

create ivf text index IDX_BOOKS_CONTENT on SAMPLE.BOOKS ( CONTENT )  storage p\
ath DB_DBDIR  total text size 500 mb  ;
create  text index IDX_BOOKS_INTRO on SAMPLE.BOOKS ( INTRODUCTION )  total tex\
t size 32 mb  scale 40  ;
create  text index IDX_BOOKS_NAME on SAMPLE.BOOKS ( NAME )  total text size 32\
 mb  scale 40  ;
create  text index IDX_BOOKS_SUBJECT on SAMPLE.BOOKS ( SUBJECT )  total text s\
ize 32 mb  scale 40  ;

///////////////////////////////////////////////////////////////////////
// Create table SAMPLE.CARD for demo blob(image) in VB sample code
create table SAMPLE.CARD (
 ID  SERIAL(1),
 FNAME  VARCHAR(30) default null ,
 LNAME  VARCHAR(30) default null ,
 TITLE  VARCHAR(30) default null ,
 PHOTO  LONG VARBINARY default null );
insert into SAMPLE.CARD values (?,?,?,?,?) ;
1, 'Eddie', 'Chang', 'Manager', &data1.b0(10831,6666);
2, 'Hook', 'Hu', 'Software Engineer', &data1.b0(17497,6666);
3, 'Jackie', 'Yu', 'Software Engineer', &data1.b0(24163,6666);
4, 'Ray', 'Sung', 'Software Engineer', &data1.b0(30829,6666);
5, 'Louis', 'Liu', 'Software Engineer', &data1.b0(37495,6666);
6, 'Trent', 'Clowater', 'Software Engineer', &data1.b0(44161,6666);
7, 'Oscar', 'Tseng', 'Software Engineer', &data1.b0(50827,6666);
8, 'Jerry', 'Liu', 'Manager', &data1.b0(57493,6666);
end; 
alter table SAMPLE.CARD primary key ( ID) in DEFTABLESPACE;

///////////////////////////////////////////////////////////////
// Create table SAMPLE.EMPLOYEE for demo trigger
create table SAMPLE.EMPLOYEE (
 ID  INTEGER not null  ,
 NAME  VARCHAR(20) default null ,
 ADDRESS  VARCHAR(50) default null );
insert into SAMPLE.EMPLOYEE values (?,?,?) ;
123, 'Kaly', 'Beijing';
end; 
alter table SAMPLE.EMPLOYEE primary key ( ID) in DEFTABLESPACE;

///////////////////////////////////////////////////////////////
// Create table SAMPLE.EMPLOYEE_BAK for demo trigger
create table SAMPLE.EMPLOYEE_BAK (
 ID_NOW  INTEGER default null ,
 ID_OLD  INTEGER default null ,
 NAME_NOW  VARCHAR(20) default null ,
 NAME_OLD  VARCHAR(20) default null ,
 ADDR_NOW  VARCHAR(50) default null ,
 ADDR_OLD  VARCHAR(50) default null ,
 MODI_DATE  DATE default null );
insert into SAMPLE.EMPLOYEE_BAK values (?,?,?,?,?,?,?) ;
123, 123, 'Kaly', 'Kaly', 'Beijing', 'Wuhan', '2007-03-22';
123, 123, 'Kaly', 'Kaly', 'Beijing', 'Wuhan', '2007-03-22';
end; 

/////////////////////////////////////////////////////////////////
// Create table SAMPLE.HISTORY for demo SP(shared object)
create table SAMPLE.HISTORY (
 REGNO  INTEGER default null ,
 NUMBER  INTEGER default null ,
 REGTIME  TIMESTAMP default NOW() );
insert into SAMPLE.HISTORY values (?,?,?) ;
end; 

/////////////////////////////////////////////////////////////////
// Create table SAMPLE.PATINET for demo SP(shared object)
create table SAMPLE.PATIENT (
 NUMBER  SERIAL(1),
 NAME  CHAR(10) default null );
insert into SAMPLE.PATIENT values (?,?) ;
end; 

//////////////////////////////////////////////////////////////////
// Create table SAMPLE.LARGETYPE for demo blob,clob,nclob file
// in ASP.NET, VB.NET, C# sample codes
create table SAMPLE.LARGETYPE (
 C0_ID  SERIAL(1),
 C1_CLOB  LONG VARCHAR default null ,
 C2_BLOB  LONG VARBINARY default null ,
 C3_NCLOB  NCLOB default null ,
 C4_FILE  FILE );

insert into SAMPLE.LARGETYPE values (?,?,?,?,?) ;
1, &'data5.b0', &'data5.b0', &'data5.b0', &'data5.b0';
end; 
alter table SAMPLE.LARGETYPE primary key ( C0_ID) in DEFTABLESPACE;

//////////////////////////////////////////////////////////////////
// Create table SAMPLE.ORDINARYTYPE for demo ordinary data
// in ASP.NET, VB.NET, C# sample codes and SP, Stored Command, etc.
create table SAMPLE.ORDINARYTYPE (
 C00_ID  SERIAL(1),
 C01_INT16  SMALLINT default null ,
 C02_INT32  INTEGER default null ,
 C03_FLOAT  FLOAT default null ,
 C04_DOUBLE  DOUBLE default null ,
 C05_DECIMAL  DECIMAL(20, 4) default null ,
 C06_BINARY  BINARY(10) default null ,
 C07_CHAR  CHAR(20) default null ,
 C08_VARCHAR  VARCHAR(20) default null ,
 C09_NCHAR  NCHAR(20) default null ,
 C10_NVARCHAR  NVARCHAR(20) default null ,
 C11_DATE  DATE default null ,
 C12_TIME  TIME default null ,
 C13_TIMESTAMP  TIMESTAMP default null );
insert into SAMPLE.ORDINARYTYPE values (?,?,?,?,?,?,?,?,?,?,?,?,?,?) ;
1, -32768, -2147483648, -2.000000e-38, -3.00000000000000e-308, -99999999999999\
99.9999, '4142434445464748494a'x, 'AAAABBBBCCCCDDDDEEEE', 'AAAABBBBCCCCDDDDEEE\
E', '4100410041004100420042004200420043004300430043004400440044004400450045004\
5004500'u, '410041004100410042004200420042004300430043004300440044004400440045\
00450045004500'u, '2006-04-25', '10:23:30.000', '2006-04-25 10:23:30.000';
2, 0, 0,  0.000000e+00,  0.00000000000000e+000, 0.0000, 'babad7d6babad7d6baba'\
x, 'ֺֺֺֺ', 'ֺֺֺֺ', '496c575b496c575b496c575b49\
6c575b496c575b496c575b496c575b496c575b496c575b496c575b'u, '496c575b496c575b496\
c575b496c575b496c575b496c575b496c575b496c575b496c575b496c575b'u, '2006-04-26',\
 '23:32:45.000', '2006-04-26 23:32:45.000';
3, 32767, 2147483647,  3.402823e+38,  1.00000000000000e+308, 9999999999999999.\
9999, 'a5a2a5d7a5eaa5b1a960'x, 'ץꥱ`    ', 'ץꥱ`', 'a2\
30d730ea30b130fc30b730e730f330200020002000200020002000200020002000200020002000\
'u, 'a230d730ea30b130fc30b730e730f330'u, '2007-01-25', '12:34:56.000', '2006-1\
2-29 12:23:34.000';
4, 12345, 456789,  1.234568e+05,  1.23456789012346e+008, 1234567890123.4567, '\
62696e61727900000000'x, 'char                ', 'varchar', '6e0063006800610072\
00200020002000200020002000200020002000200020002000200020002000'u, '6e007600610\
072006300680061007200'u, '2007-01-28', '12:01:45.000', '2007-01-28 12:12:12.00\
0';
123, 123, 234,  3.450000e+02,  4.56000000000000e+002, 567.0000, '62696e6172790\
0000000'x, 'char                ', 'varchar', '6e00630068006100720020002000200\
0200020002000200020002000200020002000200020002000'u, '6e0076006100720063006800\
61007200'u, '2007-03-22', '12:34:56.000', '2006-12-29 12:23:34.000';
end; 
alter table SAMPLE.ORDINARYTYPE primary key ( C00_ID) in DEFTABLESPACE;

//////////////////////////////////////////////////////////////////
// Create table SAMPLE.UNICODETYPE for demo Unicode character
// 
create table SAMPLE.UNICODETYPE (
 C0_ID  SERIAL(1),
 C1_NCHAR  NCHAR(40) default null ,
 C2_NVARCHAR  NVARCHAR(40) default null ,
 C3_NCLOB  NCLOB default null );
insert into SAMPLE.UNICODETYPE values (?,?,?,?) ;
1, '6100700070006c00690063006100740069006f006e00200020002000200020002000200020\
002000200020002000200020002000200020002000200020002000200020002000200020002000\
20002000'u, '6100700070006c00690063006100740069006f006e00'u, '6100700070006c00\
690063006100740069006f006e00'u;
2, 'a230d730ea30b130fc30b730e730f330200020002000200020002000200020002000200020\
002000200020002000200020002000200020002000200020002000200020002000200020002000\
20002000'u, 'a230d730ea30b130fc30b730e730f330'u, 'a230d730ea30b130fc30b730e730\
f330'u;
3, '807b534f2d4e8765945e28750b7a8f5e200020002000200020002000200020002000200020\
002000200020002000200020002000200020002000200020002000200020002000200020002000\
20002000'u, '807b534f2d4e8765945e28750b7a8f5e'u, '807b534f2d4e8765945e28750b7a\
8f5e'u;
4, '417ed49a2d4e8765c96128750b7a0f5f200020002000200020002000200020002000200020\
002000200020002000200020002000200020002000200020002000200020002000200020002000\
20002000'u, '417ed49a2d4e8765c96128750b7a0f5f'u, '417ed49a2d4e8765c96128750b7a\
0f5f'u;
5, '6200790065005f00553088306a3089305f008d51c189200020002000200020002000200020\
002000200020002000200020002000200020002000200020002000200020002000200020002000\
20002000'u, '6200790065005f00553088306a3089305f008d51c189'u, '6200790065005f00\
553088306a3089305f008d51c189'u;
6, '640061007400610062006100730065002c00c730fc30bf30d930fc30b9302c0070656e6393\
5e2c00c78c9965ab5e200020002000200020002000200020002000200020002000200020002000\
20002000'u, '640061007400610062006100730065002c00c730fc30bf30d930fc30b9302c007\
0656e63935e2c00c78c9965ab5e'u, '640061007400610062006100730065002c00c730fc30bf\
30d930fc30b9302c0070656e63935e2c00c78c9965ab5e'u;
end; 
alter table SAMPLE.UNICODETYPE primary key ( C0_ID) in DEFTABLESPACE;

///////////////////////////////////////////////////////////////////
// Create Stored Command
create command SAMPLE.CMD_SELECT as SELECT c00_id,c01_int16,c02_int32,c03_floa\
t,c04_double,c05_decimal,c06_binary,c07_char,c08_varchar,c09_nchar, c10_nvarch\
ar,c11_date,c12_time,c13_timestamp FROM SAMPLE.OrdinaryType;
create command SAMPLE.CMD_DELETE as DELETE FROM SAMPLE.OrdinaryType WHERE c00_\
id=?;
create command SAMPLE.CMD_UPDATE as UPDATE SAMPLE.OrdinaryType SET c01_int16=?\
,c02_int32=?, c03_float=?,c04_double=?,c05_decimal=?,c06_binary=?,c07_char=?,c\
08_varchar=?, c09_nchar=?,c10_nvarchar=?,c11_date=?,c12_time=?,c13_timestamp=?\
 WHERE c00_id=?;
create command SAMPLE.CMD_INSERT as INSERT INTO SAMPLE.ORDINARYTYPE VALUES(?,?\
,?,?,?,?,?,?,?,?,?,?,?,?);

/////////////////////////////////////////////////////////////////
// Create Stored Procedure

load procedure from sp1;

/////////////////////////////////////////////////////////////////
// Create Trigger
CREATE TRIGGER InsertSP BEFORE INSERT ON SAMPLE.Employee FOR EACH ROW (call sa\
mple.sp_Trigger(new.id,new.name,new.address) );
CREATE TRIGGER TriggerDelete BEFORE DELETE ON SAMPLE.Employee FOR EACH ROW ( D\
ELETE FROM SAMPLE.Employee_bak WHERE id_Now=old.id AND name_Now=old.name AND a\
ddr_Now=old.address );
CREATE TRIGGER TriggerInsert AFTER INSERT ON SAMPLE.Employee FOR EACH ROW ( IN\
SERT INTO SAMPLE.Employee_bak VALUES ( new.id, new.id, new.name, new.name, new\
.address, new.address, CURDATE() ) );
CREATE TRIGGER TriggerUpdate AFTER UPDATE ON SAMPLE.Employee FOR EACH ROW ( UP\
DATE SAMPLE.Employee_bak SET id_Now=new.id, id_Old=old.id, name_Now=new.name, \
name_Old=old.name, addr_Now=new.address, addr_Old=old.address, modi_date=CURDA\
TE() WHERE id_Now=old.id AND name_Now=old.name AND addr_Now=old.address );

///////////////////////////////////////////////
// terminate database and quit dmSQL
terminate db;
quit;