<!-----------------------------------------------------------------------
	Copyright(c) 1997 - 2007 CaseMaker Inc. All rights reserved
-------------------------------------------------------------------------
NOTE:
1. This sample upload client side file to server side, and insert content
   of file into CLOB, BLOB, NCLOB, FILE fields.
2. Use two methods insert file as follows:
   a, Encode file to byte stream and insert it into CLOB, BLOB, FILE 
      fileds via OleDbType.LongVarBinary OdbcParameter object.
   b, Encode file to string and insert it into NCLOB field via 
      OleDbType.LongVarWChar OdbcParameter object.
3. This sample mixed server scripts and HTML elements in single page file.
4. This sample used database DBSAMPLE5 and table sample.LargeType.
------------------------------------------------------------------------->

<%@ Page Language="C#" AutoEventWireup="True" %>
<%@ Import namespace=System.Data.OleDb %>

<html>
<head>
	<title></title>
	<script language="C#" runat="server">
	
		string connString = System.Configuration.ConfigurationSettings.AppSettings["OleDbConnectionString"];
		
		private void Page_Load(object sender,EventArgs e)
		{
			if(!IsPostBack)
			{
				FillCurrentData();
				
				lstField.Items.Add(new ListItem("c1_clob","c1_clob"));
				lstField.Items.Add(new ListItem("c2_blob","c2_blob"));
				lstField.Items.Add(new ListItem("c3_nclob","c3_nclob"));
				lstField.Items.Add(new ListItem("c4_file","c4_file"));
				
			}
		}
		
		private void FillCurrentData()
		{
			OleDbConnection myCN = new OleDbConnection(connString);
			string queryString = "select c0_id,bloblen(c1_clob),bloblen(c2_blob)," + 
								"bloblen(c3_nclob),filelen(c4_file) from sample.LargeType";
			OleDbCommand myCM = new OleDbCommand(queryString,myCN);
			OleDbDataReader myDR;
			
			try
			{
				myCN.Open();
				myDR = myCM.ExecuteReader();
				grdCurData.DataSource = myDR;
				grdCurData.DataBind();
				myDR.Close();
				myCN.Close();
			}
			catch(Exception ex)
			{
				lblMessage.Text += "<br>Read Current Data Error: " + ex.Message;
				if( myCN != null) myCN.Close();
			}		
		}	
			
		void btnSave_Click(object sender,EventArgs e)
		{
			if(file1.PostedFile == null)
			{
				lblMessage.Text += "<br>No file";
				return;
			}
			
			if(file1.PostedFile.ContentLength <=0)
			{
				lblMessage.Text += "<br>File is null";
				return;
			}
			
			string cmdString = "Insert into sample.LargeType(c0_id," + lstField.SelectedValue.Trim() + 
									" ) values(?,?);";
			OleDbConnection myCN = new OleDbConnection(connString);
			OleDbCommand myCM = new OleDbCommand(cmdString,myCN);
			
			lblInfo.Text = "Command String: " + myCM.CommandText;
			
			try
			{
				int fileLen = file1.PostedFile.ContentLength;
				byte[] buffer = new byte[fileLen];
				file1.PostedFile.InputStream.Read(buffer,0,fileLen);
				
				if(txtID.Text.Trim()=="")
				{
					myCM.Parameters.Add("@c0_id",OleDbType.Integer).Value = DBNull.Value;
				}
				else
				{
					myCM.Parameters.Add("@c0_id",OleDbType.Integer).Value = int.Parse(txtID.Text);
				}
				//myCM.Parameters.Add("@p1",OleDbType.LongVarBinary,fileLen).Value = buffer;
				myCM.Parameters.Add("@p1",OleDbType.LongVarBinary,2147483647).Value = buffer;
				
				myCN.Open();
				int inserted = myCM.ExecuteNonQuery();
				lblMessage.Text += "<br>" + inserted + " row inserted";
				myCN.Close();
				
				FillCurrentData();
				
			}catch(Exception ex){
				lblMessage.Text += "<br>Insert Error: " + ex.Message;
				if(myCN != null) myCN.Close();
			}
		}
		
	</script>
</head>
<body>
	<form method="post" runat="server" enctype="multipart/form-data">
		<h3>Insert file into CLOB,BLOB,NCLOB,FILE fileds <br>
		[OleDbCommand,OleDbParameter]</h3><hr>
		Database Name: DBSAMPLE5<br>
		Table Name: sample.LargeType<br>
		Current Data:<br>
		<asp:DataGrid id = "grdCurData" runat = "server" />
		<hr><p>
		Row ID:
		<asp:TextBox id="txtID" runat="server" width=30px EnableViewState="false"></asp:TextBox>
		&nbsp;
		Field:
		<asp:DropDownList id="lstField" runat="server" width="80px"></asp:DropDownList>
		<p>
		File:
		<input id="file1" type="file" runat="server" /><p>
		<asp:Button id="btnSave" runat="server" Text="Save" OnClick="btnSave_Click"></asp:Button><p>
		<asp:Label id="lblMessage" runat="server" EnableViewState=false/>
		<br>
		<asp:Label id="lblInfo" runat="server" EnableViewState=false/>
	</form>
</body>
</html>