<!-----------------------------------------------------------------------
	Copyright(c) 1997 - 2007 CaseMaker Inc. All rights reserved
-------------------------------------------------------------------------
NOTE:
1. This sample insert text(is from page) into CLOB, BLOB, NCLOB, FILE fields
2. Use following methods insert text into database:
	a. Use System.Text.Encoding.Default.GetBytes method to encode text to
	   byte array,then insert byte stream into CLOB, BLOB, FILE fields
	   via OdbcType.Image OdbcParameter object.
	b. Insert text into database via OdbcType.VarChar, OdbcType.NVarChar, 
	   OdbcType.Text,OdbcType.NText OdbcParameter object respectively.
	c. Use pure SQL Insert text into database without OdbcParameter object.
3. This sample mixed server scripts and HTML elements in single page file.
4. This sample used database DBSAMPLE5 and table sample.LargeType.
------------------------------------------------------------------------->

<%@ Page Language="C#" AutoEventWireup="True"  validateRequest=false %>
<%@ Import namespace=System.Data.Odbc %>

<html>
<head>
	<title></title>
	<script language="C#" runat="server">
	
		string connString = System.Configuration.ConfigurationSettings.AppSettings["OdbcConnectionString"];
		
		private void Page_Load(object sender,EventArgs e)
		{
			if(!IsPostBack)
			{
				FillCurrentData();
				
				lstField.Items.Add(new ListItem("c1_clob","c1_clob"));
				lstField.Items.Add(new ListItem("c2_blob","c2_blob"));
				lstField.Items.Add(new ListItem("c3_nclob","c3_nclob"));
				lstField.Items.Add(new ListItem("c4_file","c4_file"));
			}
		}
		
		private void FillCurrentData()
		{
			OdbcConnection myCN = new OdbcConnection(connString);
			string queryString = "select c0_id,bloblen(c1_clob),bloblen(c2_blob)," + 
								"bloblen(c3_nclob),filelen(c4_file) from sample.LargeType";
			OdbcCommand myCM = new OdbcCommand(queryString,myCN);
			OdbcDataReader myDR;
			
			try
			{
				myCN.Open();
				myDR = myCM.ExecuteReader();
				grdCurData.DataSource = myDR;
				grdCurData.DataBind();
				myDR.Close();
				myCN.Close();
			}
			catch(Exception ex)
			{
				lblMessage.Text += "<br>Read Current Data Error: " + ex.Message;
				if( myCN != null) myCN.Close();
			}	
		}
		
		void InsertBytes(System.Text.Encoding encoding)
		{
			byte[] buff = encoding.GetBytes(txtData.Text);
			
			string cmdString = "Insert into sample.LargeType(c0_id," + lstField.SelectedValue.Trim() +
									" ) values(?,?);";
			OdbcConnection myCN = new OdbcConnection(connString);
			OdbcCommand myCM = new OdbcCommand(cmdString,myCN);
			
			lblInfo.Text = "Command String: " + myCM.CommandText;
			
			try
			{
				if(txtID.Text.Trim()=="")
				{
					myCM.Parameters.Add("@c0_id",OdbcType.Int).Value =DBNull.Value;
				}
				else
				{
					myCM.Parameters.Add("@c0_id",OdbcType.Int).Value =Convert.ToInt32(txtID.Text);
				}
				//myCM.Parameters.Add("@para",OdbcType.Image,buff.Length).Value = buff;
				myCM.Parameters.Add("@para",OdbcType.Image,2147483647).Value = buff;
				
				myCN.Open();
				int inserted = myCM.ExecuteNonQuery();
				lblMessage.Text += "<br>" + inserted + " row inserted";
				myCN.Close();
				
				
			}catch(Exception ex){
				lblMessage.Text += "<br>Insert Error: " + ex.Message;
				if(myCN != null) myCN.Close();
			}
		
		}
		
		void btnSaveImage_Click(object sender,EventArgs e)
		{
			if(txtData.Text.Length <= 0)
			{
				lblMessage.Text += "<br> Text is null";
				return;
			}
			
			InsertBytes(System.Text.Encoding.Default);
			
			FillCurrentData();
		}
		
		
		void InsertString(OdbcType paramOdbcType)
		{
			string cmdString = "Insert into sample.LargeType(c0_id," + lstField.SelectedValue.Trim() +
									" ) values(?,?);";
			OdbcConnection myCN = new OdbcConnection(connString);
			OdbcCommand myCM = new OdbcCommand(cmdString,myCN);

			lblInfo.Text = "Command String: " + myCM.CommandText;
			
			try
			{
				if(txtID.Text.Trim()=="")
				{
					myCM.Parameters.Add("@c0_id",OdbcType.Int).Value =DBNull.Value;
				}
				else
				{
					myCM.Parameters.Add("@c0_id",OdbcType.Int).Value =Convert.ToInt32(txtID.Text);
				}
				myCM.Parameters.Add("@para",paramOdbcType,2*(txtData.Text.Length)).Value = txtData.Text;
				
				myCN.Open();
				int inserted = myCM.ExecuteNonQuery();
				lblMessage.Text += "<br>" + inserted + " row inserted";
				myCN.Close();
				
			}catch(Exception ex){
				lblMessage.Text += "<br>Insert Error: " + ex.Message;
				if(myCN != null) myCN.Close();
			}
		}
		
		void btnSaveVarChar_Click(object sender,EventArgs e)
		{
			if(txtData.Text.Length <= 0)
			{
				lblMessage.Text += "<br> Text is null";
				return;
			}
			
			InsertString(OdbcType.VarChar);
			
			FillCurrentData();
		}	
				
		void btnSaveNVarChar_Click(object sender,EventArgs e)
		{
			if(txtData.Text.Length <= 0)
			{
				lblMessage.Text += "<br> Text is null";
				return;
			}
			
			InsertString(OdbcType.NVarChar);
			
			FillCurrentData();
		}	
			
		void btnSaveText_Click(object sender,EventArgs e)
		{
			if(txtData.Text.Length <= 0)
			{
				lblMessage.Text += "<br> Text is null";
				return;
			}
			
			InsertString(OdbcType.Text);
			
			FillCurrentData();
		}
		
		void btnSaveNText_Click(object sender,EventArgs e)
		{
			if(txtData.Text.Length <= 0)
			{
				lblMessage.Text += "<br> Text is null";
				return;
			}
			
			InsertString(OdbcType.NText);
			
			FillCurrentData();
		}
		
		void btnSaveString_Click(object sender,EventArgs e)
		{
			if(txtData.Text.Length <= 0)
			{
				lblMessage.Text += "<br> Text is null";
				return;
			}
			
			string cmdString = "Insert into sample.LargeType(c0_id," + lstField.SelectedValue.Trim() +
									" ) values(";
			OdbcConnection myCN = new OdbcConnection(connString);
			OdbcCommand myCM = new OdbcCommand(cmdString,myCN);
			
			try
			{
				if(txtID.Text.Trim()=="")
				{
					myCM.CommandText += "null";
				}
				else
				{
					myCM.CommandText += Convert.ToInt32(txtID.Text);
				}
				myCM.CommandText += ",'" + txtData.Text + "')";
				lblInfo.Text = "Command String: " + myCM.CommandText;
				myCN.Open();
				int inserted = myCM.ExecuteNonQuery();
				lblMessage.Text += "<br>" + inserted + " row inserted";
				myCN.Close();
				
			}catch(Exception ex){
				lblMessage.Text += "<br>Insert Error: " + ex.Message;
				if(myCN != null) myCN.Close();
			}
			
			FillCurrentData();
		}	
			
	</script>
</head>
<body>
	<form id="from1" method="post" runat="server" >
		<h3>Insert text into CLOB,BLOB,NCLOB,FILE fileds<br>
		[OdbcCommand,OdbcParameter]</h3><hr>
		Database Name: DBSAMPLE5<br>
		Table Name: sample.LargeType<br>
		Current Data:<br>
		<asp:DataGrid id = "grdCurData" runat = "server" />
		<hr><p>
		Row ID:
		<asp:TextBox id="txtID" runat="server" width=30px EnableViewState="false"></asp:TextBox>
		&nbsp;
		Field:
		<asp:DropDownList id="lstField" runat="server" width="80px"></asp:DropDownList>
		<p>
		<asp:TextBox id="txtData" runat="server" width="100%" height="300px" TextMode="MultiLine"/><p>
		
		<asp:Button id="btnSaveImage" runat="server" 
			Text="Insert(OdbcType.Image)" OnClick="btnSaveImage_Click"
			Width="180px">
		</asp:Button>

		<asp:Button id="btnSaveVarChar" runat="server" Text="Insert (OdbcType.Varchar)" 
			OnClick="btnSaveVarChar_Click"
			Width="180px">
		</asp:Button>		

		<asp:Button id="btnSaveNVarChar" runat="server" Text="Insert (OdbcType.NVarchar)" 
			OnClick="btnSaveNVarChar_Click"
			Width="180px">
		</asp:Button>
		<br>
		
		<asp:Button id="btnSaveText" runat="server" Text="Insert (OdbcType.Text)" 
			OnClick="btnSaveText_Click"
			Width="180px">
		</asp:Button>

		<asp:Button id="btnSaveNText" runat="server" Text="Insert (OdbcType.NText)" 
			OnClick="btnSaveNText_Click"
			Width="180px">
		</asp:Button>

		<asp:Button id="btnSaveString" runat="server" Text="Insert(pure SQL)" 
			OnClick="btnSaveString_Click"
			Width="180px">
		</asp:Button>		
		<br>
		<asp:Label id="lblMessage" runat="server" EnableViewState=false/>
		<br>
		<asp:Label id="lblInfo" runat="server" EnableViewState="false"/>
	</form>
</body>
</html>