/**********************************************************************
 *  #001 03/23/01  clin   - MR6059 expand DBMaker decimal to 39
 *  #002 06/30/01  emma   - fix MR#6125. To enlarge LEN_FNAME from 80 to 256
 *  #003 06/29/05  phu    - MR#7574 support decimal type
 *  #004 09/11/06  phu    - MR#7882 support unicode type
 *  #005 11/24/06  lucky   MR7823 long -> int
 *  #006 08/01/07  phu     @7823 chg int len to SQLLEN len
 **********************************************************************/

#ifndef _ESQLTYPE_H
#define _ESQLTYPE_H

#define LEN_FNAME                 256           /* #002 */
#define MAX_FNAME_LEN             (LEN_FNAME-1)
/*#define MAX_DECIMAL_LEN (39+2+3)*//* #001 - not used, so take this out */
#define DB_ALLOCATE_MEMORY        -1
#define ESQL_STORE_FILE_CONTENT  -999
#define ESQL_STORE_FILE_NAME     -998

typedef struct fileobj_s {
	SQLLEN  type;
    char fname[LEN_FNAME];
} fileobj;

typedef struct varchar_s {
    SQLLEN  len;
    char arr[1];
} varchar;

typedef struct varcptr_s {
    SQLLEN  len;
    char *arr;
} varcptr;

typedef struct longvarchar_s {
    SQLLEN  bufsize;
    char *buf;
} longvarchar;

typedef varchar     varbinary;
typedef varcptr     varbptr;
typedef longvarchar longvarbinary;

typedef struct date_s
{
    short          year;
    unsigned short month;
    unsigned short day;
} eq_date;

typedef struct time_s
{
    unsigned short hour;
    unsigned short minute;
    unsigned short second;
} eq_time;

typedef struct timestamp_s
{
    short          year;
    unsigned short month;
    unsigned short day;
    unsigned short hour;
    unsigned short minute;
    unsigned short second;
    unsigned int   fraction;
} eq_timestamp;


/* Add eq_decimal type #003 */
#define NDecDgt    39              /* internal max # of digit          */
#define NBDec   ((NDecDgt+1)/2)    /* ( NDecDgt plus sign digit ) / 2  */

typedef struct eq_decimal_s
{
    unsigned char pre;
    unsigned char sca;
    char          dgt[NBDec];
    unsigned char exp;
    unsigned char juk;             /* for alignment purpose */
} eq_decimal;

typedef char    nchar;             /* for unicode #004 */
typedef varchar nvarchar;          /* for unicode #004 */
typedef longvarchar nclob;         /* for unicode #004 */

#endif /* _ESQLTYPE_H */
