#ifndef _ESQLPROT_H
#define _ESQLPROT_H

/****************************************************************************
* #001 03/06/17 moon : @10499 remove the compile warnings
****************************************************************************/

#include <stdarg.h>

/****************************************************************************
 * function prototype
 ****************************************************************************/
int _execConnect(char **pDBEnv, sqlca_t *pSQLCA, char *dbName, int dbNameLen, char *owner, int ownerLen, char *passwd, int passwdLen, char *file, int line);

int _execDisConnect(char **pDBEnv, sqlca_t *pSQLCA, char *dbName, short fgSync, char *file, int line);

int _execDirect(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *sqlstr, int sqlstrLen, SWORD nCol, short fgSelError, char *file, int line);

int _execPrepare(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *stmtName, char *sqlstr, int sqlstrLen, int fgDynamic, char *file, int line);

void _execStop(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *file, int line);

int _execSetCommit(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, short fgSet, char *file, int line);

int _execCommit(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, short fgSync, char *file, int line);

int _execRollback(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, short fgSync, char *file, int line);

int _execParamData(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *stmtName, int fgPut, char *file, int line);

int _execPutData(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *stmtName, void *buffer, SDWORD ind, char *file, int line);

int _execGetData(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *stmtName, int ctype, int nCol, void *buffer, SQLLEN *ind, char *file, int line);

int _execBindCol(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *objName, int fgCursor, int nCol, SWORD sqlctype, void *pbuf, SQLLEN buflen, SQLLEN *pindValue, short fgChkSt, short nfetchid, short nIndfetchid, char *file, int line);

int _execBindParam(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *objName, int fgCursor, int inPar, SWORD isqlctype, SWORD isqltype, SQLULEN prec, SWORD scale, void *pBuf, SQLLEN ibuflen, SQLLEN *pindValue, short fgChkSt, char *file, int line);

int _execBindDaParam(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *objName, void *descriptor, short fgStmt, char *file, int line);

int _execDeclareCursor(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *curName, char *stmtName, int fgCursor, char *sqlstr, int fgScroll, char *file, int line);

int _execOpenCursor(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *curName, char *file, int line);

int _execFetch(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *curName, int fgCursor, int fgFetchType, int RowPos, int nFetchRows, char *file, int line);

int _execCloseCursor(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *curName, char *file, int line);

int _execExecute(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *stmtName, short fgSelError, char *file, int line);

int _execUnBindParam(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *objName, int fgCursor, int nPar, short fgChkSt, char *file, int line);

int _execDescribeParam(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *stmtName, void *descriptor, char *file, int line);

int _execDescribeCol(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *stmtName, void *descriptor, char *file, int line);

int _execBindDaCol(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *curName, void *descriptor, char *file, int line);

int _execCancel(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *stmtName, char *file, int line);

int _execClearHV(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *objName, int fgCursor, char *file, int line);

int _SetSQLDA(char *desc, short nHv, short fieldOpt, SQLLEN fieldVal, char *pDBEnv, sqlca_t *pSQLCA, char *file, int line);

int _GetSQLDA(char *desc, short nHv, short fieldOpt, void *fieldVal, char *pDBEnv, sqlca_t *pSQLCA, char *file, int line);

int _allocate_descriptor_storage(int maxNum, char **pDesc, char *pDBEnv, sqlca_t *pSQLCA, char *file, int line);

int _free_descriptor_storage(char *desc, char *pDBEnv, sqlca_t *pSQLCA, char *file, int line);

int _setConnect(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *owner, char *passwd, HENV henv, HDBC hdbc, char *file, int line);

int _unsetConnect(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *file, int line);

int _execTraceOn(char *pDBEnv, sqlca_t *pSQLCA, char *logfn, char *file, int line);

int _execTraceOff(char *pDBEnv, sqlca_t *pSQLCA, char *file, int line);

int _execTrace(char *pDBEnv, sqlca_t *pSQLCA, char *file, int line, char *fmt, ...);

int _execSetCbMode(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, short cbMode, char *file, int line);

int _execSetDumpDebug(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, short fgSet, char *file, int line);

int _execSetConnectOption(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, unsigned short conOpt, unsigned int fgSet, char *file, int line);

int _execDirectW(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *sqlstr, int sqlstrLen, SWORD nCol, short fgSelError, char *file, int line);

int _execPrepareW(char *pDBEnv, sqlca_t *pSQLCA, char *dbName, char *stmtName, char *sqlstr, int sqlstrLen, int fgDynamic, char *file, int line);

/* avoid the compile warnings,the SP_PROTO macro has two definitions  #001*/
/* the SP_PROTO(spname) has the return list                               */
/* the SP_PROTO_NO_RS(spname) has not the return list                     */

#if !defined(WIN32) && !defined(_WIN64)
#define SP_PROTO(spname) \
    int spname(HENV henv, HDBC hdbc, int dmSP_CASE_VAR, int argc, VVAL args[], int retc, VVAL rets[]);
#define SP_PROTO_NO_RS(spname) \
    int spname(HENV henv, HDBC hdbc, int dmSP_CASE_VAR, int argc, VVAL args[]);
#else
#define SP_PROTO(spname)
#define SP_PROTO_NO_RS(spname)
#endif

#endif /* define _ESQLPROT_H */
