#ifndef	_EQSPINCL_H_
#define _EQSPINCL_H_
#include <string.h>  /* #011 */
/****************************************************************************
 * #001 09/05/97 jerry: modify because basetype.h removed from esqlincl.h
 * #002 09/24/97 jerry: add indicator because ESQL rule changed (char type)
 * #003 05/05/98 jerry: stproc.h add two fields for lrc
 * #004 01/12/99 phu: add dbName in SPHANDLE for pass dbName when exec SP
 * #005 01/18/99 jerry: MR#5000 modify for system stored procedure
 * #006 05/10/01 cctsai: @5384 chg i16 to i15 for SQL_BINARY (-2)
 * #007 03/29/01 clin: MR6059 expand DBMaker decimal to 38 digits precision
 * #008 06/30/05 phu : @7574 move eq_decimal to esqltype.h
 * #009 10/20/06 phu : @7809 chg len from short to int and reorder field
 * #010 08/27/09 leon: MR8415, support bigint.
 * #011 11/30/16 moon: @10499 remove the compile warnings
 ****************************************************************************/
 
#if 0 /* move to esqltype.h #008 */
#define DecNdgt    39              /* #007 */
#define EXTDecNdgt 38              /* #007 */
#define DecNbSize ((DecNdgt+1)/2)  /* #007 - use internal, since it is for */
                                   /*      allocating buffer               */

typedef struct
{
    unsigned char pre;
    unsigned char sca;
    unsigned char dgt[DecNbSize]; /* #007 add comment: use internal for buffer size*/
    unsigned char exp;  /* reserve; now, can regared as junk for alignment */
	unsigned char juk;  /* #007 - junk for alignment purpose */
} eq_decimal;
#endif

#define	STA_CLOSE	0
#define	STA_OPEN	1
#define	STA_FETCH	2

#ifndef _STPROC_H  /* #005 */
/***************************************************************************/
/******* IMPORTANT!!!!!, change VVAL, also need to change stproc.h *********/
/***************************************************************************/
typedef struct {
   short          type;         /* #001 i15 data type   #006 */
   short          lrc;          /* #003 delay report warninig rc for cg */
   short          ptype;		/* #001 i31 parameter type */
   short          exptype;      /* #002 (stproc.h changed) */
   SQLLEN         len;          /* #001 int data length            #009 */
   SQLLEN         ind;          /* #002 indicator for CHAR (must be SQLLEN)*/
   union {
      int     ival;             /* #001 i31 long integer data  */
      short   sival;            /* #001 i15 short integer data */
#if (defined(WIN32) || defined(_WIN64))
	  __int64     i63val;       /* bigint data   #010 */
#else 
	  long long   i63val;       /* bigint data   #010 */
#endif
      double  fval;             /* double data        */
      float   sfval;            /* float data         */
      eq_decimal dval;          /* decimal data       */
      char    *xval;            /* pointer to data    */
      eq_timestamp tsval;       /* timestamp data     */
      eq_time tval;			    /* time data          */
      eq_date dtval;		    /* date data          */
   } u;
} VVAL;

/***************************************************************************
 * structure for saving sqlca and dbenvca for SP
 ***************************************************************************/
#include "sqlca.h"
 
/***************************************************************************/
/******* IMPORTANT!!!!!, change VVAL, also need to change stproc.h *********/
/***************************************************************************/
typedef  struct {
    sqlca_t    sqlcap;
    char       *dbenvcap;
    char       *dbName;    /* #004 */
} SPHANDLE_t;
 
typedef SPHANDLE_t  (*SPHANDLE_p);
#define SPHANDLE_t_size sizeof(SPHANDLE_t)

#endif /* _STPROC_H #005 */

/* #001 basetype.h is removed from esqlincl.h, maybe should not generate */
/* db_copy in .c file after PP a SP source */
#define db_copy(to, from, nbytes) \
          memcpy((char *)(to), (char *)(from), (unsigned int)(nbytes))
          
#endif	/* _EQSPINCL_H */
