/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.GridControl;
import com.borland.jbcl.control.ISearchControl;
import com.borland.jbcl.control.Res;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;

class LookupDialog
extends Dialog
implements MouseListener,
KeyListener,
ActionListener,
Serializable {
    GridLayout gridLayout = new GridLayout();
    BorderLayout borderLayout = new BorderLayout();
    ISearchControl iSearchControl;
    FlowLayout flowLayout = new FlowLayout();
    Panel buttonGridPanel = new Panel();
    Panel buttonFlowPanel = new Panel();
    Button okButton = new Button();
    Button cancelButton = new Button();
    GridControl lookupGrid;
    boolean useValue = false;
    boolean allowSearch = false;
    boolean alwaysCenter = false;
    boolean displayOKCancel = false;
    Dimension screenSize = null;
    Frame frame;

    public LookupDialog(Frame frame, GridControl lookupGrid) {
        this(frame, lookupGrid, true);
    }

    public LookupDialog(Frame frame, GridControl lookupGrid, boolean allowSearch) {
        this(frame, lookupGrid, true, false);
    }

    public LookupDialog(Frame frame, GridControl lookupGrid, boolean allowSearch, boolean alwaysCenter) {
        this(frame, lookupGrid, true, false, false);
    }

    public LookupDialog(Frame frame, GridControl lookupGrid, boolean allowSearch, boolean alwaysCenter, boolean displayOKCancel) {
        super(frame, "", true);
        try {
            this.frame = frame;
            this.lookupGrid = lookupGrid;
            this.allowSearch = allowSearch;
            this.alwaysCenter = alwaysCenter;
            this.displayOKCancel = displayOKCancel;
            this.iSearchControl = new ISearchControl(lookupGrid);
            this.jbInit();
            this.enableEvents(64L);
            this.pack();
            this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.centerDialog();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void jbInit() throws Exception {
        this.setLayout(this.borderLayout);
        this.okButton.setLabel(Res._OK);
        this.okButton.addActionListener(this);
        this.cancelButton.setLabel(Res._Cancel);
        this.cancelButton.addActionListener(this);
        this.gridLayout.setHgap(5);
        this.buttonGridPanel.setLayout(this.gridLayout);
        this.buttonGridPanel.add((Component)this.okButton, null);
        this.buttonGridPanel.add((Component)this.cancelButton, null);
        this.buttonFlowPanel.setLayout(this.flowLayout);
        this.buttonFlowPanel.add(this.buttonGridPanel);
        this.iSearchControl.setDataSet(this.lookupGrid.getDataSet());
        this.iSearchControl.addKeyListener(this);
        this.lookupGrid.addMouseListener(this);
        this.lookupGrid.addKeyListener(this);
        this.add((Component)this.iSearchControl, "North");
        this.add((Component)this.buttonFlowPanel, "South");
        this.add((Component)this.lookupGrid, "Center");
    }

    public void actionPerformed(ActionEvent e2) {
        Object pushedButton = e2.getSource();
        if (pushedButton == this.okButton) {
            this.useValue = true;
        } else if (pushedButton == this.cancelButton) {
            this.useValue = false;
        }
        this.dispose();
    }

    public void show() {
        if (this.alwaysCenter) {
            this.centerDialog();
        }
        this.iSearchControl.setVisible(this.allowSearch);
        this.buttonFlowPanel.setVisible(this.displayOKCancel);
        super.show();
    }

    private void centerDialog() {
        Dimension frameSize = this.getPreferredSize();
        if (frameSize.height >= this.screenSize.height) {
            frameSize.height = this.screenSize.height / 2;
        }
        if (frameSize.width >= this.screenSize.width) {
            frameSize.width = this.screenSize.width / 2;
        }
        this.setSize(frameSize.width, frameSize.height);
        this.setLocation((this.screenSize.width - frameSize.width) / 2, (this.screenSize.height - frameSize.height) / 2);
    }

    protected void processWindowEvent(WindowEvent e2) {
        if (e2.getID() == 201) {
            this.useValue = false;
            this.setVisible(false);
            this.frame.toFront();
            this.dispose();
        }
        super.processWindowEvent(e2);
    }

    public void mouseClicked(MouseEvent e2) {
        if (e2.getClickCount() >= 2) {
            this.useValue = true;
            this.setVisible(false);
            this.frame.toFront();
            this.dispose();
        }
    }

    public void mousePressed(MouseEvent e2) {
    }

    public void mouseReleased(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void keyPressed(KeyEvent e2) {
        if (e2.getKeyCode() == 10 || e2.getKeyCode() == 27) {
            this.useValue = false;
            if (e2.getKeyCode() == 10) {
                this.useValue = true;
            }
            this.setVisible(false);
            this.frame.toFront();
            this.dispose();
        }
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void keyReleased(KeyEvent e2) {
    }

    public boolean useValue() {
        return this.useValue;
    }

    public void setAllowSearch(boolean allowSearch) {
        this.allowSearch = allowSearch;
        this.iSearchControl.setVisible(allowSearch);
    }

    public boolean isAllowSearch() {
        return this.allowSearch;
    }

    public void setAlwaysCenter(boolean alwaysCenter) {
        this.alwaysCenter = alwaysCenter;
    }

    public boolean isAlwaysCenter() {
        return this.alwaysCenter;
    }

    public void setDisplayOKCancel(boolean displayOKCancel) {
        this.displayOKCancel = displayOKCancel;
        this.buttonFlowPanel.setVisible(displayOKCancel);
    }

    public boolean isDisplayOKCancel() {
        return this.displayOKCancel;
    }
}

