/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.textField.DbaTextField;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class CharField
extends JTextField
implements DbaTextField {
    private Toolkit toolkit;
    private int max_length = 0;
    private boolean length_limited = false;
    private CharField field = this;

    public CharField() {
        this.toolkit = Toolkit.getDefaultToolkit();
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    public CharField(String value) {
        this();
        this.setValue(value);
    }

    public CharField(String value, int max_length) {
        this(value);
        this.max_length = max_length;
        this.length_limited = true;
    }

    public CharField(int max_length) {
        this();
        this.max_length = max_length;
        this.length_limited = true;
    }

    public CharField(int max_length, boolean limited) {
        this();
        this.max_length = max_length;
        this.length_limited = limited;
    }

    @Override
    public Object getValue() {
        return this.getText();
    }

    public void setValue(String value) {
        this.setText(value);
    }

    @Override
    protected Document createDefaultModel() {
        return new CharDocument();
    }

    protected class CharDocument
    extends PlainDocument {
        protected CharDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (CharField.this.length_limited) {
                byte[] strByteArray;
                String temp = CharField.this.field.getText();
                if (temp == null || str == null) {
                    return;
                }
                byte[] tmpByteArray = temp.getBytes();
                if (tmpByteArray.length + (strByteArray = str.getBytes()).length > CharField.this.max_length) {
                    CharField.this.toolkit.beep();
                    return;
                }
            }
            super.insertString(offs, str, a);
        }
    }
}

