/*
 * Decompiled with CFR 0.152.
 */
package dbaut;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class TimeDocument
extends PlainDocument {
    public static final String emptyTime = "  :  :  ";
    public static final String zeroTime = "00:00:00";
    public static String initString = "  :  :  ";
    private static int sep1 = 2;
    private static int sep2 = 5;
    private JTextComponent textComponent;
    private int newOffset;

    public TimeDocument(JTextComponent tc) {
        this.textComponent = tc;
    }

    private String addZero(String s, int size) {
        int s_size = s.length();
        if (s_size >= size) {
            return s;
        }
        StringBuffer sb = new StringBuffer(size);
        int count = size - s_size;
        for (int i = 0; i < count; ++i) {
            sb.append('0');
        }
        sb.append(s);
        return sb.toString();
    }

    private void errorOut(String s) {
        System.out.println("**This beep is from TimeDocrment --> " + s);
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
        int length = s.length();
        if (s.equals(initString)) {
            int len = this.textComponent.getText().length();
            if (len > 0) {
                super.remove(offset, len);
            }
            super.insertString(offset, s, attributeSet);
        } else {
            String t = this.textComponent.getText();
            String new_s = t.substring(0, offset) + s + (t.length() > offset + length ? t.substring(offset + length) : "");
            if (offset + length > 8) {
                this.errorOut(new_s);
                return;
            }
            if (new_s.equals(emptyTime)) {
                super.remove(0, 8);
                super.insertString(0, new_s, attributeSet);
                return;
            }
            char[] ca = new_s.toCharArray();
            if (ca[sep1] != ':' || ca[sep2] != ':') {
                this.errorOut(new_s);
                return;
            }
            for (int i = 0; i < 8; ++i) {
                if (i == sep1 || i == sep2 || Character.isDigit(ca[i]) || ca[i] == ' ') continue;
                this.errorOut(new_s);
                return;
            }
            String hour = new_s.substring(0, 2);
            int ihour = 0;
            if (hour.trim().length() > 0 && (ihour = Integer.parseInt(hour.trim())) > 24) {
                this.errorOut(new_s);
                return;
            }
            String min = new_s.substring(3, 5);
            int imin = 0;
            if (min.trim().length() > 0 && ((imin = Integer.parseInt(min.trim())) > 0 && ihour == 24 || imin > 59)) {
                this.errorOut(new_s);
                return;
            }
            String sec = new_s.substring(6, 8);
            int isec = 0;
            if (sec.trim().length() > 0 && ((isec = Integer.parseInt(sec.trim())) > 0 && ihour == 24 || isec > 59)) {
                this.errorOut(new_s);
                return;
            }
            if (offset + length >= 3) {
                hour = this.addZero(Integer.toString(ihour), 2);
            }
            if (offset + length >= 6) {
                min = this.addZero(Integer.toString(imin), 2);
            }
            if (offset + length >= 8) {
                sec = this.addZero(Integer.toString(isec), 2);
            }
            if (offset + length >= 3) {
                super.remove(0, 8);
                new_s = hour + ':' + min + ':' + sec;
                super.insertString(0, new_s, attributeSet);
            } else {
                super.remove(offset, length);
                super.insertString(offset, s, attributeSet);
            }
            if (this.atSeparator(offset + length)) {
                this.textComponent.setCaretPosition(offset + length + 1);
            } else {
                this.textComponent.setCaretPosition(offset + length);
            }
        }
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        if (length == 0) {
            return;
        }
        if (this.atSeparator(offset)) {
            super.remove(offset - 1, 1);
            super.insertString(offset - 1, " ", null);
            this.textComponent.setCaretPosition(offset - 1);
        } else {
            int i = this.textComponent.getCaretPosition();
            super.remove(offset, length);
            super.insertString(offset, emptyTime.substring(offset, offset + length), null);
            if (offset < i) {
                if (this.atSeparator(offset - 1)) {
                    this.textComponent.setCaretPosition(offset - 1);
                } else {
                    this.textComponent.setCaretPosition(offset);
                }
            } else if (this.atSeparator(offset + 1)) {
                this.textComponent.setCaretPosition(offset + 2);
            } else if (this.textComponent.getText().equals(emptyTime)) {
                this.textComponent.setCaretPosition(0);
            } else {
                this.textComponent.setCaretPosition(offset + 1);
            }
        }
    }

    private boolean atSeparator(int offset) {
        return offset == sep1 || offset == sep2;
    }
}

