/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.ut.system;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class IniFile {
    protected Vector lines;
    protected Vector subjects;
    protected Vector variables;
    protected Vector values;
    protected String fileName;
    protected boolean saveOnChange = false;

    public IniFile(String name) {
        this(name, false);
    }

    public IniFile(String name, boolean save) {
        this.saveOnChange = save;
        this.fileName = name;
        if (!new File(name).exists() && !this.createFile()) {
            return;
        }
        this.loadFile();
        this.parseLines();
    }

    public Vector getLines(String subject) {
        Vector v = (Vector)this.lines.clone();
        int start = this.findSubjectLine(subject);
        int end = this.endOfSubject(start) - 1;
        int i = end + 1;
        while (i < v.size()) {
            v.removeElementAt(i);
        }
        for (i = 0; i < start; ++i) {
            v.removeElementAt(0);
        }
        return v;
    }

    public void addLines(Vector v) {
        this.lines.addAll(v);
        if (this.saveOnChange) {
            this.saveFile();
        }
    }

    public void loadFile() {
        this.lines = new Vector();
        this.subjects = new Vector();
        this.variables = new Vector();
        this.values = new Vector();
        try {
            DataInputStream ini = new DataInputStream(new BufferedInputStream(new FileInputStream(this.fileName)));
            byte[] b = new byte[ini.available()];
            ini.read(b);
            String all = new String(b);
            while (true) {
                int index;
                if ((index = all.indexOf(10)) < 0) {
                    if (all.length() <= 0) break;
                    if (this.isaSubject(all = all.trim())) {
                        this.lines.addElement(all.toUpperCase().trim());
                        break;
                    }
                    this.lines.addElement(all.trim());
                    break;
                }
                if (index < 2) {
                    all = all.substring(index + 1);
                    continue;
                }
                String line = all.substring(0, index);
                all = all.substring(index + 1);
                if (line.length() == 0) break;
                if (this.isaSubject(line = line.trim())) {
                    this.lines.addElement(line.toUpperCase().trim());
                    continue;
                }
                this.lines.addElement(line.trim());
            }
            ini.close();
        }
        catch (IOException e) {
            System.out.println("IniFile load failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected boolean createFile() {
        try {
            DataOutputStream newFile = new DataOutputStream(new FileOutputStream(this.fileName));
            newFile.writeBytes(";INI File: " + this.fileName + System.getProperty("line.separator"));
            newFile.close();
            return true;
        }
        catch (IOException e) {
            System.out.println("IniFile create failed: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public void parseLines() {
        String currentLine = null;
        String currentSubject = null;
        boolean skip = false;
        for (int i = 0; i < this.lines.size(); ++i) {
            currentLine = (String)this.lines.elementAt(i);
            if (this.isaSubject(currentLine)) {
                currentSubject = currentLine.substring(1, currentLine.length() - 1);
                if (this.subjects.contains(currentSubject)) {
                    skip = true;
                    continue;
                }
                skip = false;
                this.subjects.addElement(currentSubject);
                this.variables.addElement(new Vector());
                this.values.addElement(new Vector());
                continue;
            }
            if (!this.isanAssignment(currentLine) || skip) continue;
            String assignment = currentLine;
            this.addAssignment(currentSubject, assignment);
        }
    }

    public boolean addAssignment(String subject, String assignment) {
        int index = assignment.indexOf("=");
        String variable = assignment.substring(0, index).trim();
        String value = new String(assignment.substring(index + 1, assignment.length()).trim());
        int pos = value.indexOf(32);
        while (pos == 0) {
            value = new String(value.substring(pos + 1, value.length()).trim());
            pos = value.indexOf(32);
        }
        if (value.length() == 0 || variable.length() == 0) {
            return false;
        }
        return this.addValue(subject, variable.trim(), value, false);
    }

    public boolean setValue(String subject, String variable, String value) {
        boolean result = this.addValue(subject, variable, value, true);
        if (this.saveOnChange) {
            this.saveFile();
        }
        return result;
    }

    protected boolean addValue(String subject, String variable, String value, boolean addToLines) {
        if (subject == null || subject.length() == 0) {
            return false;
        }
        if (variable == null || variable.length() == 0) {
            return false;
        }
        if (!this.subjects.contains(subject)) {
            this.subjects.addElement(subject);
            this.variables.addElement(new Vector());
            this.values.addElement(new Vector());
        }
        int subjectIndex = this.subjects.indexOf(subject);
        Vector subjectVariables = (Vector)this.variables.elementAt(subjectIndex);
        Vector subjectValues = (Vector)this.values.elementAt(subjectIndex);
        if (!subjectVariables.contains(variable)) {
            subjectVariables.addElement(variable);
            subjectValues.addElement(value);
            int variableIndex = subjectVariables.indexOf(variable);
            subjectValues.setElementAt(value, variableIndex);
        }
        if (addToLines) {
            this.setLine(subject, variable, value);
        }
        return true;
    }

    protected boolean isaSubject(String line) {
        return line.startsWith("[") && line.endsWith("]");
    }

    protected void setLine(String subject, String variable, String value) {
        int endOfSubject;
        int lineNumber;
        int subjectLine = this.findSubjectLine(subject);
        if (subjectLine == -1) {
            this.addSubjectLine(subject);
            subjectLine = this.lines.size() - 1;
        }
        if ((lineNumber = this.findAssignmentBetween(variable, subjectLine, endOfSubject = this.endOfSubject(subjectLine))) == -1) {
            this.lines.insertElementAt(variable + "=" + value, endOfSubject);
        } else {
            this.lines.setElementAt(variable + "=" + value, lineNumber);
        }
    }

    public int findAssignmentLine(String subject, String variable) {
        int start = this.findSubjectLine(subject);
        int end = this.endOfSubject(start);
        return this.findAssignmentBetween(variable, start, end);
    }

    protected int findAssignmentBetween(String variable, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (!((String)this.lines.elementAt(i)).startsWith(variable + "=")) continue;
            return i;
        }
        return -1;
    }

    public void addSubjectLine(String subject) {
        this.lines.addElement("[" + subject + "]");
    }

    public int findSubjectLine(String subject) {
        String formattedSubject = "[" + subject + "]";
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = (String)this.lines.elementAt(i);
            if (!formattedSubject.equalsIgnoreCase(line)) continue;
            return i;
        }
        return -1;
    }

    protected int endOfSubject(int start) {
        int endIndex = start + 1;
        if (start >= this.lines.size()) {
            return this.lines.size();
        }
        for (int i = start + 1; i < this.lines.size(); ++i) {
            if (this.isanAssignment((String)this.lines.elementAt(i))) {
                endIndex = i + 1;
            }
            if (!this.isaSubject((String)this.lines.elementAt(i))) continue;
            return endIndex;
        }
        return endIndex;
    }

    protected boolean isanAssignment(String line) {
        return line.indexOf("=") != -1 && !line.startsWith(";") && !line.startsWith("/");
    }

    public Vector getLines() {
        return (Vector)this.lines.clone();
    }

    public String[] getVariables(String subject) {
        int index = 0;
        for (index = 0; index < this.subjects.size(); ++index) {
            String s = (String)this.subjects.elementAt(index);
            if (!s.equalsIgnoreCase(subject)) continue;
            Vector vars = (Vector)this.variables.elementAt(index);
            Object[] v = new String[vars.size()];
            vars.copyInto(v);
            return v;
        }
        String[] v = new String[]{};
        return v;
    }

    public String[] getValues(String subject) {
        int index = 0;
        for (index = 0; index < this.subjects.size(); ++index) {
            String s = (String)this.subjects.elementAt(index);
            if (!s.equalsIgnoreCase(subject)) continue;
            Vector vars = (Vector)this.values.elementAt(index);
            Object[] v = new String[vars.size()];
            vars.copyInto(v);
            return v;
        }
        String[] v = new String[]{};
        return v;
    }

    public String[] getSubjects() {
        Object[] s = new String[this.subjects.size()];
        this.subjects.copyInto(s);
        return s;
    }

    public String getValue(String subject, String variable) {
        int subjectIndex = 0;
        for (subjectIndex = 0; subjectIndex < this.subjects.size() && !subject.equalsIgnoreCase((String)this.subjects.elementAt(subjectIndex)); ++subjectIndex) {
        }
        if (subjectIndex == this.subjects.size()) {
            return "";
        }
        Vector valVector = (Vector)this.values.elementAt(subjectIndex);
        Vector varVector = (Vector)this.variables.elementAt(subjectIndex);
        int valueIndex = varVector.indexOf(variable);
        if (valueIndex != -1) {
            return (String)valVector.elementAt(valueIndex);
        }
        return "";
    }

    public void deleteValue(String subject, String variable) {
        int subjectIndex = this.subjects.indexOf(subject);
        if (subjectIndex == -1) {
            return;
        }
        Vector valVector = (Vector)this.values.elementAt(subjectIndex);
        Vector varVector = (Vector)this.variables.elementAt(subjectIndex);
        int valueIndex = varVector.indexOf(variable);
        if (valueIndex != -1) {
            valVector.removeElementAt(valueIndex);
            varVector.removeElementAt(valueIndex);
            int assignmentLine = this.findAssignmentLine(subject, variable);
            if (assignmentLine != -1) {
                this.lines.removeElementAt(assignmentLine);
            }
            if (varVector.size() == 0) {
                this.deleteSubject(subject);
            }
            if (this.saveOnChange) {
                this.saveFile();
            }
        }
    }

    public int renameSubject(String oldname, String newname) {
        int subjectIndex = this.subjects.indexOf(oldname);
        if (subjectIndex == -1) {
            return -1;
        }
        this.subjects.setElementAt(newname, subjectIndex);
        int start = this.findSubjectLine(oldname);
        this.lines.setElementAt("[" + newname + "]", start);
        if (this.saveOnChange) {
            this.saveFile();
        }
        return 0;
    }

    public void deleteSubject(String subject) {
        int subjectIndex = this.subjects.indexOf(subject);
        if (subjectIndex == -1) {
            return;
        }
        this.values.removeElementAt(subjectIndex);
        this.variables.removeElementAt(subjectIndex);
        this.subjects.removeElementAt(subjectIndex);
        int start = this.findSubjectLine(subject);
        int end = this.endOfSubject(start);
        for (int i = start; i < end; ++i) {
            this.lines.removeElementAt(start);
        }
        if (this.saveOnChange) {
            this.saveFile();
        }
    }

    public void saveFile() {
        try {
            DataOutputStream outFile = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.fileName)));
            for (int i = 0; i < this.lines.size(); ++i) {
                outFile.writeBytes((String)this.lines.elementAt(i) + System.getProperty("line.separator"));
            }
            outFile.close();
        }
        catch (IOException e) {
            System.out.println("IniFile save failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void saveAsFile(String asFileName) {
        try {
            DataOutputStream outFile = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(asFileName)));
            for (int i = 0; i < this.lines.size(); ++i) {
                outFile.writeBytes((String)this.lines.elementAt(i) + System.getProperty("line.separator"));
            }
            outFile.close();
        }
        catch (IOException e) {
            System.out.println("IniFile save failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void finalize() {
    }
}

