/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.remote;

import com.sun.media.jai.rmi.ImageServer;
import com.sun.media.jai.rmi.JAIRMIUtil;
import com.sun.media.jai.rmi.RMIServerProxy;
import com.sun.media.jai.util.ImageUtil;
import java.awt.RenderingHints;
import java.awt.image.renderable.ParameterBlock;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Naming;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationNode;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.remote.JaiI18N;
import javax.media.jai.remote.NegotiableCapabilitySet;
import javax.media.jai.remote.RemoteDescriptorImpl;
import javax.media.jai.remote.RemoteImagingException;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;
import javax.media.jai.util.CaselessStringKey;

public class JAIRMIDescriptor
extends RemoteDescriptorImpl {
    public static final String IMAGE_SERVER_BIND_NAME = "JAIRMIRemoteServer1.1";
    private MessageFormat formatter = new MessageFormat("");

    public JAIRMIDescriptor() throws MalformedURLException {
        super("jairmi", new URL("http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/remote/JAIRMIDescriptor.html"));
        this.formatter.setLocale(Locale.getDefault());
    }

    public OperationDescriptor[] getServerSupportedOperationList(String string) throws RemoteImagingException {
        List list = null;
        try {
            list = this.getImageServer(string).getOperationDescriptors();
        }
        catch (Exception exception) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(exception));
        }
        OperationDescriptor[] operationDescriptorArray = new OperationDescriptor[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            operationDescriptorArray[n++] = (OperationDescriptor)iterator.next();
        }
        return operationDescriptorArray;
    }

    private ImageServer getImageServer(String string) {
        if (string == null) {
            try {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        String string2 = new String("rmi://" + string + "/" + IMAGE_SERVER_BIND_NAME);
        ImageServer imageServer = null;
        try {
            imageServer = (ImageServer)Naming.lookup(string2);
        }
        catch (Exception exception) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(exception));
        }
        return imageServer;
    }

    public NegotiableCapabilitySet getServerCapabilities(String string) throws RemoteImagingException {
        NegotiableCapabilitySet negotiableCapabilitySet = null;
        try {
            negotiableCapabilitySet = this.getImageServer(string).getServerCapabilities();
        }
        catch (Exception exception) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(exception));
        }
        return negotiableCapabilitySet;
    }

    public Object getInvalidRegion(String string, String string2, ParameterBlock parameterBlock, RenderingHints renderingHints, String string3, ParameterBlock parameterBlock2, RenderingHints renderingHints2, OperationNode operationNode) throws RemoteImagingException {
        Serializable serializable;
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAIRMIDescriptor11"));
        }
        String string4 = operationNode.getOperationName();
        OperationDescriptor[] operationDescriptorArray = this.getServerSupportedOperationList(string2);
        OperationDescriptor operationDescriptor = this.getOperationDescriptor(operationDescriptorArray, string4);
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAIRMIDescriptor1"));
        }
        int n = operationDescriptor.getNumSources();
        ParameterListDescriptor parameterListDescriptor = null;
        parameterListDescriptor = string.equalsIgnoreCase("remoteRendered") ? operationDescriptor.getParameterListDescriptor("rendered") : (string.equalsIgnoreCase("remoteRenderable") ? operationDescriptor.getParameterListDescriptor("renderable") : operationDescriptor.getParameterListDescriptor(string));
        int n2 = parameterListDescriptor.getNumParameters();
        if (string2 != string3) {
            Hashtable hashtable;
            Hashtable hashtable2;
            String[] stringArray;
            OperationDescriptor[] operationDescriptorArray2 = this.getServerSupportedOperationList(string3);
            OperationDescriptor operationDescriptor2 = this.getOperationDescriptor(operationDescriptorArray2, string4);
            if (operationDescriptor2 == null) {
                throw new IllegalArgumentException(JaiI18N.getString("JAIRMIDescriptor2"));
            }
            if (n != operationDescriptor2.getNumSources()) {
                throw new IllegalArgumentException(JaiI18N.getString("JAIRMIDescriptor3"));
            }
            ParameterListDescriptor parameterListDescriptor2 = operationDescriptor2.getParameterListDescriptor(string);
            if (n2 != parameterListDescriptor2.getNumParameters()) {
                throw new IllegalArgumentException(JaiI18N.getString("JAIRMIDescriptor4"));
            }
            String[] stringArray2 = parameterListDescriptor.getParamNames();
            if (stringArray2 == null) {
                stringArray2 = new String[]{};
            }
            if ((stringArray = parameterListDescriptor2.getParamNames()) == null) {
                stringArray = new String[]{};
            }
            if (!this.containsAll(hashtable2 = this.hashNames(stringArray2), hashtable = this.hashNames(stringArray))) {
                throw new IllegalArgumentException(JaiI18N.getString("JAIRMIDescriptor8"));
            }
            Class[] classArray = parameterListDescriptor.getParamClasses();
            Class[] classArray2 = parameterListDescriptor2.getParamClasses();
            int n3 = 0;
            while (n3 < stringArray2.length) {
                if (classArray[n3] != classArray2[this.getIndex(hashtable, stringArray2[n3])]) {
                    throw new IllegalArgumentException(JaiI18N.getString("JAIRMIDescriptor9"));
                }
                ++n3;
            }
            return null;
        }
        if (string == null || (n > 0 || n2 > 0) && (parameterBlock == null || parameterBlock2 == null)) {
            throw new IllegalArgumentException(JaiI18N.getString("JAIRMIDescriptor5"));
        }
        if (n > 0 && (parameterBlock.getNumSources() != n || parameterBlock2.getNumSources() != n)) {
            Object[] objectArray = new Object[]{string4, new Integer(n2)};
            this.formatter.applyPattern(JaiI18N.getString("JAIRMIDescriptor6"));
            throw new IllegalArgumentException(this.formatter.format(objectArray));
        }
        if (n2 > 0 && (parameterBlock.getNumParameters() != n2 || parameterBlock2.getNumParameters() != n2)) {
            Object[] objectArray = new Object[]{string4, new Integer(n2)};
            this.formatter.applyPattern(JaiI18N.getString("JAIRMIDescriptor7"));
            throw new IllegalArgumentException(this.formatter.format(objectArray));
        }
        RenderedOp renderedOp = (RenderedOp)operationNode;
        PlanarImage planarImage = renderedOp.getRendering();
        Long l = null;
        if (!(planarImage instanceof RMIServerProxy)) {
            throw new RuntimeException(JaiI18N.getString("JAIRMIDescriptor10"));
        }
        l = ((RMIServerProxy)planarImage).getRMIID();
        boolean bl = false;
        if (parameterBlock == parameterBlock2) {
            bl = true;
        }
        Vector<Object> vector = parameterBlock.getSources();
        parameterBlock.removeSources();
        parameterBlock.setSources(JAIRMIUtil.replaceSourcesWithId(vector, string2));
        if (bl) {
            parameterBlock2 = parameterBlock;
        } else {
            serializable = parameterBlock2.getSources();
            parameterBlock2.removeSources();
            parameterBlock2.setSources(JAIRMIUtil.replaceSourcesWithId(serializable, string2));
        }
        serializable = SerializerFactory.getState(renderingHints, null);
        SerializableState serializableState = SerializerFactory.getState(renderingHints2, null);
        SerializableState serializableState2 = null;
        try {
            serializableState2 = this.getImageServer(string2).getInvalidRegion(l, parameterBlock, (SerializableState)serializable, parameterBlock2, serializableState);
        }
        catch (Exception exception) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(exception));
        }
        return serializableState2.getObject();
    }

    private Hashtable hashNames(String[] stringArray) {
        Hashtable<CaselessStringKey, Integer> hashtable = new Hashtable<CaselessStringKey, Integer>();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                hashtable.put(new CaselessStringKey(stringArray[n]), new Integer(n));
                ++n;
            }
        }
        return hashtable;
    }

    private int getIndex(Hashtable hashtable, String string) {
        return (Integer)hashtable.get(new CaselessStringKey(string));
    }

    private boolean containsAll(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            CaselessStringKey caselessStringKey = (CaselessStringKey)enumeration.nextElement();
            if (hashtable2.containsKey(caselessStringKey)) continue;
            return false;
        }
        return true;
    }

    private OperationDescriptor getOperationDescriptor(OperationDescriptor[] operationDescriptorArray, String string) {
        int n = 0;
        while (n < operationDescriptorArray.length) {
            OperationDescriptor operationDescriptor = operationDescriptorArray[n];
            if (operationDescriptor.getName().equalsIgnoreCase(string)) {
                return operationDescriptor;
            }
            ++n;
        }
        return null;
    }
}

