/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.Warp;
import javax.media.jai.WarpOpImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

final class WarpBilinearOpImage
extends WarpOpImage {
    private byte[][] ctable = null;

    public WarpBilinearOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, Warp warp, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, false, borderExtender, interpolation, warp);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            this.ctable = new byte[3][indexColorModel.getMapSize()];
            indexColorModel.getReds(this.ctable[0]);
            indexColorModel.getGreens(this.ctable[1]);
            indexColorModel.getBlues(this.ctable[2]);
        }
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(planarImageArray[0], rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(planarImageArray[0], rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(planarImageArray[0], rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(planarImageArray[0], rasterAccessor);
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX() - 1;
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY() - 1;
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        if (this.ctable == null) {
            int n11 = 0;
            while (n11 < n6) {
                int n12 = n10;
                n10 += n8;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n11, n5, 1, fArray);
                int n13 = 0;
                int n14 = 0;
                while (n14 < n5) {
                    float f = fArray[n13++];
                    float f2 = fArray[n13++];
                    int n15 = WarpBilinearOpImage.floor(f);
                    int n16 = WarpBilinearOpImage.floor(f2);
                    float f3 = f - (float)n15;
                    float f4 = f2 - (float)n16;
                    if (n15 >= n && n15 < n2 && n16 >= n3 && n16 < n4) {
                        int n17 = 0;
                        while (n17 < n7) {
                            int n18 = randomIter.getSample(n15, n16, n17) & 0xFF;
                            int n19 = randomIter.getSample(n15 + 1, n16, n17) & 0xFF;
                            int n20 = randomIter.getSample(n15, n16 + 1, n17) & 0xFF;
                            int n21 = randomIter.getSample(n15 + 1, n16 + 1, n17) & 0xFF;
                            float f5 = (float)(n19 - n18) * f3 + (float)n18;
                            float f6 = (float)(n21 - n20) * f3 + (float)n20;
                            float f7 = (f6 - f5) * f4 + f5;
                            byArray[n17][n12 + nArray[n17]] = (byte)f7;
                            ++n17;
                        }
                    }
                    n12 += n9;
                    ++n14;
                }
                ++n11;
            }
        } else {
            int n22 = 0;
            while (n22 < n6) {
                int n23 = n10;
                n10 += n8;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n22, n5, 1, fArray);
                int n24 = 0;
                int n25 = 0;
                while (n25 < n5) {
                    float f = fArray[n24++];
                    float f8 = fArray[n24++];
                    int n26 = WarpBilinearOpImage.floor(f);
                    int n27 = WarpBilinearOpImage.floor(f8);
                    float f9 = f - (float)n26;
                    float f10 = f8 - (float)n27;
                    if (n26 >= n && n26 < n2 && n27 >= n3 && n27 < n4) {
                        int n28 = 0;
                        while (n28 < n7) {
                            byte[] byArray2 = this.ctable[n28];
                            int n29 = byArray2[randomIter.getSample(n26, n27, 0) & 0xFF] & 0xFF;
                            int n30 = byArray2[randomIter.getSample(n26 + 1, n27, 0) & 0xFF] & 0xFF;
                            int n31 = byArray2[randomIter.getSample(n26, n27 + 1, 0) & 0xFF] & 0xFF;
                            int n32 = byArray2[randomIter.getSample(n26 + 1, n27 + 1, 0) & 0xFF] & 0xFF;
                            float f11 = (float)(n30 - n29) * f9 + (float)n29;
                            float f12 = (float)(n32 - n31) * f9 + (float)n31;
                            float f13 = (f12 - f11) * f10 + f11;
                            byArray[n28][n23 + nArray[n28]] = (byte)f13;
                            ++n28;
                        }
                    }
                    n23 += n9;
                    ++n25;
                }
                ++n22;
            }
        }
    }

    private void computeRectUShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX() - 1;
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY() - 1;
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n6) {
            int n12 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n11, n5, 1, fArray);
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                float f = fArray[n13++];
                float f2 = fArray[n13++];
                int n15 = WarpBilinearOpImage.floor(f);
                int n16 = WarpBilinearOpImage.floor(f2);
                float f3 = f - (float)n15;
                float f4 = f2 - (float)n16;
                if (n15 >= n && n15 < n2 && n16 >= n3 && n16 < n4) {
                    int n17 = 0;
                    while (n17 < n7) {
                        int n18 = randomIter.getSample(n15, n16, n17) & 0xFFFF;
                        int n19 = randomIter.getSample(n15 + 1, n16, n17) & 0xFFFF;
                        int n20 = randomIter.getSample(n15, n16 + 1, n17) & 0xFFFF;
                        int n21 = randomIter.getSample(n15 + 1, n16 + 1, n17) & 0xFFFF;
                        float f5 = (float)(n19 - n18) * f3 + (float)n18;
                        float f6 = (float)(n21 - n20) * f3 + (float)n20;
                        float f7 = (f6 - f5) * f4 + f5;
                        sArray[n17][n12 + nArray[n17]] = (short)f7;
                        ++n17;
                    }
                }
                n12 += n9;
                ++n14;
            }
            ++n11;
        }
    }

    private void computeRectShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX() - 1;
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY() - 1;
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n6) {
            int n12 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n11, n5, 1, fArray);
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                float f = fArray[n13++];
                float f2 = fArray[n13++];
                int n15 = WarpBilinearOpImage.floor(f);
                int n16 = WarpBilinearOpImage.floor(f2);
                float f3 = f - (float)n15;
                float f4 = f2 - (float)n16;
                if (n15 >= n && n15 < n2 && n16 >= n3 && n16 < n4) {
                    int n17 = 0;
                    while (n17 < n7) {
                        int n18 = randomIter.getSample(n15, n16, n17);
                        int n19 = randomIter.getSample(n15 + 1, n16, n17);
                        int n20 = randomIter.getSample(n15, n16 + 1, n17);
                        int n21 = randomIter.getSample(n15 + 1, n16 + 1, n17);
                        float f5 = (float)(n19 - n18) * f3 + (float)n18;
                        float f6 = (float)(n21 - n20) * f3 + (float)n20;
                        float f7 = (f6 - f5) * f4 + f5;
                        sArray[n17][n12 + nArray[n17]] = (short)f7;
                        ++n17;
                    }
                }
                n12 += n9;
                ++n14;
            }
            ++n11;
        }
    }

    private void computeRectInt(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX() - 1;
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY() - 1;
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n6) {
            int n12 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n11, n5, 1, fArray);
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                float f = fArray[n13++];
                float f2 = fArray[n13++];
                int n15 = WarpBilinearOpImage.floor(f);
                int n16 = WarpBilinearOpImage.floor(f2);
                float f3 = f - (float)n15;
                float f4 = f2 - (float)n16;
                if (n15 >= n && n15 < n2 && n16 >= n3 && n16 < n4) {
                    int n17 = 0;
                    while (n17 < n7) {
                        int n18 = randomIter.getSample(n15, n16, n17);
                        int n19 = randomIter.getSample(n15 + 1, n16, n17);
                        int n20 = randomIter.getSample(n15, n16 + 1, n17);
                        int n21 = randomIter.getSample(n15 + 1, n16 + 1, n17);
                        float f5 = (float)(n19 - n18) * f3 + (float)n18;
                        float f6 = (float)(n21 - n20) * f3 + (float)n20;
                        float f7 = (f6 - f5) * f4 + f5;
                        nArray2[n17][n12 + nArray[n17]] = (int)f7;
                        ++n17;
                    }
                }
                n12 += n9;
                ++n14;
            }
            ++n11;
        }
    }

    private void computeRectFloat(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX() - 1;
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY() - 1;
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        float[] fArray2 = new float[2 * n5];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n6) {
            int n12 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n11, n5, 1, fArray2);
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                float f = fArray2[n13++];
                float f2 = fArray2[n13++];
                int n15 = WarpBilinearOpImage.floor(f);
                int n16 = WarpBilinearOpImage.floor(f2);
                float f3 = f - (float)n15;
                float f4 = f2 - (float)n16;
                if (n15 >= n && n15 < n2 && n16 >= n3 && n16 < n4) {
                    int n17 = 0;
                    while (n17 < n7) {
                        float f5;
                        float f6 = randomIter.getSampleFloat(n15, n16, n17);
                        float f7 = randomIter.getSampleFloat(n15 + 1, n16, n17);
                        float f8 = randomIter.getSampleFloat(n15, n16 + 1, n17);
                        float f9 = randomIter.getSampleFloat(n15 + 1, n16 + 1, n17);
                        float f10 = (f7 - f6) * f3 + f6;
                        float f11 = (f9 - f8) * f3 + f8;
                        fArray[n17][n12 + nArray[n17]] = f5 = (f11 - f10) * f4 + f10;
                        ++n17;
                    }
                }
                n12 += n9;
                ++n14;
            }
            ++n11;
        }
    }

    private void computeRectDouble(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX() - 1;
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY() - 1;
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n6) {
            int n12 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n11, n5, 1, fArray);
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                float f = fArray[n13++];
                float f2 = fArray[n13++];
                int n15 = WarpBilinearOpImage.floor(f);
                int n16 = WarpBilinearOpImage.floor(f2);
                float f3 = f - (float)n15;
                float f4 = f2 - (float)n16;
                if (n15 >= n && n15 < n2 && n16 >= n3 && n16 < n4) {
                    int n17 = 0;
                    while (n17 < n7) {
                        double d;
                        double d2 = randomIter.getSampleDouble(n15, n16, n17);
                        double d3 = randomIter.getSampleDouble(n15 + 1, n16, n17);
                        double d4 = randomIter.getSampleDouble(n15, n16 + 1, n17);
                        double d5 = randomIter.getSampleDouble(n15 + 1, n16 + 1, n17);
                        double d6 = (d3 - d2) * (double)f3 + d2;
                        double d7 = (d5 - d4) * (double)f3 + d4;
                        dArray[n17][n12 + nArray[n17]] = d = (d7 - d6) * (double)f4 + d6;
                        ++n17;
                    }
                }
                n12 += n9;
                ++n14;
            }
            ++n11;
        }
    }

    private static final int floor(float f) {
        return f >= 0.0f ? (int)f : (int)f - 1;
    }
}

