/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibAffineBicubicOpImage;
import com.sun.media.jai.mlib.MlibAffineBilinearOpImage;
import com.sun.media.jai.mlib.MlibAffineNearestOpImage;
import com.sun.media.jai.mlib.MlibAffineTableOpImage;
import com.sun.media.jai.mlib.MlibCopyOpImage;
import com.sun.media.jai.mlib.MlibScaleBicubicOpImage;
import com.sun.media.jai.mlib.MlibScaleBilinearOpImage;
import com.sun.media.jai.mlib.MlibScaleNearestOpImage;
import com.sun.media.jai.mlib.MlibScaleTableOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.opimage.TranslateIntOpImage;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.InterpolationTable;

public class MlibAffineRIF
implements RenderedImageFactory {
    private static final float TOLERANCE = 0.01f;

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        boolean bl;
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout)) {
            return null;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        SampleModel sampleModel = renderedImage.getSampleModel();
        boolean bl2 = bl = sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getSampleSize(0) == 1 && (sampleModel.getDataType() == 0 || sampleModel.getDataType() == 1 || sampleModel.getDataType() == 3);
        if (bl) {
            return null;
        }
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        AffineTransform affineTransform = (AffineTransform)parameterBlock.getObjectParameter(0);
        Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(1);
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        if (dArray[0] == 1.0 && dArray[3] == 1.0 && dArray[2] == 0.0 && dArray[1] == 0.0 && dArray[4] == 0.0 && dArray[5] == 0.0) {
            return new MlibCopyOpImage(renderedImage, renderingHints, imageLayout);
        }
        if (dArray[0] == 1.0 && dArray[3] == 1.0 && dArray[2] == 0.0 && dArray[1] == 0.0 && Math.abs(dArray[4] - (double)((int)dArray[4])) < (double)0.01f && Math.abs(dArray[5] - (double)((int)dArray[5])) < (double)0.01f) {
            return new TranslateIntOpImage(renderedImage, (int)dArray[4], (int)dArray[5]);
        }
        if (dArray[0] > 0.0 && dArray[2] == 0.0 && dArray[1] == 0.0 && dArray[3] > 0.0) {
            if (interpolation instanceof InterpolationNearest) {
                return new MlibScaleNearestOpImage(renderedImage, borderExtender, renderingHints, imageLayout, (float)dArray[0], (float)dArray[3], (float)dArray[4], (float)dArray[5], interpolation);
            }
            if (interpolation instanceof InterpolationBilinear) {
                return new MlibScaleBilinearOpImage(renderedImage, borderExtender, renderingHints, imageLayout, (float)dArray[0], (float)dArray[3], (float)dArray[4], (float)dArray[5], interpolation);
            }
            if (interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2) {
                return new MlibScaleBicubicOpImage(renderedImage, borderExtender, renderingHints, imageLayout, (float)dArray[0], (float)dArray[3], (float)dArray[4], (float)dArray[5], interpolation);
            }
            if (interpolation instanceof InterpolationTable) {
                return new MlibScaleTableOpImage(renderedImage, borderExtender, renderingHints, imageLayout, (float)dArray[0], (float)dArray[3], (float)dArray[4], (float)dArray[5], interpolation);
            }
            return null;
        }
        if (interpolation instanceof InterpolationNearest) {
            return new MlibAffineNearestOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationBilinear) {
            return new MlibAffineBilinearOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2) {
            return new MlibAffineBicubicOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationTable) {
            return new MlibAffineTableOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
        }
        return null;
    }
}

