/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.PrintWriter;
import java.util.List;
import javassist.Modifier;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.StackMap;
import javassist.bytecode.StackMapTable;

public class ClassFilePrinter {
    public static void print(ClassFile cf) {
        ClassFilePrinter.print(cf, new PrintWriter(System.out, true));
    }

    /*
     * WARNING - void declaration
     */
    public static void print(ClassFile cf, PrintWriter out) {
        void var1_1;
        ClassFile classFile;
        int n2;
        Object object;
        int n3;
        int n4 = AccessFlag.toModifier(cf.getAccessFlags() & 0xFFFFFFDF);
        out.println("major: " + cf.a + ", minor: " + cf.b + " modifiers: " + Integer.toHexString(cf.getAccessFlags()));
        out.println(Modifier.toString(n4) + " class " + cf.getName() + " extends " + cf.getSuperclass());
        Object object2 = cf.getInterfaces();
        if (object2 != null && ((String[])object2).length > 0) {
            out.print("    implements ");
            out.print(object2[0]);
            for (n3 = 1; n3 < ((String[])object2).length; ++n3) {
                out.print(", " + (String)object2[n3]);
            }
            out.println();
        }
        out.println();
        object2 = cf.getFields();
        int n5 = object2.size();
        for (n3 = 0; n3 < n5; ++n3) {
            object = (FieldInfo)object2.get(n3);
            n2 = ((FieldInfo)object).getAccessFlags();
            out.println(Modifier.toString(AccessFlag.toModifier(n2)) + " " + ((FieldInfo)object).getName() + "\t" + ((FieldInfo)object).getDescriptor());
            ClassFilePrinter.a(((FieldInfo)object).getAttributes(), out, 'f');
        }
        out.println();
        object2 = cf.getMethods();
        n5 = object2.size();
        for (n3 = 0; n3 < n5; ++n3) {
            object = (MethodInfo)object2.get(n3);
            n2 = ((MethodInfo)object).getAccessFlags();
            out.println(Modifier.toString(AccessFlag.toModifier(n2)) + " " + ((MethodInfo)object).getName() + "\t" + ((MethodInfo)object).getDescriptor());
            ClassFilePrinter.a(((MethodInfo)object).getAttributes(), out, 'm');
            out.println();
        }
        out.println();
        ClassFilePrinter.a(classFile.getAttributes(), (PrintWriter)var1_1, 'c');
    }

    private static void a(List list, PrintWriter printWriter, char c2) {
        if (list == null) {
            return;
        }
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            AttributeInfo attributeInfo;
            Object object = (AttributeInfo)list.get(i2);
            if (object instanceof CodeAttribute) {
                attributeInfo = (CodeAttribute)object;
                printWriter.println("attribute: " + ((AttributeInfo)object).getName() + ": " + object.getClass().getName());
                printWriter.println("max stack " + ((CodeAttribute)attributeInfo).getMaxStack() + ", max locals " + ((CodeAttribute)attributeInfo).getMaxLocals() + ", " + ((CodeAttribute)attributeInfo).getExceptionTable().size() + " catch blocks");
                printWriter.println("<code attribute begin>");
                ClassFilePrinter.a(((CodeAttribute)attributeInfo).getAttributes(), printWriter, c2);
                printWriter.println("<code attribute end>");
                continue;
            }
            if (object instanceof AnnotationsAttribute) {
                printWriter.println("annnotation: " + object.toString());
                continue;
            }
            if (object instanceof ParameterAnnotationsAttribute) {
                printWriter.println("parameter annnotations: " + object.toString());
                continue;
            }
            if (object instanceof StackMapTable) {
                printWriter.println("<stack map table begin>");
                StackMapTable.e.a((StackMapTable)object, printWriter);
                printWriter.println("<stack map table end>");
                continue;
            }
            if (object instanceof StackMap) {
                printWriter.println("<stack map begin>");
                ((StackMap)object).print(printWriter);
                printWriter.println("<stack map end>");
                continue;
            }
            if (object instanceof SignatureAttribute) {
                attributeInfo = (SignatureAttribute)object;
                object = ((SignatureAttribute)attributeInfo).getSignature();
                printWriter.println("signature: " + (String)object);
                try {
                    object = c2 == 'c' ? SignatureAttribute.toClassSignature((String)object).toString() : (c2 == 'm' ? SignatureAttribute.toMethodSignature((String)object).toString() : SignatureAttribute.toFieldSignature((String)object).toString());
                    printWriter.println("           " + (String)object);
                }
                catch (BadBytecode badBytecode) {
                    printWriter.println("           syntax error");
                }
                continue;
            }
            printWriter.println("attribute: " + ((AttributeInfo)object).getName() + " (" + ((AttributeInfo)object).get().length + " byte): " + object.getClass().getName());
        }
    }
}

