/*
 * Decompiled with CFR 0.152.
 */
package wizard.ivftidx;

import dbatool.DbFrame;
import dbatool.tableCell.BooleanEditor;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.Logical_file;
import dbaut.comp.DbaTable;
import dbaut.comp.TableColumnSelectionListener;
import dbaut.comp.WizardTextPane;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.system.IniFile;
import dbaut.textField.CharField;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import wizard.AbstractWizardPanel2;
import wizard.ivftidx.IVFPhysicalEditor;
import wizard.ivftidx.IVFPhysicalRenderer;
import wizard.ivftidx.IVFTidxWizardDlg;
import wizard.ivftidx.IVFTidxWizardPanel5;

public class IVFTidxWizardPanel4
extends AbstractWizardPanel2 {
    private static final long serialVersionUID = -3785952110060916355L;
    boolean isLocalHost = true;
    CharField clientSiteLogicalPathCharField = new CharField(128, true);
    boolean error = false;
    TableCols model = new TableCols();
    DbaTable serverSitePathTable = new DbaTable(this.model);
    boolean writed = false;
    String tmp_log = null;

    public IVFTidxWizardPanel4(IVFTidxWizardDlg dlg, AbstractWizardPanel2 previous, boolean isLocalHost) {
        super(0, previous);
        try {
            this.parentDlg = dlg;
            this.isLocalHost = isLocalHost;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.title = this.res.getString("IVF_Step4_title");
        this.setName("SelectStoragePathPanel");
        this.serverSitePathTable.setName("StoragePathTable");
        this.setTextPanel(new WizardTextPane(20, 14, Color.white, this.res.getString("IVF_Step4_Description")));
        this.setImage(new JLabel(DBAImageResource.getResource(this.getClass(), "/jdbaimages/tidxwizard-2.gif")));
        JPanel panel0 = this.createContentPanel();
        JPanel panel1 = new JPanel(new BorderLayout());
        JLabel clientSiteLabel = new JLabel(this.res.getString("IVF_Step4_client_side_logical_path"));
        panel1.add((Component)clientSiteLabel, "West");
        panel1.add((Component)this.clientSiteLogicalPathCharField, "Center");
        panel0.add((Component)panel1, "South");
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().add(this.serverSitePathTable);
        panel0.add((Component)scroll, "Center");
        this.serverSitePathTable.setDefaultEditor(Boolean.class, new BooleanEditor(this.serverSitePathTable, this.model));
        this.serverSitePathTable.setAutoResizeMode(4);
        this.initPhysicalColumn();
        this.serverSitePathTable.setUpCharEditor(1, new CharField(128, true));
        this.serverSitePathTable.addColumnSelectionListener(new TableColumnSelectionListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    IVFTidxWizardPanel4.this.TableSelectionChanged(e);
                }
            }
        });
        this.serverSitePathTable.addRowSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    IVFTidxWizardPanel4.this.TableSelectionChanged(e);
                }
            }
        });
        this.setColumnWidth();
        Color fclr = this.serverSitePathTable.getForeground();
        Color bclr = this.serverSitePathTable.getBackground();
        if (this.isLocalHost) {
            clientSiteLabel.setEnabled(false);
            clientSiteLabel.setBackground(Color.lightGray);
            this.clientSiteLogicalPathCharField.setEnabled(false);
            this.clientSiteLogicalPathCharField.setBackground(Color.lightGray);
            this.serverSitePathTable.setEnabled(true);
        } else {
            clientSiteLabel.setEnabled(true);
            this.clientSiteLogicalPathCharField.setEnabled(true);
            this.serverSitePathTable.setEnabled(false);
            this.serverSitePathTable.setBackground(Color.lightGray);
            this.serverSitePathTable.setForeground(Color.gray);
            this.serverSitePathTable.getTableHeader().setBackground(Color.lightGray);
            this.serverSitePathTable.getTableHeader().setForeground(Color.gray);
            this.clientSiteLogicalPathCharField.grabFocus();
        }
        this.Next_Button.setEnabled(false);
        DbFrame.frame.enableDialogHelp(this, this.help_Button, "Wizard_ivftidx", null);
        IniKeyWordInfo key = new IniKeyWordInfo();
        if (key.isIVF()) {
            int size = key.getLogIVF().size();
            RowInfo newRow = null;
            for (int i = 0; i < size; ++i) {
                newRow = new RowInfo(key.getLogIVF().elementAt(i).toString().trim(), key.getPhyIVF().elementAt(i).toString().trim());
                this.model.addValue(newRow);
            }
            newRow = new RowInfo("", "");
            this.model.addValue(newRow);
        } else {
            RowInfo newRow = new RowInfo("", "");
            this.model.addValue(newRow);
        }
        this.clientSiteLogicalPathCharField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    IVFTidxWizardPanel4.this.clientSiteLogicalPath_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                IVFTidxWizardPanel4.this.clientSiteLogicalPath_keyReleased(e);
            }
        });
    }

    void clientSiteLogicalPath_keyReleased(KeyEvent e) {
        if (this.clientSiteLogicalPathCharField.getText().trim().length() > 0) {
            this.Next_Button.setEnabled(true);
        } else {
            this.Next_Button.setEnabled(false);
        }
    }

    private boolean checkTbl(TableCols model) {
        boolean isReasonable = true;
        if (!model.isChecked) {
            return false;
        }
        for (int i = 0; i <= model.getRowCount() - 1; ++i) {
            if (!((Boolean)model.getValueAt(i, 0)).booleanValue() || !model.getValueAt(i, 1).toString().trim().equalsIgnoreCase("") && !model.getValueAt(i, 1).toString().trim().equalsIgnoreCase("") && !model.getValueAt(i, 2).toString().trim().equalsIgnoreCase("")) continue;
            isReasonable = false;
            break;
        }
        return isReasonable;
    }

    private void initPhysicalColumn() {
        TableColumn phyColumn = this.serverSitePathTable.getColumnModel().getColumn(2);
        IVFPhysicalRenderer renderer = new IVFPhysicalRenderer(this.parentDlg);
        IVFPhysicalEditor editor = new IVFPhysicalEditor(this.parentDlg);
        phyColumn.setCellRenderer(renderer);
        phyColumn.setCellEditor(editor);
    }

    private void setColumnWidth() {
        TableColumn check = this.serverSitePathTable.getColumnModel().getColumn(0);
        TableColumn logName = this.serverSitePathTable.getColumnModel().getColumn(1);
        TableColumn phyName = this.serverSitePathTable.getColumnModel().getColumn(2);
        check.setPreferredWidth(50);
        logName.setPreferredWidth(143);
        phyName.setPreferredWidth(441);
    }

    @Override
    public void Next_Button_actionPerformed(ActionEvent e) {
        if (this.isLocalHost) {
            this.serverSitePathTable.editingStopped(null);
            if (this.error) {
                this.error = false;
                return;
            }
            if (!this.checkTbl(this.model)) {
                GuiUt.showWarningDlg(this.parentDlg, this.res.getString("Warning"), this.res.getString("IVF_Step4_specify_all_data"));
                return;
            }
            if (this.model.isChecked) {
                if (this.tmp_log == null) {
                    this.tmp_log = this.model.getValueAt(this.model.checkedRow, 1).toString();
                    JdmConfig config = new JdmConfig();
                    int rc = config.fileOpen("dmconfig.ini", DbFrame.conn_DatabaseConnection.dbname, "r+");
                    if (rc != 0) {
                        System.out.println("error open dmconfig.ini for logical file ");
                    } else {
                        String value = (String)this.model.getValueAt(this.model.checkedRow, 2);
                        if (value.indexOf(" ") > -1) {
                            value = "\"" + value + "\"";
                        }
                        if ((rc = config.insertPara(this.model.getValueAt(this.model.checkedRow, 1).toString(), value, 4096)) != 0) {
                            System.out.println("error write to dmconfig.ini for logical file " + this.model.getValueAt(this.model.checkedRow, 1) + " phyname=" + this.model.getValueAt(this.model.checkedRow, 2));
                        }
                        config.fileClose();
                        this.writed = true;
                    }
                } else if (!this.tmp_log.equalsIgnoreCase(this.model.getValueAt(this.model.checkedRow, 1).toString())) {
                    JdmConfig config = new JdmConfig();
                    int rc = config.fileOpen("dmconfig.ini", DbFrame.conn_DatabaseConnection.dbname, "r+");
                    if (rc != 0) {
                        System.out.println("error open dmconfig.ini for logical file ");
                    } else {
                        rc = config.procDelete(this.tmp_log, 0);
                        String value = (String)this.model.getValueAt(this.model.checkedRow, 2);
                        if (value.indexOf(" ") > -1) {
                            value = "\"" + value + "\"";
                        }
                        if ((rc = config.insertPara(this.model.getValueAt(this.model.checkedRow, 1).toString(), value, 4096)) != 0) {
                            System.out.println("error write to dmconfig.ini for logical file " + this.model.getValueAt(this.model.checkedRow, 1) + " phyname=" + this.model.getValueAt(this.model.checkedRow, 2));
                        }
                        this.tmp_log = this.model.getValueAt(this.model.checkedRow, 1).toString();
                        this.writed = true;
                    }
                    config.fileClose();
                }
            }
        }
        if (this.next == null) {
            this.next = new IVFTidxWizardPanel5((IVFTidxWizardDlg)this.parentDlg, (AbstractWizardPanel2)this);
        } else {
            ((IVFTidxWizardPanel5)this.next).getOrderColumnNames();
        }
        if (this.isLocalHost) {
            ((IVFTidxWizardDlg)this.parentDlg).logName = this.model.getValueAt(this.model.checkedRow, 1).toString();
            ((IVFTidxWizardDlg)this.parentDlg).phyName = this.model.getValueAt(this.model.checkedRow, 2).toString();
        } else {
            ((IVFTidxWizardDlg)this.parentDlg).logName = this.clientSiteLogicalPathCharField.getText().trim();
        }
        ((IVFTidxWizardDlg)this.parentDlg).Next(this.next);
    }

    @Override
    public void Cancel_Button_actionPerformed(ActionEvent e) {
        if (this.writed) {
            JdmConfig config = new JdmConfig();
            Object logical_name = null;
            int rc = config.fileOpen("dmconfig.ini", DbFrame.conn_DatabaseConnection.dbname, "r+");
            rc = config.procDelete(this.tmp_log, 0);
            config.fileClose();
        }
        ((IVFTidxWizardDlg)this.parentDlg).dispose();
    }

    @Override
    public void Previous_Button_actionPerformed(ActionEvent e) {
        ((IVFTidxWizardDlg)this.parentDlg).Next(this.previous);
    }

    void TableSelectionChanged(ListSelectionEvent e) {
        int row = this.serverSitePathTable.getSelectedRow();
        int col = this.serverSitePathTable.getSelectedColumn();
        if (row < 0 || col < 0) {
            return;
        }
        if (row >= this.serverSitePathTable.getRowCount() || col >= this.serverSitePathTable.getColumnCount()) {
            return;
        }
        this.serverSitePathTable.editCellAt(row, col);
    }

    public class IniKeyWordInfo {
        public Vector valueNameVector = new Vector(95);
        public IniFile ini = null;
        Vector ivfPhyVector = new Vector();
        Vector ivfLogVector = new Vector();
        boolean hasIVFSetting = false;

        public IniKeyWordInfo() {
            this.valueNameVector.addElement("db_atcmt");
            this.valueNameVector.addElement("db_forcs");
            this.valueNameVector.addElement("db_usrfo");
            this.valueNameVector.addElement("db_bkcmp");
            this.valueNameVector.addElement("db_bksvr");
            this.valueNameVector.addElement("db_netec");
            this.valueNameVector.addElement("dd_ddbmd");
            this.valueNameVector.addElement("dd_gtsvr");
            this.valueNameVector.addElement("db_turbo");
            this.valueNameVector.addElement("db_atrmd");
            this.valueNameVector.addElement("db_fotyp");
            this.valueNameVector.addElement("db_idcap");
            this.valueNameVector.addElement("db_svlog");
            this.valueNameVector.addElement("rp_clear");
            this.valueNameVector.addElement("db_difco");
            this.valueNameVector.addElement("db_iosvr");
            this.valueNameVector.addElement("db_rmpad");
            this.valueNameVector.addElement("db_strop");
            this.valueNameVector.addElement("db_daifm");
            this.valueNameVector.addElement("db_daofm");
            this.valueNameVector.addElement("db_tmifm");
            this.valueNameVector.addElement("db_tmofm");
            this.valueNameVector.addElement("db_rtime");
            this.valueNameVector.addElement("db_bktim");
            this.valueNameVector.addElement("rp_btime");
            this.valueNameVector.addElement("db_fbktm");
            this.valueNameVector.addElement("db_bbfil");
            this.valueNameVector.addElement("db_dbfil");
            this.valueNameVector.addElement("db_jnfil");
            this.valueNameVector.addElement("db_tpfil");
            this.valueNameVector.addElement("db_splog");
            this.valueNameVector.addElement("db_order");
            this.valueNameVector.addElement("db_bkdir");
            this.valueNameVector.addElement("db_dbdir");
            this.valueNameVector.addElement("db_fodir");
            this.valueNameVector.addElement("db_spdir");
            this.valueNameVector.addElement("rp_lgdir");
            this.valueNameVector.addElement("db_bkodr");
            this.valueNameVector.addElement("db_lbdir");
            this.valueNameVector.addElement("db_bkfrm");
            this.valueNameVector.addElement("db_svadr");
            this.valueNameVector.addElement("db_usrid");
            this.valueNameVector.addElement("db_paswd");
            this.valueNameVector.addElement("rp_primy");
            this.valueNameVector.addElement("rp_sladr");
            this.valueNameVector.addElement("db_spinc");
            this.valueNameVector.addElement("rp_iterv");
            this.valueNameVector.addElement("dd_gtitv");
            this.valueNameVector.addElement("db_bkitv");
            this.valueNameVector.addElement("db_fbktv");
            this.valueNameVector.addElement("db_usrbb");
            this.valueNameVector.addElement("db_usrdb");
            this.valueNameVector.addElement("db_bmode");
            this.valueNameVector.addElement("db_smode");
            this.valueNameVector.addElement("db_cbmod");
            this.valueNameVector.addElement("db_umode");
            this.valueNameVector.addElement("db_lcode");
            this.valueNameVector.addElement("db_brows");
            this.valueNameVector.addElement("db_sqlst");
            this.valueNameVector.addElement("db_forux");
            this.valueNameVector.addElement("db_bfrsz");
            this.valueNameVector.addElement("db_ptnum");
            this.valueNameVector.addElement("db_extnp");
            this.valueNameVector.addElement("db_scasz");
            this.valueNameVector.addElement("db_maxco");
            this.valueNameVector.addElement("db_njnlb");
            this.valueNameVector.addElement("db_ctimo");
            this.valueNameVector.addElement("db_nbufs");
            this.valueNameVector.addElement("db_bkful");
            this.valueNameVector.addElement("db_dtclt");
            this.valueNameVector.addElement("db_letpt");
            this.valueNameVector.addElement("db_letrp");
            this.valueNameVector.addElement("dd_ctimo");
            this.valueNameVector.addElement("dd_ltimo");
            this.valueNameVector.addElement("db_strsz");
            this.valueNameVector.addElement("db_jnlsz");
            this.valueNameVector.addElement("db_ltimo");
            this.valueNameVector.addElement("rp_ptnum");
            this.valueNameVector.addElement("rp_retry");
            this.valueNameVector.addElement("db_itimo");
            this.valueNameVector.addElement("db_etrpt");
            this.valueNameVector.addElement("rp_reset");
            this.valueNameVector.addElement("db_bkfom");
            this.valueNameVector.addElement("db_gcchk");
            this.valueNameVector.addElement("db_gcwtm");
            this.valueNameVector.addElement("db_gcmxw");
            this.valueNameVector.addElement("db_stsvr");
            this.valueNameVector.addElement("db_fosub");
            this.valueNameVector.addElement("db_ermrv");
            this.valueNameVector.addElement("db_ermsv");
            this.valueNameVector.addElement("db_ifmem");
            this.valueNameVector.addElement("db_stacl");
            this.valueNameVector.addElement("db_bkzip");
            this.valueNameVector.addElement("db_isolv");
            this.valueNameVector.addElement("db_stpwd");
            this.valueNameVector.addElement("db_bkrts");
            this.valueNameVector.addElement("db_ctblm");
            this.valueNameVector.addElement("db_pgsiz");
            this.valueNameVector.addElement("db_wsort");
            this.valueNameVector.addElement("db_netzc");
            this.valueNameVector.addElement("db_fltdb");
            this.valueNameVector.addElement("db_lgsvr");
            this.valueNameVector.addElement("db_lgerr");
            this.valueNameVector.addElement("db_lgstm");
            this.valueNameVector.addElement("db_lgsys");
            this.valueNameVector.addElement("db_lgfsz");
            this.valueNameVector.addElement("db_lgfno");
            this.valueNameVector.addElement("db_lgsql");
            this.valueNameVector.addElement("db_lgpln");
            this.valueNameVector.addElement("db_lgpar");
            this.valueNameVector.addElement("db_lglck");
            this.valueNameVector.addElement("db_lgdir");
            this.valueNameVector.addElement("db_ittdir");
            this.ini = this.getIni();
            String[] existSectionArray = this.ini.getVariables(DbFrame.frame.px.getLoginDbName());
            String[] existSectionValues = this.ini.getValues(DbFrame.frame.px.getLoginDbName());
            Vector v = new Vector();
            this.checkDefaultKeyIsExist(existSectionArray, v);
            int size = v.size();
            if (size > 0) {
                this.hasIVFSetting = true;
                JdmConfig config = new JdmConfig();
                String s = "dmconfig.ini";
                config.fileOpen(s, DbFrame.frame.px.getLoginDbName(), "r");
                String variable = null;
                File f = null;
                Logical_file lf = null;
                String pagenum = null;
                for (int i = 0; i < size; ++i) {
                    lf = (Logical_file)config.getPara(v.elementAt(i).toString(), 53760);
                    variable = lf.getFilename();
                    pagenum = lf.getPagenum();
                    if (pagenum.length() > 0 || !(f = new File(variable)).isDirectory()) continue;
                    this.ivfLogVector.add(v.elementAt(i).toString());
                    this.ivfPhyVector.add(variable);
                }
                config.fileClose();
            }
        }

        public boolean isIVF() {
            return this.hasIVFSetting;
        }

        public Vector getLogIVF() {
            return this.ivfLogVector;
        }

        public Vector getPhyIVF() {
            return this.ivfPhyVector;
        }

        private void checkDefaultKeyIsExist(String[] sa, Vector v) {
            int size = sa.length;
            String s = null;
            for (int i = 0; i < size; ++i) {
                s = sa[i].toLowerCase();
                if (this.valueNameVector.indexOf(s) >= 0) continue;
                v.add(s);
            }
        }

        private IniFile getIni() {
            JdmConfig config = new JdmConfig();
            String s = config.filePath("dmconfig.ini");
            return new IniFile(s, false);
        }
    }

    public class TableCols
    extends AbstractTableModel {
        private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.wizard.ResWizard", LocaleManager.getLocale());
        private String db_name;
        private String db_dir;
        public boolean isChecked;
        public int checkedRow;
        public int preCheckedRow;
        public boolean preIsChecked;
        final String[] columnNames;
        private Vector data;

        public TableCols() {
            this.db_name = DbFrame.conn_DatabaseConnection.dbname;
            this.db_dir = DbFrame.conn_DatabaseConnection.getDBDir();
            this.isChecked = false;
            this.checkedRow = -1;
            this.preCheckedRow = -1;
            this.preIsChecked = false;
            this.columnNames = new String[]{"", this.res.getString("Logical_Name"), this.res.getString("Physical_Name")};
            this.data = new Vector();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        public void addValue(RowInfo newData) {
            this.data.addElement(newData);
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        @Override
        public Object getValueAt(int row, int col) {
            RowInfo rowData = (RowInfo)this.data.elementAt(row);
            return rowData.getValueAt(col);
        }

        public void removeValue(int x) {
            this.data.remove(x);
        }

        public Class getColumnClass(int c) {
            RowInfo rowData = (RowInfo)this.data.elementAt(0);
            return rowData.getValueAt(c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            boolean b = (Boolean)this.getValueAt(row, 0);
            if (col == 0) {
                if (b) {
                    return true;
                }
                return !b && !this.isChecked;
            }
            return b;
        }

        private boolean isLogicalFileExists(String filename, int index) {
            JdmConfig config = new JdmConfig();
            int rc = config.fileOpen("dmconfig.ini", this.db_name, "r");
            if (rc != 0) {
                return false;
            }
            boolean isFound = false;
            String s = (String)config.getPara(filename, 4096);
            if (s != null && s.length() > 0) {
                isFound = true;
            }
            config.fileClose();
            if (isFound) {
                return isFound;
            }
            int size = this.getRowCount();
            String temp = null;
            for (int i = 0; i < size; ++i) {
                if (i == index || (temp = (String)this.getValueAt(i, 1)).length() <= 0 || !temp.equalsIgnoreCase(filename)) continue;
                isFound = true;
                break;
            }
            return isFound;
        }

        private boolean isLogicalNameIsKeyword(String filename, int index) {
            JdmConfig config = new JdmConfig();
            int rc = config.fileOpen("dmconfig.ini", this.db_name, "r");
            if (rc != 0) {
                return false;
            }
            boolean isKeyword = false;
            String s = (String)config.getPara(filename, 4096);
            if (s != null && s.length() > 0) {
                isKeyword = true;
            }
            config.fileClose();
            if (isKeyword) {
                return isKeyword;
            }
            IniKeyWordInfo ikwi = new IniKeyWordInfo();
            isKeyword = ikwi.valueNameVector.indexOf(filename.toLowerCase()) >= 0;
            return isKeyword;
        }

        private String getFullPath(String file, String path) {
            String fileseparator = System.getProperty("file.separator");
            String filename = null;
            filename = file.indexOf(fileseparator) < 0 ? (path.endsWith(fileseparator) ? path + file : path + fileseparator + file) : file;
            return filename;
        }

        private boolean isFileExists(String file, String path, int index) {
            String filename = this.getFullPath(file, path);
            System.out.println("filename  = " + filename);
            File f = new File(filename);
            if (!f.exists()) {
                boolean b = f.mkdirs();
                return false;
            }
            int size = this.getRowCount();
            String temp = null;
            for (int i = 0; i < size; ++i) {
                if (i == index || (temp = (String)this.getValueAt(i, 2)).length() <= 0 || !this.getFullPath(temp, path).equalsIgnoreCase(filename)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            IVFTidxWizardPanel4.this.error = false;
            if (value == null) {
                return;
            }
            Object orig_value = this.getValueAt(row, col);
            if (col == 1 && !value.equals(orig_value) && value.toString().length() > 0 && this.isLogicalFileExists(((String)value).trim(), row)) {
                GuiUt.showErrorDlg(IVFTidxWizardPanel4.this.parentDlg, value + " " + this.res.getString("IVF_Step4_logical_name_already"), null);
                IVFTidxWizardPanel4.this.error = true;
                return;
            }
            if (col == 2) {
                if (!value.equals(orig_value) && value.toString().length() > 0 && this.isFileExists(((String)value).trim(), this.db_dir, row)) {
                    GuiUt.showErrorDlg(IVFTidxWizardPanel4.this.parentDlg, value + " " + this.res.getString("IVF_Step4_physical_name_already"), null);
                    IVFTidxWizardPanel4.this.error = true;
                    return;
                }
                value = this.getFullPath(((String)value).trim(), this.db_dir);
            }
            RowInfo rowData = (RowInfo)this.data.elementAt(row);
            rowData.setValueAt(value, col);
            if (col == 0) {
                if (((Boolean)value).booleanValue()) {
                    this.isChecked = true;
                    this.checkedRow = row;
                    IVFTidxWizardPanel4.this.Next_Button.setEnabled(true);
                } else {
                    this.isChecked = false;
                    this.checkedRow = -1;
                    IVFTidxWizardPanel4.this.Next_Button.setEnabled(false);
                }
            }
            this.fireTableCellUpdated(row, col);
            int rowNumber = 0;
            rowNumber = IVFTidxWizardPanel4.this.serverSitePathTable.getRowCount();
            if (!(col != 1 || value.toString().equalsIgnoreCase("") || rowNumber != 1 && (String)IVFTidxWizardPanel4.this.serverSitePathTable.getValueAt(rowNumber - 1, 1) == "")) {
                RowInfo newRow = new RowInfo("", "");
                this.data.addElement(newRow);
                IVFTidxWizardPanel4.this.serverSitePathTable.revalidate();
                IVFTidxWizardPanel4.this.serverSitePathTable.repaint();
            }
        }
    }

    public class RowInfo {
        Object[] data = new Object[3];

        public RowInfo(String logical_name, String physical_name) {
            this.data[0] = Boolean.FALSE;
            this.data[1] = logical_name;
            this.data[2] = physical_name;
        }

        public Object getValueAt(int index) {
            return this.data[index];
        }

        public void setValueAt(Object value, int index) {
            this.data[index] = value;
        }
    }
}

