/*
 * Decompiled with CFR 0.152.
 */
package wizard.domain;

import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.HelpButton;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import wizard.domain.Panel_domain1;
import wizard.domain.Panel_domain2;
import wizard.domain.Panel_domain3;

public class Wizard_domain
extends JDialog {
    private static final long serialVersionUID = 1808175011479527913L;
    DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.wizard.ResWizard", LocaleManager.getLocale());
    JPanel jPanel1 = new JPanel(new BorderLayout());
    DbaButton Cancel_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/cancelwizard.gif"), new ReflectionAction(this, "Cancel_Button_actionPerformed"));
    DbaButton Next_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("Next_"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/next.gif"), new ReflectionAction(this, "Next_Button_actionPerformed"));
    DbaButton Previous_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("_Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/jdbaimages/previous.gif"), new ReflectionAction(this, "Previous_Button_actionPerformed"));
    private Vector<JPanel> panels = new Vector();
    private int cur_step = 0;
    Color sysColor = UIManager.getColor(new UIManager());
    private boolean isMoreTimes = false;
    HelpButton help_Button = new HelpButton();

    public Wizard_domain(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Wizard_domain(Frame frame) {
        super(frame);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String combineSqlString() {
        Panel_domain2 tmpDomain2 = (Panel_domain2)this.panels.elementAt(1);
        String typeName = tmpDomain2.dataType_ComboBox.getSelectedItem().toString().trim();
        String sqlString = "create domain \"" + tmpDomain2.domainName_TextField.getText().trim() + "\"" + " " + typeName + " ";
        if ((typeName.equals("char") || typeName.equals("binary") || typeName.equals("varchar") || typeName.equals("nchar") || typeName.equals("nvarchar")) && !tmpDomain2.precision_TextField.getText().trim().equalsIgnoreCase("")) {
            sqlString = sqlString + "(" + tmpDomain2.precision_TextField.getText().trim() + ")";
        }
        if (typeName.equals("decimal") && !tmpDomain2.precision_TextField.getText().trim().equalsIgnoreCase("")) {
            sqlString = sqlString + "(" + tmpDomain2.precision_TextField.getText().trim();
            if (!tmpDomain2.scale_TextField.getText().trim().equalsIgnoreCase("")) {
                sqlString = sqlString + "," + tmpDomain2.scale_TextField.getText().trim();
            }
            sqlString = sqlString + ")";
        }
        if (tmpDomain2.textConvertComboBox.getSelectedIndex() != 0) {
            sqlString = sqlString + " text converter " + tmpDomain2.textConvertComboBox.getSelectedItem().toString().trim();
        }
        if (tmpDomain2.encryptCheckBox.isSelected()) {
            sqlString = sqlString + " encrypt";
        }
        if (!tmpDomain2.default_TextField.getText().trim().equalsIgnoreCase("")) {
            if (tmpDomain2.systemDefaultCheckBox.isSelected()) {
                sqlString = sqlString + " system";
            }
            sqlString = typeName.equals("smallint") || typeName.equals("integer") || typeName.equals("bigint") || typeName.equals("real") || typeName.equals("float") || typeName.equals("double") || typeName.equals("decimal") ? sqlString + " default " + tmpDomain2.default_TextField.getText().trim() : (typeName.equals("date") || typeName.equals("time") || typeName.equals("timestamp") ? (tmpDomain2.default_TextField.getText().trim().indexOf("(") >= 0 ? sqlString + " default " + tmpDomain2.default_TextField.getText().trim() : sqlString + " default " + "'" + tmpDomain2.default_TextField.getText().trim() + "'") : sqlString + " default " + "'" + tmpDomain2.default_TextField.getText().trim() + "'");
            if (tmpDomain2.onUpdateCheckBox.isSelected()) {
                sqlString = sqlString + " on update";
            }
        }
        if (!tmpDomain2.constraint_EditorPane.getText().trim().equalsIgnoreCase("")) {
            sqlString = tmpDomain2.constraint_EditorPane.getText().trim().toLowerCase().startsWith("check") ? sqlString + " " + tmpDomain2.constraint_EditorPane.getText().trim() : sqlString + " check " + tmpDomain2.constraint_EditorPane.getText().trim();
        }
        return sqlString;
    }

    void setHelpId(int step) {
        String[] ids = new String[]{"Wizard_domain_StepOneHelpIDInformation", "Wizard_domain_StepTwoHelpIDInformation", "Wizard_domain_StepThreeHelpIDInformation"};
        if (step < 0 || step >= ids.length) {
            return;
        }
        DbFrame.frame.enableDialogHelp(this.getRootPane(), this.help_Button, ids[step], null);
    }

    void jbInit() throws Exception {
        this.setName("DomainDialogWizard");
        this.Cancel_Button.setName("CancelButton");
        this.setTitle(this.res.getString("Create_Domain_Wizard"));
        this.jPanel1.setPreferredSize(new Dimension(640, 480));
        if (this.cur_step == 0) {
            this.panels.add(this.cur_step, new Panel_domain1(this));
            this.jPanel1.add((Component)((Panel_domain1)this.panels.elementAt(this.cur_step)), "Center");
            this.Previous_Button.setEnabled(false);
            this.setHelpId(this.cur_step);
            ++this.cur_step;
        }
        this.help_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/help.gif"));
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        bottomPanel.add(this.Previous_Button);
        bottomPanel.add(this.Next_Button);
        bottomPanel.add(this.Cancel_Button);
        bottomPanel.add(this.help_Button);
        this.jPanel1.add((Component)bottomPanel, "South");
        this.Next_Button.setEnabled(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanel1, "Center");
    }

    public void Next_Button_actionPerformed(ActionEvent e) {
        Panel_domain2 myDomain2;
        JPanel cur_panel = this.panels.elementAt(this.cur_step - 1);
        if (cur_panel instanceof Panel_domain3) {
            Panel_domain3 myDomain3 = (Panel_domain3)cur_panel;
            String s = myDomain3.jEditorPane1.getText().trim();
            if (DatabaseConnection.executeSQL(this, s, false)) {
                GuiUt.showInformationDlg(this, this.res.getString("Domain_is_created_successfully"));
                this.setVisible(false);
                this.panels.removeAllElements();
                this.dispose();
            }
            return;
        }
        if (this.panels.size() == this.cur_step) {
            if (this.cur_step == 1) {
                this.panels.add(this.cur_step, new Panel_domain2(this));
                this.jPanel1.remove((Panel_domain1)this.panels.elementAt(this.cur_step - 1));
                this.jPanel1.add((Component)((Panel_domain2)this.panels.elementAt(this.cur_step)), "Center");
                this.setTitle(this.res.getString("Create_Domain_Wizard_Name_the_Domain"));
            } else if (this.cur_step == 2) {
                myDomain2 = (Panel_domain2)this.panels.elementAt(this.cur_step - 1);
                boolean isDomainNameExist = DbFrame.conn_DatabaseConnection.isDomainNameExist(myDomain2.domainName_TextField.getText().trim());
                boolean isConnected = DbFrame.conn_DatabaseConnection.isConnected;
                if (!isConnected) {
                    return;
                }
                if (isDomainNameExist) {
                    GuiUt.showWarningDlg(this, this.res.getString("Warning"), myDomain2.domainName_TextField.getText().trim() + " " + this.res.getString("already_exist"));
                    --this.cur_step;
                } else {
                    Panel_domain3 myDomain3 = new Panel_domain3(this);
                    myDomain3.jEditorPane1.setText(this.combineSqlString());
                    this.panels.add(this.cur_step, myDomain3);
                    this.jPanel1.remove((Panel_domain2)this.panels.elementAt(this.cur_step - 1));
                    this.jPanel1.add((Component)((Panel_domain3)this.panels.elementAt(this.cur_step)), "Center");
                    this.setTitle(this.res.getString("Domain_Final_review"));
                    this.Next_Button.setText(this.res.getString("Finish"));
                    this.Next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/finish.gif"));
                    this.Next_Button.setMnemonic('F');
                    this.Next_Button.setName("FinishButton");
                }
            }
        } else if (this.cur_step == 1) {
            this.jPanel1.remove((Panel_domain1)this.panels.elementAt(this.cur_step - 1));
            this.jPanel1.add((Component)((Panel_domain2)this.panels.elementAt(this.cur_step)), "Center");
            this.isMoreTimes = true;
            this.setTitle(this.res.getString("Create_Domain_Wizard_Name_the_Domain"));
        } else if (this.cur_step == 2) {
            myDomain2 = (Panel_domain2)this.panels.elementAt(this.cur_step - 1);
            boolean isDomainNameExist = DbFrame.conn_DatabaseConnection.isDomainNameExist(myDomain2.domainName_TextField.getText().trim());
            boolean isConnected = DbFrame.conn_DatabaseConnection.isConnected;
            if (!isConnected) {
                return;
            }
            if (isDomainNameExist) {
                GuiUt.showWarningDlg(this, this.res.getString("Warning"), myDomain2.domainName_TextField.getText().trim() + " already exists ! ");
                --this.cur_step;
            } else {
                Panel_domain3 myDomain3 = (Panel_domain3)this.panels.elementAt(this.cur_step);
                myDomain3.jEditorPane1.setText(this.combineSqlString());
                this.jPanel1.remove((Panel_domain2)this.panels.elementAt(this.cur_step - 1));
                this.jPanel1.add((Component)((Panel_domain3)this.panels.elementAt(this.cur_step)), "Center");
                this.setTitle(this.res.getString("Domain_Final_review"));
                this.Next_Button.setText(this.res.getString("Finish"));
                this.Next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/finish.gif"));
                this.Next_Button.setMnemonic('F');
                this.Next_Button.setName("FinishButton");
            }
        }
        this.Previous_Button.setEnabled(true);
        this.jPanel1.revalidate();
        this.jPanel1.repaint();
        this.setHelpId(this.cur_step);
        ++this.cur_step;
        if (this.isMoreTimes) {
            Panel_domain2 myTidx2 = (Panel_domain2)this.panels.elementAt(this.cur_step - 1);
            if (myTidx2.domainName_TextField.getText().equalsIgnoreCase("")) {
                this.Next_Button.setEnabled(false);
            } else {
                this.Next_Button.setEnabled(true);
            }
            this.isMoreTimes = false;
        }
    }

    public void Previous_Button_actionPerformed(ActionEvent e) {
        --this.cur_step;
        this.setHelpId(this.cur_step - 1);
        if (this.cur_step == 1) {
            this.jPanel1.remove((Panel_domain2)this.panels.elementAt(this.cur_step));
            this.jPanel1.add((Component)((Panel_domain1)this.panels.elementAt(this.cur_step - 1)), "Center");
            this.Previous_Button.setEnabled(false);
            this.Next_Button.setEnabled(true);
            this.setTitle(this.res.getString("Create_Domain_Wizard"));
        } else if (this.cur_step == 2) {
            this.jPanel1.remove((Panel_domain3)this.panels.elementAt(this.cur_step));
            this.jPanel1.add((Component)((Panel_domain2)this.panels.elementAt(this.cur_step - 1)), "Center");
            this.setTitle(this.res.getString("Create_Domain_Wizard_Name_the_Domain"));
        }
        this.Next_Button.setText(this.res.getString("Next_"));
        this.Next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/next.gif"));
        this.Next_Button.setMnemonic('N');
        this.Next_Button.setName("NextButton");
        this.jPanel1.revalidate();
        this.jPanel1.repaint();
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.panels.removeAllElements();
        this.dispose();
    }
}

