/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.backup;

import ServerMgr.DatabaseConnection;
import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.BackServerProgressDialog;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.WizardTextPane;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.util.JavaTypeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import svrmgrwizard.backup.BackupDlg;

public class OnlineBackupByBackupServerPanel
extends AbstractWizardPanel {
    private static final long serialVersionUID = 5117074765645329271L;
    private BackupDlg parentDialog = null;
    private AbstractWizardPanel previousPanel = null;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.BackupRes", LocaleManager.getLocale());
    private String title = null;
    private SmHelpButton helpButton = new SmHelpButton();
    private DbaButton cancelButton = new DbaButton(new Dimension(80, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private DbaButton finishButton = new DbaButton(new Dimension(80, 24), this.res.getString("Finish"), 'F', DBAImageResource.getResource(this.getClass(), "/dbautimages/finish.gif"), new ReflectionAction(this, "finishButtonActionPerformed"));
    private DbaButton previousButton = new DbaButton(new Dimension(80, 24), this.res.getString("Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "previousButtonActionPerformed"));
    private int backupType = -1;
    private WizardTextPane jTextPane1 = new WizardTextPane(20, 14);
    private JPanel buttonPanel = new JPanel(new FlowLayout(2));
    private ImageIcon imgIcon = DBAImageResource.getResource(this.getClass(), "/svrmgrimages/BackupDBleft.gif");
    private DatabaseConnection connection = null;
    private ArrayList connectionInfo = null;
    private boolean isComplete = false;
    private boolean isSuccess = false;
    private String errorMessage = null;

    public OnlineBackupByBackupServerPanel(BackupDlg parentDialog, AbstractWizardPanel previousPanel, int backupType, DatabaseConnection connection, ArrayList connectionInfo) {
        this.parentDialog = parentDialog;
        this.previousPanel = previousPanel;
        this.backupType = backupType;
        this.connection = connection;
        this.connectionInfo = connectionInfo;
        this.init();
    }

    private void init() {
        this.setName("OnlineBackupByBksvrPanel");
        this.finishButton.setName("FinishButton");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel jLabel1 = new JLabel();
        jLabel1.setBorder(BorderFactory.createLoweredBevelBorder());
        jLabel1.setIcon(this.imgIcon);
        JPanel jPanel1 = new JPanel();
        jPanel1.setPreferredSize(new Dimension(470, 440));
        jPanel1.setBorder(BorderFactory.createEtchedBorder());
        jPanel1.setLayout(new BorderLayout());
        jPanel1.add((Component)this.jTextPane1, "Center");
        panel.add((Component)jLabel1, "West");
        panel.add((Component)jPanel1, "East");
        this.add((Component)panel, "Center");
        this.finishButton.setHorizontalTextPosition(2);
        this.cancelButton.setHorizontalTextPosition(2);
        String helpID = "";
        helpID = this.backupType == 3 ? "Help_Backup_OnlineByBackupServerFullBackupPanel" : (this.backupType == 6 ? "Help_Backup_OnlineByBackupServerDiffBackupPanel" : "Help_Backup_OnlineByBackupServerIncBackupPanel");
        SmFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, helpID, null);
        this.buttonPanel.add(this.previousButton);
        this.buttonPanel.add(this.finishButton);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(this.helpButton);
        this.setButtonBar(this.buttonPanel);
        this.initInformation();
    }

    public void previousButtonActionPerformed(ActionEvent e) {
        this.parentDialog.next(this.previousPanel);
    }

    public void finishButtonActionPerformed(ActionEvent e) {
        final BackServerProgressDialog progressDialog = new BackServerProgressDialog(this.parentDialog, this.res.getString("Online_Backup_By_Backup_Server"));
        try {
            if (this.connection == null) {
                System.out.println(this.getClass().getName() + "->connection is null.");
                return;
            }
            if (!this.connection.isConnected()) {
                System.out.println(this.getClass().getName() + "->connection is not connected.");
                return;
            }
            if (this.connection.dbconn.isClosed()) {
                System.out.println(this.getClass().getName() + "->connection is closed.");
                return;
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        this.isComplete = false;
        this.isSuccess = false;
        this.errorMessage = null;
        Thread taskThread = new Thread(){

            @Override
            public void run() {
                OnlineBackupByBackupServerPanel.this.runBackupTask();
            }
        };
        taskThread.start();
        Thread getBKProgressValueThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block8: {
                    CallableStatement cstmt = null;
                    try {
                        String sql = "CALL GETSYSTEMOPTION('BKPROGRESS',?)";
                        cstmt = ((OnlineBackupByBackupServerPanel)OnlineBackupByBackupServerPanel.this).connection.dbconn.prepareCall(sql);
                        cstmt.registerOutParameter(1, 12);
                        do {
                            Thread.sleep(500L);
                            cstmt.executeQuery();
                            int progressValue = JavaTypeUtil.parseInt(cstmt.getString(1), OnlineBackupByBackupServerPanel.this.parentDialog);
                            progressDialog.setProgressBarValue(progressValue);
                        } while (!OnlineBackupByBackupServerPanel.this.isComplete);
                        DbaObject.close(cstmt);
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        break block8;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        DbaObject.close(cstmt);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        progressDialog.setVisible(false);
                        progressDialog.dispose();
                        if (OnlineBackupByBackupServerPanel.this.isSuccess) {
                            GuiUt.showSuccessDlg(OnlineBackupByBackupServerPanel.this.parentDialog, OnlineBackupByBackupServerPanel.this.res.getString("Backup_Successfully_FullStop"), null);
                        } else if (OnlineBackupByBackupServerPanel.this.errorMessage != null) {
                            GuiUt.showErrorDlg(OnlineBackupByBackupServerPanel.this.parentDialog, OnlineBackupByBackupServerPanel.this.errorMessage, null);
                        }
                        if (OnlineBackupByBackupServerPanel.this.connection.isConnected()) {
                            OnlineBackupByBackupServerPanel.this.connection.disconnect();
                        }
                        OnlineBackupByBackupServerPanel.this.parentDialog.setVisible(false);
                        OnlineBackupByBackupServerPanel.this.parentDialog.dispose();
                    }
                });
            }
        };
        getBKProgressValueThread.start();
        progressDialog.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBackupTask() {
        String passWord;
        String userName;
        String dbName;
        DatabaseConnection backupConnection;
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.connectionInfo == null) {
            System.out.println("connection information is null!");
        }
        if ((backupConnection = new DatabaseConnection(dbName = (String)this.connectionInfo.get(0), userName = (String)this.connectionInfo.get(1), passWord = (String)this.connectionInfo.get(2), this.parentDialog)) == null) {
            System.out.println(this.getClass() + " : backup connection is null.");
            return;
        }
        Statement stmt = null;
        try {
            stmt = backupConnection.dbconn.createStatement();
            String query = null;
            if (this.backupType == 3) {
                query = "CALL SETSYSTEMOPTION('STARTBACKUP','1')";
            } else if (this.backupType == 6) {
                query = "CALL SETSYSTEMOPTION('STARTBACKUP','3')";
            } else if (this.backupType == 8) {
                query = "CALL SETSYSTEMOPTION('STARTBACKUP','2')";
            }
            stmt.execute(query);
            SQLWarning sqlw = stmt.getWarnings();
            if (sqlw == null) {
                this.isSuccess = true;
            } else {
                this.isSuccess = false;
                this.errorMessage = sqlw.getMessage();
            }
        }
        catch (SQLException sqle) {
            this.isSuccess = false;
            this.errorMessage = sqle.getMessage();
        }
        finally {
            this.isComplete = true;
            DbaObject.close(stmt);
            DbaObject.close(backupConnection.dbconn);
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        if (this.connection.isConnected()) {
            this.connection.disconnect();
        }
        this.parentDialog.dispose();
    }

    @Override
    public void windowClosing() {
        this.cancelButtonActionPerformed(null);
    }

    @Override
    public String getTitle() {
        this.title = "Online_Backup_By_Backup_Server";
        return this.title;
    }

    private void initInformation() {
        if (this.backupType == 3) {
            this.jTextPane1.setText(this.res.getString("Online_Full_Backup_By_Backup_Server_Description_FullStop"));
        } else if (this.backupType == 6) {
            this.jTextPane1.setText(this.res.getString("Online_Differential_Backup_By_Backup_Server_Description_FullStop"));
        } else if (this.backupType == 8) {
            this.jTextPane1.setText(this.res.getString("Online_Incremental_Backup_By_Backup_Server_Description_FullStop"));
        } else {
            this.jTextPane1.setText(this.res.getString("Unsupport_Online_Backup_Type_By_Backup_Server_FullStop"));
        }
    }
}

