/*
 * Decompiled with CFR 0.152.
 */
package queryAnalyzer;

import dbatool.DbFrame;
import dbatool.DbaToolBar;
import dbaut.GuiUt;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dbmaker.sql.JdbcOdbcConnection;
import dbmaker.sql.JdbcOdbcStatement;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import queryAnalyzer.QueryFrame;
import queryAnalyzer.Stopwatch;
import sqlparser.JSQLParserHandler;
import sqlparser.SQLParser;

public class AsJsql
implements JSQLParserHandler {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("resource.jsqltool", LocaleManager.getLocale());
    protected Map<String, Command> validStatement = new LinkedHashMap<String, Command>();
    final String dblogin = "jdbc:dbmaker:";
    final String driver = "dbmaker.sql.JdbcOdbcDriver";
    static String LINEFEED = null;
    static String END = null;
    static String SPACE = " ";
    static String TAB = "\t";
    private Reader in = null;
    private Writer out = null;
    private static SQLParser parser = null;
    private Connection dbconn = null;
    private Stopwatch watch = new Stopwatch();
    public long totalTime = 0L;
    public FontMetrics fm = null;
    private StringBuffer sb = new StringBuffer();

    public AsJsql(FontMetrics fm, String in, Writer out, String enc, Connection connection) {
        this.fm = fm;
        this.out = out;
        this.dbconn = connection;
        this.SQLStatement(in);
    }

    public AsJsql(FontMetrics fm, InputStreamReader in, Writer out, String enc, Connection connection) {
        this.fm = fm;
        this.in = in;
        this.out = out;
        this.dbconn = connection;
        this.process();
    }

    public AsJsql(InputStreamReader in, OutputStreamWriter out, String enc, Connection dbconn) {
        this(null, in, (Writer)out, enc, dbconn);
    }

    public AsJsql(InputStreamReader in, OutputStreamWriter out, Connection dbconn) {
        this(in, out, null, dbconn);
    }

    private void process() {
        this.totalTime = 0L;
        if (this.isWindows()) {
            LINEFEED = "\r\n  ";
            END = "\r\n";
        } else {
            LINEFEED = "\n  ";
            END = "\n";
        }
        if (parser == null) {
            parser = new SQLParser(this.in);
        } else {
            SQLParser.ReInit(this.in);
        }
        SQLParser.setHandle(this);
        try {
            SQLParser.ExpressionList();
            this.out.write(this.res.getString("Execution_Complete"));
            this.out.flush();
            this.out.close();
        }
        catch (Error e) {
            GuiUt.showErrorDlg(DbFrame.frame, this.res.getString("syntax_error_not_valid_sql_command"), "");
            e.printStackTrace();
        }
        catch (Exception e) {
            GuiUt.showErrorDlg(DbFrame.frame, this.res.getString("syntax_error_not_valid_sql_command"), "");
            e.printStackTrace();
        }
    }

    @Override
    public void SQLConnect(String[] ts) {
        String s = null;
        if (ts != null) {
            int size = 0;
            size = ts.length - 1;
            s = ts[0] + " ";
            for (int i = 1; i < size; ++i) {
                s = s + ts[i];
                if (i >= size - 1) continue;
                s = s + " ";
            }
        }
        try {
            Class.forName(this.driver);
        }
        catch (Exception e) {
            try {
                this.out.write(e.getMessage());
                this.out.write(LINEFEED + END);
                this.out.flush();
            }
            catch (IOException ee) {
                ee.printStackTrace();
            }
        }
        try {
            if (this.dbconn != null && !this.dbconn.isClosed()) {
                this.out.write("SQL> ");
                for (int i = 0; i < ts.length && ts[i] != null; ++i) {
                    this.out.write(ts[i]);
                    this.out.write(SPACE);
                }
                this.out.write(LINEFEED);
                this.out.write(this.res.getString("Connection handle in use!"));
                this.out.write(LINEFEED + END);
                this.out.flush();
            }
            this.validStatement.put(s, new Command(s, null, null, SQLTYPE.OTHER));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception ee) {
            GuiUt.showErrorDlg(QueryFrame.frame, ee.getMessage(), "");
            try {
                this.out.write(ee.getMessage());
                this.out.write(LINEFEED + END);
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void SQLDisconnect(String s) {
        if (DbFrame.conn_DatabaseConnection != null) {
            DbaToolBar.disconnectButton_actionPerformed(null);
        }
    }

    public void saveQueryResult(Writer out) {
        try {
            out.write(this.sb.toString());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void SQLStatement(String query) {
        boolean showPlan = QueryFrame.frame.showPlan.isSelected();
        if (query.startsWith("--")) {
            return;
        }
        PreparedStatement pstmt = null;
        String json = null;
        Statement stmt = null;
        try {
            if (showPlan) {
                ((JdbcOdbcConnection)this.dbconn).setOption(1104, 3);
            }
            this.sb.delete(0, this.sb.length());
            this.sb.append("SQL> ");
            this.sb.append(query);
            this.sb.append(LINEFEED);
            if (this.dbconn == null) {
                this.sb.append(this.res.getString("no_connection"));
                this.sb.append(LINEFEED + END);
                return;
            }
            if (showPlan) {
                pstmt = this.dbconn.prepareStatement(query);
                byte[] planStr = ((JdbcOdbcStatement)pstmt).getOptionBytes(1105);
                json = new String(planStr, QueryFrame.db_lcode);
                stmt = pstmt;
            } else {
                stmt = this.dbconn.createStatement(1004, 1007);
                json = null;
            }
            this.watch.start();
            long execution_time = 0L;
            if (stmt.execute(query)) {
                ResultSet rs = stmt.getResultSet();
                ResultSetMetaData rsMetaData = rs.getMetaData();
                String tableName = rsMetaData.getTableName(1);
                String schemaName = rsMetaData.getSchemaName(1);
                int columnCount = rsMetaData.getColumnCount();
                String tables = "";
                if (schemaName != null && !schemaName.equals("") && tableName != null && !tableName.equals("")) {
                    tables = schemaName + "." + tableName;
                }
                for (int idx = 1; idx < columnCount; ++idx) {
                    String temp = rsMetaData.getTableName(idx + 1);
                    String temp1 = rsMetaData.getSchemaName(idx + 1);
                    if (tables.indexOf(temp) >= 0) continue;
                    tables = tables.equals("") ? temp1 + "." + temp : tables + "," + temp1 + "." + temp;
                }
                this.validStatement.put(query, new Command(query, json, tables, SQLTYPE.SELECT));
                int rowCount = 0;
                while (rs.next()) {
                    ++rowCount;
                }
                this.watch.stop();
                this.totalTime += this.watch.getElapsedTime();
                execution_time += this.watch.getElapsedTime();
                rs.close();
                stmt.close();
                Integer row = new Integer(rowCount);
                this.sb.append(row.toString() + " " + this.res.getString("rows_selected"));
                this.sb.append(" ");
                this.sb.append(this.res.getString("execution_time") + execution_time + " ms");
                this.sb.append(LINEFEED + END);
                this.out.write(this.sb.toString());
                this.out.flush();
            } else {
                int count = stmt.getUpdateCount();
                String act = query.substring(0, query.indexOf(" "));
                SQLTYPE type = SQLTYPE.OTHER;
                if (count >= 0) {
                    if (act.equalsIgnoreCase("insert")) {
                        this.sb.append(count + " " + this.res.getString("rows_inserted"));
                        type = SQLTYPE.INSERT;
                    } else if (act.equalsIgnoreCase("delete")) {
                        this.sb.append(count + " " + this.res.getString("rows_deleted"));
                        type = SQLTYPE.DELETE;
                    } else if (act.equalsIgnoreCase("update")) {
                        this.sb.append(count + " " + this.res.getString("rows_updated"));
                        type = SQLTYPE.UPDATE;
                    } else {
                        this.sb.append(count + " " + this.res.getString("rows_effected"));
                    }
                }
                this.validStatement.put(query, new Command(query, json, null, type));
                this.watch.stop();
                this.totalTime += this.watch.getElapsedTime();
                this.sb.append(" ");
                this.sb.append(this.res.getString("execution_time") + (execution_time += this.watch.getElapsedTime()) + " ms");
                this.sb.append(LINEFEED + END);
                stmt.close();
                stmt = null;
                this.out.write(this.sb.toString());
                this.out.flush();
            }
        }
        catch (SQLException sqle) {
            try {
                this.sb.append(this.res.getString("error") + " (" + sqle.getErrorCode() + "): " + sqle.getMessage());
                this.sb.append(LINEFEED + END);
                if (stmt != null) {
                    try {
                        stmt.close();
                        stmt = null;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.out.write(this.sb.toString());
                this.out.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public boolean isWindows() {
        String fileseparator = System.getProperty("file.separator");
        return fileseparator.equals("\\");
    }

    public void displayTime(long time) {
        QueryFrame.frame.setQueryTimeField(time);
    }

    class Command {
        String sql = null;
        String json = null;
        String tbname = null;
        SQLTYPE type = SQLTYPE.SELECT;

        Command(String sql, String json, String tbname, SQLTYPE type) {
            this.sql = sql;
            this.json = json;
            this.tbname = tbname;
            this.type = type;
        }
    }

    static enum SQLTYPE {
        INSERT,
        DELETE,
        UPDATE,
        SELECT,
        OTHER;

    }
}

