/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importXML;

import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dttwizard.importXML.DestinationDataSource;
import dttwizard.importXML.ImXmlDialog;
import dttwizard.importXML.TransferSetting;
import dttwizard.importXML.XmlDTD;
import dttwizard.importXML.XmlElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class SpecifyBase
extends AbstractWizardPanel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportXmlRes", LocaleManager.getLocale());
    private String title = this.res.getString("Page_title_specifybase");
    private ImXmlDialog imx = null;
    private AbstractWizardPanel previous = null;
    private AbstractWizardPanel next1 = null;
    private JTree tree = null;
    private JCheckBox columnAsAttribute_CheckBox = new JCheckBox(this.res.getString("Column_as_attribute"), false);
    private DefaultMutableTreeNode rootNode = null;
    private DefaultMutableTreeNode leafNode = null;
    private DefaultMutableTreeNode tmpNode = null;
    private DefaultTreeModel treeModel = null;
    private DefaultTreeSelectionModel tsmodel = new DefaultTreeSelectionModel();
    boolean initTreeResult = true;
    private JScrollPane jScrollPane1 = new JScrollPane();

    public SpecifyBase(ImXmlDialog imx, AbstractWizardPanel previous) {
        try {
            this.imx = imx;
            this.previous = previous;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton next_Button = new DbaButton(new Dimension(80, 24), false, this.res.getString("Next"), 'N', DBAImageResource.getResource(this.getClass(), "/dbautimages/next.gif"), new ReflectionAction(this, "next_Button_actionPerformed"));
        DbaButton back_Button = new DbaButton(new Dimension(80, 24), false, this.res.getString("Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "back_Button_actionPerformed"));
        DbaButton cancel_Button = new DbaButton(new Dimension(80, 24), false, this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancel_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        JPanel panel4 = new JPanel(new FlowLayout(2));
        JPanel panel6 = new JPanel(new BorderLayout());
        JPanel panel7 = new JPanel(new FlowLayout(0, 0, 0));
        JPanel panel8 = new JPanel();
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("Xml_file_has"));
        next_Button.setHorizontalTextPosition(2);
        panel8.setPreferredSize(new Dimension(80, 0));
        panel8.setBorder(null);
        this.jScrollPane1.setAutoscrolls(true);
        this.initTreeResult = this.initTree();
        this.jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        panel4.add(back_Button);
        panel4.add(next_Button);
        panel4.add(panel8);
        panel4.add(cancel_Button);
        panel4.add(help_Button);
        panel6.add((Component)this.columnAsAttribute_CheckBox, "North");
        panel6.add((Component)this.jScrollPane1, "Center");
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ImportXML.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ImportXml_SpecifyBase", null);
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        this.imx.Next(this.previous);
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        TreePath tp = this.tree.getSelectionPath();
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)tp.getLastPathComponent();
        if (dmtn.isRoot()) {
            GuiUt.showErrorDlg(this.imx, this.res.getString("The_base_element") + " " + dmtn.toString() + " " + this.res.getString("Is_a_root"), null);
            return;
        }
        if (dmtn.isLeaf() && !this.columnAsAttribute_CheckBox.isSelected()) {
            GuiUt.showErrorDlg(this.imx, this.res.getString("The_base_element") + " " + dmtn.toString() + " " + this.res.getString("Is_a_leaf"), null);
            return;
        }
        if (dmtn.toString() != this.imx.selectedBaseElement) {
            this.next1 = null;
            this.imx.baseElement = "";
            this.imx.selectedBaseElement = dmtn.toString();
        } else {
            this.imx.baseElement = "";
            this.setBaseElement(tp.toString());
        }
        if (this.columnAsAttribute_CheckBox.isSelected() != this.imx.asAttribute) {
            this.next1 = null;
        }
        if (this.next1 == null) {
            this.setBaseElement(tp.toString());
            if (this.imx.connection != null && this.imx.connection.isConnected && (this.imx.tbowner == null || this.imx.tbname == null)) {
                this.imx.connection.disconnect();
            }
            this.next1 = this.imx.tbowner == null || this.imx.tbname == null ? new DestinationDataSource(this.imx, this) : new TransferSetting(this.imx, this);
        }
        this.imx.asAttribute = this.columnAsAttribute_CheckBox.isSelected();
        this.imx.Next(this.next1);
    }

    void setBaseElement(String s) {
        this.imx.baseElement = "";
        s = s.substring(1, s.length() - 1);
        int index = 0;
        while ((index = s.indexOf(",")) > 0) {
            this.imx.baseElement = this.imx.baseElement + s.substring(0, index).trim();
            this.imx.baseElement = this.imx.baseElement + " ";
            s = s.substring(index + 1, s.length());
        }
        this.imx.baseElement = this.imx.baseElement + s;
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.imx.dispose();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public boolean initTree() {
        ImageIcon icon;
        this.imx.dtd = new XmlDTD();
        int result = 0;
        result = this.imx.dtd.getSchema(this.imx.sourceFileName);
        if (result != 0) {
            GuiUt.showErrorDlg(this.imx, this.res.getString("Xml_parser_connot") + " " + this.imx.sourceFileName + " " + this.res.getString("Please_check_your"), null);
            return false;
        }
        XmlElement xmlElement = this.imx.dtd.searchElement(this.imx.dtd.name);
        this.rootNode = new DefaultMutableTreeNode(xmlElement);
        Object element = null;
        XmlElement tempElement = null;
        for (int i = 0; i < xmlElement.child.size(); ++i) {
            tempElement = (XmlElement)xmlElement.child.elementAt(i);
            this.leafNode = new DefaultMutableTreeNode(tempElement, true);
            this.rootNode.add(this.leafNode);
            if (tempElement.child.size() <= 0) continue;
            this.tmpNode = new DefaultMutableTreeNode("", true);
            this.leafNode.add(this.tmpNode);
        }
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        TreeUI treeUI = this.tree.getUI();
        if (treeUI instanceof MetalTreeUI) {
            MetalTreeUI mTreeUI = (MetalTreeUI)treeUI;
            icon = DBAImageResource.getResource(this.getClass(), "/configimages/minus.gif");
            mTreeUI.setExpandedIcon(icon);
            icon = DBAImageResource.getResource(this.getClass(), "/configimages/plus.gif");
            mTreeUI.setCollapsedIcon(icon);
        }
        Object object = this.tree.getClientProperty("JTree.lineStyle");
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        icon = DBAImageResource.getResource(this.getClass(), "/dttimages/tree.gif");
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setClosedIcon(icon);
        renderer.setOpenIcon(icon);
        renderer.setLeafIcon(icon);
        this.tree.setCellRenderer(renderer);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                SpecifyBase.this.tree_treeWillExpand(e);
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent e) {
            }
        });
        this.jScrollPane1.getViewport().add((Component)this.tree, null);
        this.tsmodel.setSelectionMode(1);
        this.tree.setSelectionModel(this.tsmodel);
        TreePath aTreePath = this.tree.getPathForRow(0);
        this.tree.expandPath(aTreePath);
        this.tree.setSelectionPath(aTreePath);
        this.imx.selectedBaseElement = aTreePath.toString().substring(1, aTreePath.toString().length() - 1);
        return true;
    }

    void tree_treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        TreePath path = e.getPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node == null) {
            return;
        }
        node.removeAllChildren();
        XmlElement xmlElement = (XmlElement)node.getUserObject();
        Object tempElement = null;
        XmlElement element = null;
        for (int i = 0; i < xmlElement.child.size(); ++i) {
            element = (XmlElement)xmlElement.child.elementAt(i);
            this.tmpNode = new DefaultMutableTreeNode(element, true);
            node.add(this.tmpNode);
            if (element.child.size() <= 0) continue;
            this.tmpNode.add(new DefaultMutableTreeNode("", true));
        }
        this.tree.revalidate();
        this.tree.repaint();
    }
}

